@extends("layouts.master")
@section("style")
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/5.0.0/normalize.min.css"> --}}
<style>
    .thumb{
        margin: 10px 5px 0 0;
        width: 200px;
        height: 200px;
    }
</style>
@endsection
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            @if(!empty(@$data))
            <h1> {{__("application.Edit")}} {{__("application.Purchase")}}</h1>
            @else
            <h1> {{__("application.Create")}} {{__("application.Purchase")}}</h1>
            @endif
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Purchase")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            @if(!empty(@$data))
            {!! Form::model($data, ['method' => 'PATCH','route' => ['purchases.update', $data->id],'enctype' => 'multipart/form-data']) !!}
            @else
            {!! Form::open(array('route' => 'purchases.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            @endif
            @csrf
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Supplier")}} {{__("application.Name")}}:</strong>
                                     {!! Form::select('suppliers',$suppliers,@$data->supplier_id, array('class' => 'form-control select2')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Block")}} {{__("application.Name")}}:</strong>
                                     {!! Form::select('blog_id',$blogs,@$data->blog_id, array('class' => 'form-control select2','id'=>'blog-id','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Date")}} {{__("application.Purchase")}}:</strong>
                                     {!! Form::text('purchase_date',!empty(@$data->date)?date("d-m-Y",strtotime(@$data->date)):date("d-m-Y"), array('placeholder' => __('application.Date'),'class' => 'form-control date_picker text-date','required')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Project")}} {{__("application.Name")}}:</strong>
                                     {!! Form::select('project',$projects,@$project_id, array('class' => 'form-control select2','id'=>'project-con','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Invoice")}}:</strong>
                                     {!! Form::text('invoice',@$data->invoice_num, array('placeholder' => __('application.Invoice'),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Person")}} {{__("application.Recieve")}}:</strong>
                                     {!! Form::text('person_recieve',@$data->person_recieve, array('placeholder' => __('application.Person'),'class' => 'form-control')) !!}
                                </div>
                            </div>    
                          <!-- /.col -->
                        </div>
                        <div class="row" style="margin-bottom:50px !important;">
                            <div class="col-md-6">
                                <a class="btn btn-sm btn-primary" data-toggle="modal" href="#show_upload_image" title="upload image">Upload Image <i class="fas fa-upload"></i></a>
                                <div class="modal fade" id="show_upload_image">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">{{__("application.Image")}}</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="col-md-12">
                                                    <div class="card" style="border:1px solid #9CB7C8">
                                                        <div class="card-header">
                                                            <h3 class="card-title" style="color:  #299BE1">
                                                                <input type="file" onchange="loadPreviewInvoice(this)" name="image_invoice[]" multiple/>
                                                            </h3>
                                                        </div>
                                                        <div class="card-body" id="thumb-output">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row m-1" style="border:1px solid gray;padding: 15px;position: relative;">
                            <h4 style="position: absolute;top:-17px;left: 10px;background-color: white;color:#2E64FE">&nbsp;Product Info&nbsp;</h4>
                              <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Category")}}</strong>
                                    {!! Form::select('pro_category_id',$category, null, array('class' => 'form-control select2','id'=>'pro_category_id')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Qty")}} <span id="unit"></span></strong>
                                    {!! Form::text('pro_qty0', null, array('placeholder' => __('application.Qty'),'class' => 'form-control','id'=>'pro-qty')) !!}
                                </div>
                              </div>
                              <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}}:</strong>
                                     <select class="select2 form-control change_prefix_address product_list" id="product" name="pro_name0">
                                          <option value="">Please Select</option>}
                                          @foreach($products as $key =>$pro)
                                          <option id="pro_{{$pro->id}}" value="{{$pro->id}}" price="{{$pro->pro_price}}" code="{{$pro->pro_code}}" pro_name="{{$pro->pro_name}}" pro_id="{{$pro->id}}" pro_unit_name="{{$pro->unit_name}}">{{$pro->pro_name}}</option>}
                                          @endforeach
                                      </select>
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.Unit")}} {{__("application.Price")}} ($)</strong>
                                    {!! Form::text('pro_price0', null, array('placeholder' =>__('application.Price'),'id'=>'unit-price','class' => 'form-control')) !!}
                                </div>
                              </div>
                              <div class="row">&nbsp;</div>
                              <div class="col-md-12">
                                <button type="button" class="btn btn-info btn-sm" id="submit-proinfo">{{__('application.Submit')}}</button>
                              </div>
                              <div class="row">&nbsp;</div>
                              <div class="row"><br></div>
                              <table class="table table-bordered table-hover m-2" id="product-detail">
                                <thead>
                                    <tr>
                                        <th>{{__('application.Code')}} {{__('application.Product')}}</th>
                                        <th>{{__('application.Product')}} {{__('application.Name')}}</th>
                                        <th>{{__('application.Price')}} ($)</th>
                                        <th>{{__('application.Qty')}}</th>
                                        <th>{{__('application.Unit')}}</th>
                                        <th>{{__('application.Description')}}</th>
                                        <th>{{__('application.Action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(!empty(@$data_details))
                                        @foreach(@$data_details as $key=>$detail)
                                        <tr>
                                            <td><input type="text" name="product_code[]" value="{{ $detail->pro_code }}" class="form-control product_code" readonly><input type="hidden" name="product_id[]" value="{{ $detail->pro_id }}" class="form-control product_code" readonly></td>
                                            <td><input type="text" name="product_name[]" value="{{ $detail->pro_name }}" class="form-control" readonly></td>
                                            <td><input type="text" name="product_price[]" value="{{ $detail->unit_price }}" class="form-control"></td>
                                            <td><input type="text" name="product_qty[]" value="{{ $detail->qty }}" class="form-control"></td>
                                            <td><input type="text" name="unit[]" readonly value="{{ $detail->unit_id }}" class="form-control"></td>
                                            <td><textarea type="text" name="remark[]" class="form-control">{{ $detail->remark }}</textarea></td>
                                            <td>
                                                <a class="btn btn-sm btn-primary" data-toggle="modal" href="#show_upload_image-{{ $detail->pro_id }}" title="upload image"><i class="fas fa-upload"></i></a>
                                                <div class="modal fade" id="show_upload_image-{{ $detail->pro_id }}">
                                                    <div class="modal-dialog modal-xl">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title">{{__("application.Image")}}</h4>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="col-md-12">
                                                                    <div class="card" style="border:1px solid #9CB7C8">
                                                                        <div class="card-header">
                                                                            <h3 class="card-title" style="color:  #299BE1">
                                                                                <input type="file" pro_id = "{{ $detail->pro_id }}" onchange="loadPreview(this)" name="{{ $detail->pro_code }}[]" multiple/>
                                                                            </h3>
                                                                        </div>
                                                                        <div class="card-body" id="thumb-output-{{ $detail->pro_id }}">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="button" class="btn-remove btn btn-sm btn-danger"><i class="fa fa-times"></i></button>
                                            </td> 
                                        </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                              </table>
                          </div>
                        
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
                <br><br>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    $(document).on("change","#product",function () {
        $("#unit").empty();
        $("#unit").append("("+$(this).find(':selected').attr("pro_unit_name")+")");
    });
    $(document).on("change","#pro_category_id",function () {
        var id=$("#pro_category_id").val();
        var opt=`<option value='' disabled selected>please select</option>`;
        $(".main-spinner").show();
        $.ajax({
            dataType:'json',
            type:'post',
            url:'{{route("get_product_by_cate_pur")}}',
            data:{
                '_token':'{{csrf_token()}}',
                'pro_category_id':id,
            },
            success:function (data) {
                $("#product").empty();
                $.each(data,function (index,value) {
                    opt+=`<option id="pro_${value.id}" value="${value.id}" price="${value.pro_price}" code="${value.pro_code}" pro_name="${value.pro_name}" pro_id="${value.id}" pro_unit_name="${value.unit_name}">${value.pro_name}</option>`;
                });
                $("#product").append(opt);
            },
            complete:function(){
                $(".main-spinner").hide();
            }
        });
    })
    $(document).on('change',"#project-con",function(){
        var id=$(this).val();
        $.ajax({
            dataType:'json',
            type    :'post',
            url     :'{{route("get_blogs")}}',
            data    :{
                '_token':'{{csrf_token()}}',
                'project_id':id
            },
            success :function(data){
                $("#blog-id").empty();
                var opt='<option disabled>please select</option>';
                $.each(data,function(index,value){
                  opt+='<option value="'+value.id+'">'+value.name+'</option>';
                });
                $('#blog-id').append(opt);
            }
        });
    });
    $(document).on('click', '#submit-proinfo', function() {
        var val = $('.product_list').find(':selected').val();
        var code = $('.product_list').find(':selected').attr('code');
        var pro_id = $('.product_list').find(':selected').attr('pro_id');
        var name = $('.product_list').find(':selected').attr('pro_name');
        var unit=$(".product_list").find(":selected").attr("pro_unit_name");
        var qty = $('#pro-qty').val();
        var price = $('#unit-price').val();
        if(val == ""){
            $.alert({
                title: 'Alert!',
                content: 'Please Select Product!',
            });
        }
        else if (code == "" || name == "" || qty == "" || price == "") {
            $.alert({
                title: 'Alert!',
                content: 'Please Input Qty and Price!',
            });
        } else {
            var meme = false;
            $('.product_code').each(function() {
                var $post = $(this);
                if ($(this).val() == code) {
                    $.alert({
                        title: 'Duplicate Fields!',
                        content: 'This Product is Already Added!',
                    });

                    meme = true;
                    $post.addClass('focus');
                    setTimeout(function() {
                        $post.removeClass('focus');
                    }, 4000);
                    $('html, body').animate({
                        scrollTop: $post.offset().top
                    }, 1000);
                }
            });
            if (meme == false) {
                $('#product-detail').append(add_item(code, name, price, qty,pro_id,unit));
            }

        }
        var qty = $('#pro-qty').val("");
        var price = $('#unit-price').val("");
    });
    $(document).on('click', '.btn-remove', function() {
        $(this).parent().parent().remove();
    });
    function add_item(code, name, price, qty,pro_id,unit) {
        return `<tr>
                    <td><input type="text" name="product_code[]" value="${code}" class="form-control product_code" readonly><input type="hidden" name="product_id[]" value="${pro_id}" class="form-control product_code" readonly></td>
                    <td><input type="text" name="product_name[]" value="${name}" class="form-control" readonly></td>
                    <td><input type="text" name="product_price[]" value="${price}" class="form-control"></td>
                    <td><input type="text" name="product_qty[]" value="${qty}" class="form-control"></td>
                    <td><input type="text" name="unit[]" readonly value="${unit}" class="form-control"></td>
                    <td><textarea type="text" name="remark[]" class="form-control"></textarea></td>
                    <td>
                        <a class="btn btn-sm btn-primary" data-toggle="modal" href="#show_upload_image-${pro_id}" title="upload image"><i class="fas fa-upload"></i></a>
                        <div class="modal fade" id="show_upload_image-${pro_id}">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">{{__("application.Image")}}</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="col-md-12">
                                            <div class="card" style="border:1px solid #9CB7C8">
                                                <div class="card-header">
                                                    <h3 class="card-title" style="color:  #299BE1">
                                                        <input type="file" pro_id = "${pro_id}" onchange="loadPreview(this)" name="${code}[]" multiple/>
                                                    </h3>
                                                </div>
                                                <div class="card-body" id="thumb-output-${pro_id}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn-remove btn btn-sm btn-danger"><i class="fa fa-times"></i></button>
                    </td> 
                </tr>`;
    }
    function loadPreviewInvoice(input){
       var data = $(input)[0].files; //this file data
       $('#thumb-output').html("");
       $.each(data, function(index, file){
           if(/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)){
               var fRead = new FileReader();
               fRead.onload = (function(file){
                   return function(e) {
                       var img = $('<img/>').addClass('thumb').attr('src', e.target.result); //create image thumb element
                       $('#thumb-output').append(img);
                   };
               })(file);
               fRead.readAsDataURL(file);
           }
       });
    }
    function loadPreview(input){
       var data = $(input)[0].files; //this file data
       let pro_id = $(input).attr("pro_id");
       $('#thumb-output-'+pro_id).html("");
       $.each(data, function(index, file){
           if(/(\.|\/)(gif|jpe?g|png)$/i.test(file.type)){
               var fRead = new FileReader();
               fRead.onload = (function(file){
                   return function(e) {
                       var img = $('<img/>').addClass('thumb').attr('src', e.target.result); //create image thumb element
                       $('#thumb-output-'+pro_id).append(img);
                   };
               })(file);
               fRead.readAsDataURL(file);
           }
       });
    }
</script>
@endsection