@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.Edit")}} {{__("application.Product")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Product")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::model($product, ['method' => 'PATCH','route' => ['product-construction.update', $product->id],'enctype'=>'multipart/form-data']) !!}
            @csrf
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Code")}}:</strong>
                                     {!! Form::text('pro_code', null, array('placeholder' =>__('application.Product')." ".__('application.Code'),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Name")}}:</strong>
                                     {!! Form::text('pro_name', null, array('placeholder' => __('application.Product')." ".__('application.Name'),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Price")}}:</strong>
                                     {!! Form::text('pro_price', null, array('placeholder' => __('application.Price'),'class' => 'form-control')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Category")}}</strong>
                                    {!! Form::select('category',$category, $product->pro_category_id, array('class' => 'form-control select2')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Unit")}}</strong>
                                    {!! Form::select('unit',$unit, $product->pro_unit_id, array('class' => 'form-control select2')) !!}
                                </div>
                            </div>
                            <div class="col-md-12" id="image-list">
                                <div class="form-group image-container" style="float:left;">
                                    <strong>{{__("application.Photo")}}</strong>
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                    <div style="width: 154px;height: 100px;">
                                        @if(!empty($images[0]->image))
                                            <img src="{{asset('assets/img/upload/'.$images[0]->image)}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @else
                                            <img src="{{asset('assets/img/defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @endif
                                        
                                    </div>
                                    <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                    <label class="custom-file-upload">
                                        <input type="hidden" name="cpImage[]" value="{{!empty($images[0])?$images[0]->image:""}}" id="cpImage">
                                        <input type="file" id="file-image-ageny" name="photo[]" onchange="previewImage(event)" />
                                        <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                    </label>
                                </div>
                                @if(isset($images)&&!empty($images)&&count($images)>0)
                                  @foreach($images as $key=>$image)
                                   @if($key>0)
                                    <div class="form-group image-container" style="float:left;" id = "sub-container-image-{{$key+1}}">
                                      <strong>{{__("application.Photo")}}</strong>
                                      <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo-{{$key+1}}">
                                      <div style="width: 154px;height: 100px;">
                                          @if(!empty($image->image))
                                              <img src="{{asset('assets/img/upload/'.$image->image)}}" id="image-field-{{$key+1}}" style="width: 154px;height: 100px;border: 1px solid grey">
                                          @else
                                              <img src="{{asset('assets/img/defaultphoto.png')}}" id="image-field-{{$key+1}}" style="width: 154px;height: 100px;border: 1px solid grey">
                                          @endif
                                          
                                      </div>
                                      <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="remove_photo({{$key+1}})">{{__("application.Remove")}}</button>
                                      <label class="custom-file-upload">
                                          <input type="hidden" name="cpImage[]" value="{{!empty($image)?$image->image:""}}" id="cpImage-{{$key+1}}">
                                          <input type="file" id="file-image-ageny-{{$key+1}}" name="photo[]" onchange="previewImageMulti(event,{{$key+1}})" />
                                          <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                      </label>
                                    </div>
                                    @endif
                                  @endforeach
                                @endif
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
function RemoveImage(){
        var imageField = document.getElementById("image-field");
        var resource = document.getElementById("default-photo");
        var imge = document.getElementById("file-image-ageny");
        imge.value="";
        imageField.src = resource.src;
        document.getElementById("cpImage").value="";
    }
    function previewImage(event){
        var reader = new FileReader();
        var imageField = document.getElementById("image-field");
        reader.onload = function(){
            if(reader.readyState == 2){
                imageField.src = reader.result;
            }
        }
        document.getElementById("cpImage").value="";
        reader.readAsDataURL(event.target.files[0]);
    }
function remove_photo(obj){
  $("#sub-container-image-"+obj).remove();
}
function add_more_image(){
  var count_index = $("#image-list").find("div.image-container").length +1;
  $("#image-list").append(` <div class="form-group image-container" style="float:left;" id = "sub-container-image-${count_index}">
                                <strong>{{__("application.Photo")}}</strong>
                                <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo-${count_index}">
                                <div style="width: 154px;height: 100px;">
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" id="image-field-${count_index}" style="width: 154px;height: 100px;border: 1px solid grey">
                                </div>
                                <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="remove_photo(${count_index})">{{__("application.Remove")}}</button>
                                <label class="custom-file-upload">
                                    <input type="hidden" name="cpImage[]" value="" id="cpImage-${count_index}">
                                    <input type="file" id="file-image-ageny-${count_index}" name="photo[]" onchange="previewImageMulti(event,${count_index})" />
                                    <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                </label>
                            </div>`);
}
</script>
@endsection