@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.Report")}} {{__("application.Balance")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Report")}} {{__("application.Balance")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <form action="{{route('list_report_purchase_print')}}" method="POST" id="toggle-search">
              @csrf
                <div class="row">
                    <div class="col-xs-12 col-sm-6 col-md-6">
                        <div class="form-group">
                            <strong>{{__('application.Project')}}</strong> 
                            {!! Form::select('project_id[]', $projects, null, ['class' => 'form-control select2 project_id','multiple']) !!}
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-6">
                        <div class="form-group">
                            <strong>{{__('application.Block')}}</strong> 
                            {!! Form::select('blog_id[]',$blogs,null, array('class' => 'form-control select2 blog_id','multiple')) !!}
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-6">
                        <div class="form-group">
                            <strong>{{__('application.Category')}} {{__('application.Product')}}</strong> 
                            {!! Form::select('category[]', $categories, null, ['class' => 'form-control select2 category','multiple']) !!}
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-6">
                      <div class="form-group">
                          <strong>{{__('application.Product')}}</strong> 
                          {!! Form::select('product[]', $products, null, ['class' => 'form-control select2 product','multiple']) !!}
                      </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datatable-using" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th>{{__('application.No')}}</th>
                      <th>{{__('application.Block')}} </th>
                      {{-- <th>{{__('application.Project')}} </th> --}}
                      <th>{{__('application.Category')}}</th>
                      <th>{{__('application.Image')}}</th>
                      <th>{{__('application.Product')}}</th>
                      <th>{{__('application.Unit')}}</th>
                      <th>{{__('application.Qty')}} {{__('application.Purchase')}}</th>
                      <th>{{__('application.Qty')}} {{__('application.Using')}}</th>
                      <th>{{__('application.Balance')}}</th>
                  </tr>
                </thead>
                <tbody class="tbody">
                </tbody>
                {{-- <tfoot1 class="tfoot">
                    <tr>
                        <td colspan="7" class="text-right">Total : </td>
                        <td id="qty-purchase"></td>
                        <td id="qty-using"></td>
                        <td id="qty-stock"></td>
                    </tr>
                </tfoot1> --}}
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
  $(document).on("change","select.project_id",function(){
    $("#main-spinner").show();
    $.ajax({
      url:"{{ route('get_zone_by_project') }}",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        project_id : $(this).val()
      },
      success:function(data){
        var opt = ``;
        $.each(data,function(index,value){
          opt += `<option value="${value.id}">${value.name}</option>`;
        });
        $('select.blog_id').html(opt);
      },
      error:function(){
        toastr.warning("Error with your request ! Please try again.");
      },
      complete:function(){
        $("#main-spinner").hide();
      }
    });
  });
  function get_product_by_category(category_id){
    $("#main-spinner").show();
    $.ajax({
      url:"{{ route('get_product_by_category') }}",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        category_id : category_id
      },
      success:function(data){
        var opt = ``;
        $.each(data,function(index,value){
          opt += `<option value="${value.id}">${value.pro_name}</option>`;
        });
        $('select.product').html(opt);
      },
      error:function(){
        toastr.warning("Error with your request ! Please try again.");
      },
      complete:function(){
        $("#main-spinner").hide();
      }
    });
  }
  $(document).on("change","select.category",function(){
    get_product_by_category($(this).val());
  });
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datatable-using').DataTable({
          ordering:  false,
          "serverSide": true,
          "searching": false,
          responsive: false,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"searching()",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: {
            url:'/balance_report-get',
            type:"GET",
            data:function(d){
              var project_id  = $('select.project_id').val();
              var category = $('select.category').val();
              var product = $('select.product').val();
              var form_date   = $('input[name="form_date"]').val();
              var to_date     = $('input[name="to_date"]').val();
              var blog_id   = $('select.blog_id').val();

              d.project_id= project_id;
              d.category= category;
              d.product = product;
              d.form_date= form_date;
              d.to_date= to_date;
              d.blog_id= blog_id;
            }
          },
          columns: [
            {data: 'DT_RowIndex'},
            {data: 'name'},
            // {data: 'project_name'},
            {data: 'product_category_name'},
            {data: 'image'},
            {data: 'pro_name'},
            {data: 'unit_name'},
            {data: 'pur_qty'},
            {data: 'using_qty'},
            {data: 'balance_qty'},
          ],  

          "initComplete": function(settings, json) {
            $('.main-spinner').hide();
          },

          "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
 
            // converting to interger to find total
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            var cost_Total = api
                .column( 6 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
            var discount_Total = api
                .column( 7 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            var price_Total = api
                .column( 8 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
        
           
            $('#qty-purchase').html(parseFloat(cost_Total).toFixed(2));
            $("#qty-using").html(parseFloat(discount_Total).toFixed(2));
            $("#qty-stock").html(parseFloat(price_Total).toFixed(2));
          },
      });

      $.fn.dataTable.ext.errMode = 'throw';
});
</script>
<script type="text/javascript">
  
  function searching(){
    $('#datatable-using').DataTable().draw(true);
  }
  function print(){
    var title=`Report Balance Stock`;
    var user_name = "{{Auth::user()->name}}";
    var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
    var table_data = $("#datatable-using").html();
    var project_name = "";
    let i = 0;
    $("select.project_id option").each(function(index,value){
      if($(this).prop("selected")==true){
        i++;
        project_name += $(this).text();
        if(i<$(".project_id option:selected").length) project_name += " និង ";
      }
    });
    let p_name = '';
    if(project_name!=''){
      p_name = '( គម្រោង៖ '+project_name+' )';
    }
    print_report(title,table_data,user_name,date,p_name);// Refference at master page
  }
</script>
@endsection