@extends("layouts.master")
@section("content")
@include("client-payment.form-pay")
<style>
  div.dt-buttons{
    text-align: right;
    margin-bottom: 10px;
  }
  .dataTables_length{
    float: left;
  }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Arrears")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.POS Operation")}}</li>
              <li class="breadcrumb-item active">{{__("application.Arrears")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card" id="print-layout-nso">
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-arrear" class="table table-bordered table-hover text-nowrap">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Date")}} {{__("application.Payment")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Phone")}}</th>
                  <th>{{__("application.Item")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Category")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Project")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Qty")}} {{__("application.Of")}} {{__("application.late day")}}</th>
                  <th>{{__("application.Principal")}}($)</th>
                  <th>{{__("application.Interest")}}($)</th>
                  <th>{{__("application.Amount")}} {{__("application.Payment")}}($)</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).on("change","#pay-schedule-deposit-payment-method",function(){
      var payment_method = $(this).val();
      if(payment_method==1){
        $(".list-bank-information").html("");
      }else if(payment_method==2){
        var append_element = `
          <div class="row">
              <div class="col-md-6">
                  <div class="form-group" style="position: relative;">
                      <strong class="required">{{__("application.From")}} {{__("application.Bank")}} {{__("application.Name")}}:</strong>
                      {!! Form::select('from_bank_name',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                  </div>
              </div>
              <div class="col-md-6">
                  <div class="form-group">
                      <strong class="required">{{__("application.From")}} {{__("application.Bank")}} {{__("application.Account")}}:</strong>
                      {!! Form::text('from_bank_account',null, array('placeholder' => __("application.From")." ".__("application.Bank")." ".__("application.Account"),'class' => 'form-control','required')) !!}
                  </div>
              </div>
          </div>
          <div class="row">
              <div class="col-md-6">
                  <div class="form-group" style="position: relative;">
                      <strong class="required">{{__("application.To")}} {{__("application.Bank")}} {{__("application.Name")}}:</strong>
                      {!! Form::select('to_bank_name',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                  </div>
              </div>
              <div class="col-md-6">
                  <div class="form-group">
                      <strong class="required">{{__("application.To")}} {{__("application.Bank")}} {{__("application.Account")}}:</strong>
                      {!! Form::text('to_bank_account',null, array('placeholder' => __("application.To")." ".__("application.Bank")." ".__("application.Account"),'class' => 'form-control','required')) !!}
                  </div>
              </div>
          </div>
        `;
        $(".list-bank-information").html(append_element);
      }else if(payment_method==3){
        var append_element = `
          <div class="row">
              <div class="col-md-6">
                  <div class="form-group" style="position: relative;">
                      <strong class="required">{{__("application.Bank")}} {{__("application.Of")}} {{__("application.Cheque")}}:</strong>
                      {!! Form::select('bank_of_cheque',\Globals::bank_name(),null, array('class' => 'form-control select2','required')) !!}
                  </div>
              </div>
              <div class="col-md-6">
                  <div class="form-group">
                      <strong class="required">{{__("application.Cheque")}} {{__("application.Number")}}:</strong>
                      {!! Form::text('cheque_number',null, array('placeholder' => __("application.Cheque")." ".__("application.Number"),'class' => 'form-control','required')) !!}
                  </div>
              </div>
          </div>
        `;
        $(".list-bank-information").html(append_element);
      }
      $('.select2').select2({
        theme: 'bootstrap4'
      });
    });
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-arrear').DataTable({  
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          "scrollY": screen.height,
          "scrollX": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          ajax: "{{ route('arrears.get_data_index') }}",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'date_payment','name':'nso007_loan_process.date_payment'},
              {data: 'client_name','name':'nso007_client.name'},
              {data: 'client_phone','name':'nso007_client.phone'},
              {data: 'item_name','searchable': false},  
              {data: 'category_name','searchable': false},
              {data: 'project_name','searchable': false},
              {data: 'day_late','searchable': false},
              {data: 'principle_pay','searchable': false},
              {data: 'interest_amount_pay','searchable': false},
              {data: 'owe_amount_pay','searchable': false},
              {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  function display_form_pay(loan_process_id){
    var route="{{ route('datatable.get_data_for_payment') }}";
    $('.main-spinner').show();
    $.ajax({
      url:route,
      type:"post",
      dataType:"JSON",
      data:{
        "_token":"{{ csrf_token() }}",
        "loan_process_id":loan_process_id
      },success:function(data){
        $('.main-spinner').hide();
        $("#form-pay").modal("show");
        $("#loan-process-id").val(loan_process_id);
        $("#principle-for-pay").val(data.principle_pay);
        $("#interest-for-pay").val(data.interest_amount_pay);
        $("#amount-for-pay").val(data.owe_amount_pay);
        $("#pay-amount").val(data.owe_amount_pay);
        $("#date-for-pay").val(
          data.date_payment.split('-')[2]
          +"-"+
          data.date_payment.split('-')[1]
          +"-"+
          data.date_payment.split('-')[0]
        );
      }
    });
  }
</script>
@endsection