@extends("layouts.master")
@section("content")
<div class="modal fade" id="input-date-print">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Date Print</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <input type="text" id="date-print" class="form-control date_picker" value="{{date('d-m-Y')}}">
      </div>
      <div class="modal-footer justify-content-between">
        <a>&nbsp;</a>
        <button type="button" id="btn-to-print" class="btn btn-primary">OK</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="/* min-height: 4390.14px; */">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Cash")}} {{ __("application.Report") }}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Accounting")}}</li>
              <li class="breadcrumb-item active">{{__("application.Cash")}} {{ __("application.Report") }}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header">
                <div class="row mb-2">
                    <div class="col-sm-12 col-xs-12">
                        {!! Form::open(array('route' => 'voucher.print','method'=>'POST','id'=>'print-voucher')) !!}
                        <input type="hidden" name="voucher" id="voucher">
                        <div class="title-bar">
                            <button type="submit" class="float-right btn btn-xs btn-warning" data-toggle="tooltip" data-placement="top" title="Print Voucher" disabled="disabled" style="display: none;"><i class="fa fa-print" aria-hidden="true"></i></button>
                            {{-- <span class="btn-toggle btn btn-primary btn-xs float-right" style="margin-right: 5px"><i class="fa fa-caret-down"></i></span> --}}
                        </div>
                        {!! Form::close() !!}
                        <div class="toggle-div" style="display: none">
                            <div class="row">
                                <div class="form-group  col-sm-6 col-xs-12">
                                    <label>{{ __('application.last months') }}</label>
                                    {!! Form::select('last_months',\Globals::last_month_count(), null, ['placeholder'=>'Please Select','class' => 'form-control select2','id'=>'last_months']) !!}
                                </div>
                                <div class="form-group  col-sm-6 col-xs-12">
                                    <label>Select Project</label>
                                    {!! Form::select('journal_by_project[]', $projects, null, ['class' => 'form-control select2','id'=>'project_id','multiple']) !!}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">Start Date</label>
                                    <input type="text" class="form-control date_picker start_date">
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">End Date</label>
                                    <input type="text" class="form-control date_picker end_date">
                                </div>
                            </div>
                            <br>
                            <div class="row">
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">Account Name</label>
                                    {!! Form::select('ref_account_chart[]',\Globals::get_account_code("",0), null, ['class' => 'form-control select2','id'=>'ref_account_chart','multiple']) !!}
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <label for="">{{__("application.Cash")}} {{__("application.Type")}}:</label>
                                    {!! Form::select('cash_type',\Globals::cash_type(),null, array('class' => 'form-control select2','placeholder'=>'Please Select','required')) !!}
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-xs-12">
                                    <label for="">Transaction Type</label>
                                    {!! Form::select('transaction_type[]',$transaction_type, null, ['class' => 'form-control select2','id'=>'transaction_type','multiple']) !!}
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-sm-12 col-xs-12" style="text-align: right">
                                    <button type="button" style="margin-top: 30px;" class="btn btn-warning btn-sm" onclick="search_journal()"> Search <span class="fa fa-search"></span></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body table-responsive">
                <table id="table_journal" class="table table-bordered table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Date</th>
                            <th>Account Name</th>
                            <th>Cash Type</th>
                            <th>Description</th>
                            <th>Cash In</th>
                            <th>Cash Out</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
</div>
@endsection
@section('js')
<script>
    function search_report(obj){
        $('.toggle-div').toggle('fast');
    }
    function get_debit_credit(){
        let total = 0;
        $("table#table_journal").find("tbody#tbody").find("tr").each(function(index,value){
            total = total + parseFloat($(this).attr('debit_credit'));
            console.log(total);
            $(this).find("td:eq(7)").html("$"+total.toFixed(2));
        });
    }
    $(document).ready(function() {
        $('#table_journal').DataTable({
            "ordering":true,
            "searching" :false,
            "serverSide":true,
            responsive: false,
            "lengthMenu": [
                [20, 50, 100, 250, 500,1000],
                [20, 50, 100, 250, 500,100]
            ],
            dom: 'Blfrtip',
            buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
            ajax: {
                url:"{{ route('accounting.cash_report') }}",
                type:"GET",
                data:function(d){
                    d.project_id = $("#project_id").val();
                    d.start_date = $(".start_date").val();
                    d.end_date = $(".end_date").val();
                    d.cash_type = $("select[name=cash_type]").val();
                    d.last_months = $("#last_months").val();
                    d.ref_account_chart = $("#ref_account_chart").val();
                    d.transaction_type = $("#transaction_type").val();
                }
            },
            columns: [
                { data: 'DT_RowIndex',  orderable: false, searchable: false},
                {
                    data: 'journal_paydate'
                },
                {
                     data: 'account_name'
                },
                {
                    data: 'acc_name'
                },
                {
                    data: 'journal_des'
                },
                {
                    data: 'journal_debit'
                },
                {
                    data: 'journal_credit'
                },
                {
                    data: 'balance'
                },
            ],
            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            },
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
</script>
<script type="text/javascript">
    function search_journal() {
        $('#table_journal').DataTable().draw(true);
    }
    function print(){
        var title=`Report Cash<br> ( `+$(".start_date").val()+" to "+$(".end_date").val()+" )";
        if(($(".start_date").val()==''||$(".start_date").val()==null)&&($(".end_date").val()==''||$(".end_date").val()==null)){
            title = 'Report Cash';
        }
        var user_name = "{{Auth::user()->name}}";
        var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
        var table_data = $("#table_journal").html();
        var project_name = "";
        let i = 0;
        $("select#project_id option").each(function(index,value){
        if($(this).prop("selected")==true){
            i++;
            project_name += $(this).text();
            if(i<$("#project_id option:selected").length) project_name += " និង ";
        }
        });
        let p_name = '';
        if(project_name!=''){
        p_name = '( គម្រោង៖ '+project_name+' )';
        }
        print_report_operation(title,table_data,user_name,date,p_name);// Refference at master page
    }
</script>
@endsection
