@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Balance Sheet</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Accounting</li>
              <li class="breadcrumb-item active">Balance Sheet</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <form action="{{route('print.balance-sheet')}}" method="POST">
                @csrf
                {{method_field('POST')}}
                <div class="title-bar m-4">
                    <?php
                    $start  = new DateTime('first day of this month');
                    $end    = new DateTime('last day of this month');
                    $from   = $start->format('d/m/Y');
                    $to     = $end->format('d/m/Y');
                    ?>
                    <span class="title-tab">
                        {{-- <span class="text-tab"> Balance Sheet >> <span id="start_date">{{$from}}</span> >> <span id="end_date">{{$to}}</span> </span> --}}
                        <button type="submit" class="btn btn-tab btn-ms btn-warning float-right"><i class="fa fa-print"></i></button>
                        <span class="btn-toggle btn btn-primary btn-ms float-right" style="margin-right:5px"><i class="fa fa-search"></i></span>
                        <input type="hidden" name="report" value="Balance Sheet">
                    </span>
                </div>
                <div class="toggle-div m-4" style="display:none">
                    <div class="form-group row">
                        <div class="form-group  col-sm-4 col-xs-4">
                            <label>Select Project</label>
                            {!! Form::select('journal_by_project', $projects, null, ['class' => 'form-control select2','id'=>'project_id']) !!}
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label for="">Start Date</label>
                            <input type="text" name="from" class="form-control start_date date_picker">
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label for="">End Date</label>
                            <input type="text" name="to" id="" class="form-control end_date date_picker">
                        </div>
                        <div class="col-sm-12 col-xs-12" style="text-align: right">
                            <button type="button" class="btn btn-warning" style="margin-top: 10px;" onclick="search()"><i class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.card-header -->
            <div class="card-body">
                <table id="table_journal" class="table table-bordered table-striped table table-condensed table-hover">
{{--                <thead>--}}
{{--                    <tr>--}}
{{--                        <th>Account Code #</th>--}}
{{--                        <th>Account Name</th>--}}
{{--                        <th>Debit</th>--}}
{{--                        <th>Credit</th>--}}
{{--                    </tr>--}}
{{--                </thead>--}}
                    <tbody id="tbody"></tbody>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
                <h3 class="modal-title text-danger">Warning...!</h3>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-10">
                        <h4>Receivable amount must be smaller than or equal available amount.</h4>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@endsection
@section('js')
<script type="text/javascript">
    $(document).ready(function() {
        $.ajax({
            url: "{{ route('accounting-report.get-balance-sheet')}}",
            method: "get",
            dataType: "text",
            data: {
                _token: '{{ csrf_token() }}',
            },
            success: function(data) {
                $('#tbody').append(data);
            }
        });
    });
    $(document).on('click', '.clickable-row', function() {
        window.location = $(this).data("href");
    });
    $(document).on('click', '.btn-toggle', function() {
        $('.toggle-div').toggle('fast');
    });

    function search() {
        var from = $('.start_date').val();
        var to = $('.end_date').val();
        var project_id = $('#project_id').val();
        if (from == "" || to == "") {
            $.alert({
                title: 'Error',
                icon: 'fa fa-warning',
                type: 'orange',
                content: 'Something went wrong, please retry again.' +
                    '<hr>' +
                    'Note: No Date Selected',
            });
            return false;
        } else {
            $.ajax({
                url: "{{ route('accounting-report.get-balance-sheet')}}",
                method: "POST",
                dataType: "text",
                data: {
                    from: from,
                    to: to,
                    project_id: project_id,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                    $('#start_date').text(from);
                    $('#end_date').text(to);
                    $('#tbody').empty();
                    $('#tbody').append(data);
                }
            });
        }
    }
</script>
@endsection
