@extends("layouts.master")
@section("content")
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Edit Journal</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">Edit Journal</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        {!! Form::model($journal[0], ['method' => 'PATCH','route' => ['journal.update', $journal[0]->id],'enctype'=>'multipart/form-data']) !!}
                        <div class="card card-default">
                            <div class="card-body">
                                <div class="row">
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="required">Date</label>
                                        {!! Form::text('journal_paydate', date('d-m-Y',strtotime($journal[0]->journal_paydate)), array('placeholder' => 'Date','class' => 'form-control date_picker','id' => 'date','required')) !!}
                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12">
                                        <label class="required">Voucher Type</label>
                                        {!! Form::select('voucher_type',$voucher,$journal[0]->voucher_type,['class'=>'form-control select2','id'=>'voucher_type','required']) !!}
                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12">
                                        <label for="required">Select Project</label>
                                        {!! Form::select('journal_by_project', $projects, null, ['class' => 'form-control select2','id'=>'project_id']) !!}
                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="required">Voucher Ref</label>
                                        {!! Form::text('voucher_ref', null, array('placeholder' => 'Voucher Ref','class' => 'form-control', 'id' => 'voucher_ref','readonly','required')) !!}
                                    </div>
                                    <div class="form-group col-sm-6 col-xs-12" id="available-box">
                                        <label class="">Description</label>
                                        {!! Form::textarea('journal_des', null, ['id' => 'description', 'rows' => 4, 'cols' => 54, 'class' => 'form-control']) !!}
                                    </div>
                                    <div class="col-sm-12 col-xs-12">
                                        <table class="table table-bordered table-striped table-hover">
                                            <thead>
                                            <tr>
                                                <th width="15%">Account Name</th>
{{--                                                <th width="15%">Account Type Name</th>--}}
{{--                                                <th width="15%">Account Name</th>--}}
{{--                                                <th width="15%">Sub Account Name</th>--}}
                                                <th>Ref Number</th>
                                                <th>Debit</th>
                                                <th>Credit</th>
                                                <th>Action</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tbody">
                                            @foreach($journal as $i => $jn)
                                                <tr>
                                                    <td>{!! Form::select('acc_chart[]', $acc_chart, $jn->journal_acccode, ['class' => 'form-control select2 account_chart','required']) !!}</td>
{{--                                                    <td>{!! Form::select('account_code[]', $select_type_arr[$i], $selectedSubType[$i]->id, ['class' => 'form-control select2 account_code','required']) !!}</td>--}}
{{--                                                    <td>{!! Form::select('account_code1[]', $select_acc_arr[$i], $selectedSubAccType[$i]->id, ['class' => 'form-control select2 account_code','required']) !!}</td>--}}
{{--                                                    <td>{!! Form::select('account_code2[]', $select_sub_arr[$i], $selectedSubAcc[$i], ['class' => 'form-control select2 account_code']) !!}</td>--}}
                                                    <td><input type="text" name="ref_number[]" value="{{$jn->journal_invoice}}" class="form-control" placeholder="Reference Number" required></td>
                                                    <td><input type="text" name="debit[]" value="{{$jn->journal_debit}}" class="form-control" placeholder="Debit" required></td>
                                                    <td><input type="text" name="credit[]" value="{{$jn->journal_credit}}" class="form-control" placeholder="Credit" required></td>
                                                    <td>
                                                        <input type="hidden" name="journal_id[]" value="{{$jn->id}}">
                                                        @if($i==1)
                                                            <button type="button" class="btn btn-info btn-sm btn-add"><i class="fa fa-plus"></i></button>
                                                        @elseif($i>1)
                                                            <button type="button" class="btn btn-danger btn-sm btn-remove"><i class="fa fa-trash"></i></button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div style="text-align: right;">
                                    <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> Save</button>
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title text-danger">Warning...!</h3>
                </div>
                <br />
                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-10">
                            <h4>Receivable amount must be smaller than or equal available amount.</h4>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).on('click', '.btn-add', function() {
            //$('select').select2('destroy');
            $('#tbody').append(add_journal());
            $('.select2').select2({
                theme: 'bootstrap4'
            });
        });
        $(document).on('change', '.account_code', function() {
            var obj     = $(this).find(":selected").val();
            var element = $(this);
            if (obj    != "") {
                account_code(obj,element);
            }
            else{
                element.parent().next().find('.account_code').empty();
            }
        });
        $(document).on('click', '.btn-remove', function() {
            $(this).parent().parent().remove();
        });

        function account_code(obj,element) {
            var div = "";
            $('.main-spinner').show();
            $.ajax({
                url: "{{ route('search-account-code')}}",
                method: "POST",
                dataType: "json",
                data: {
                    obj: obj,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                    $('.main-spinner').hide();
                    if(Object.keys(data).length){
                        element.parent().next().find('.account_code').empty().append(`<option value=""> Please Select </option>`);
                        $.each(data, function(index, value){
                            element.parent().next().find('.account_code').append($("<option></option>").attr("value",value.id).text(value.id +" | "+value.acc_name));
                        });
                    }
                    else{
                        element.parent().next().find('.account_code').empty();
                         element.parent().next().find('.account_code').empty().append(`<option value=""> Please Select </option>`);
                    }
                }
            });
        }

        function add_journal() {
            var tr = `<tr>
                   <td>{!! Form::select('acc_chart[]', $acc_chart, null, ['class' => 'form-control select2 account_chart','required']) !!}</td>
                    <td><input type="text" name="ref_number[]" class="form-control account" placeholder="Reference Number" required></td>
                    <td><input type="text" name="debit[]" value="0" class="form-control" placeholder="Debit" required></td>
                    <td><input type="text" name="credit[]" value="0" class="form-control" placeholder="Credit" required></td>
                    <td><button class="btn btn-danger btn-sm btn-remove"><i class="fa fa-trash"></i></button></td>
                </tr>`;
            return tr;
        }
    </script>
@endsection
