$(document).ready(function() {
    $('#table_journal').DataTable({
        "ordering": false,
        "searching": false,
        "lengthMenu": [
            [10, 20, 50, 100, 250, 500],
            [10, 20, 50, 100, 250, 500]
        ],
        dom: 'Blfrtip',
        buttons: [{
                text: '<i class="fa fa-search"></i>',
                titleAttr: 'Filter',
                className: "btn btn-default btn-md",
                attr: {
                    id: 'btn-search',
                    onclick: "search_report(this)",
                    style: "background-color:#88B21F;color:white"

                }
            },
            {
                text: '<i class="fa fa-print"></i>',
                titleAttr: 'Print',
                className: "btn btn-success btn-md",
                attr: {
                    id: 'print-report-accounting',
                    disabled: "true"
                }
            },
        ],
        ajax: "/get-journal",
        columns: [{
                data: 'checkbox'
            },
            {
                data: 'id'
            },
            {
                data: 'journal_paydate'
            },
            {
                data: 'project_name'
            },
            {
                data: 'voucher'
            },
            {
                data: 'voucher_ref'
            },
            {
                data: 'account_code'
            },
            {
                data: 'journal_invoice'
            },
            {
                data: 'journal_des'
            },
            {
                data: 'journal_debit'
            },
            {
                data: 'journal_credit'
            },
            {
                data: 'action'
            },
        ],
        "initComplete": function(settings, json) {
            $('.main-spinner').hide();
        },
        "footerCallback": function(row, data, start, end, display) {
            var api = this.api(),
                data;

            // converting to interger to find total
            var intVal = function(i) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '') * 1 :
                    typeof i === 'number' ?
                    i : 0;
            };

            var Total_Owned = api
                .column(9)
                .data()
                .reduce(function(a, b) {
                    return intVal(a) + intVal(b);
                }, 0);
            var Total_Received = api
                .column(10)
                .data()
                .reduce(function(a, b) {
                    return intVal(a) + intVal(b);
                }, 0);
            var currentcyFormat = $.fn.dataTable.render.number('\,', '.', 2, '$').display;
            $(api.column(9).footer()).html(currentcyFormat(Total_Owned));
            $(api.column(10).footer()).html(currentcyFormat(Total_Received));
        },
    });

    $.fn.dataTable.ext.errMode = 'throw';
});