<?php

namespace App\Providers;

use App\ItemModel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use App\User;
use Auth;
use View;
use App\ClientModel;
use App\LoanProcessModel;
use App\LoanPaidModel;
use DateTime;
use DB;
use App\LoanModel;
use App\SaleModel;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //Auto Sign out when user status change to 0:Inactive or 2:Deleted
        view::composer("layouts.master",function($view){
            $id=Auth::user()->id;
            $data=User::find($id);
            if($data->status==0||$data->status==2){
                auth()->logout();//more code(js) in master.blade.php
            }
        });
        //End
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);
        View::composer('layouts.page',function($view){
            $curr_date = date("Y-m-d");
            $count_arrear = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                ->where("nso007_loan.status",1)
                ->where("nso007_loan_process.status",1)
                ->where("nso007_loan_process.date_payment","<",$curr_date)
                ->where("nso007_loan_process.owe_amount_pay",">",0)
                ->count();
            $contract = SaleModel::where(DB::raw('TIMESTAMPDIFF(DAY,nso007_sale_stock.date_on_contract,"' . $curr_date . '")'),">=",-1)
                ->where("nso007_sale_stock.type",1)
                ->where("nso007_sale_stock.status",1)
                ->count();
            
            $count_payment = LoanProcessModel::join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
                ->where("nso007_loan.status",1)
                ->where("nso007_loan_process.status",1)
                ->where(DB::raw('TIMESTAMPDIFF(DAY,nso007_loan_process.date_payment,"' . $curr_date . '")'),">=",-1)
                ->where(DB::raw('TIMESTAMPDIFF(DAY,nso007_loan_process.date_payment,"' . $curr_date . '")'),"<",1)
                ->where("nso007_loan_process.owe_amount_pay",">",0)
                ->count();
            
            $view->with(compact('count_arrear','contract','count_payment'));
        });
        View::composer("home",function($view){

            $first_date = new DateTime("first day of January ". date('Y'));

            $last_date = new DateTime("last day of December ". date('Y'));

            $clients = ClientModel::where("type",1)->where('status',1)->count();

            $Total_completed_payment =LoanModel::join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.amount_os","<=",1)
                    ->groupBy("nso007_loan.id")
                    ->get();
            $data=0;

            foreach ($Total_completed_payment as $key => $value) {
                $data+= $value->sale_amount-$value->discount_amount;
            }

            $Total_collected_payment = LoanPaidModel::select(DB::raw("SUM(nso007_loan_paid.total_amount) as T_total_amount"))->where("nso007_loan_paid.status",1)->first();
            $Total_collected_priciple = optional(LoanPaidModel::where("nso007_loan_paid.status",1)->select(DB::raw("SUM(nso007_loan_paid.principle) as T_principle"))
            ->first())->T_principle;
            $Total_collected_interest = optional(LoanPaidModel::where("nso007_loan_paid.status",1)->select(DB::raw("SUM(nso007_loan_paid.interest) as T_interest"))
            ->first())->T_interest;
            $Total_collected_penalty = optional(LoanPaidModel::where("nso007_loan_paid.status",1)->select(DB::raw("SUM(nso007_loan_paid.penalty) as T_penalty"))
            ->first())->T_penalty;

            // $collected_payment_by_year = LoanPaidModel::whereBetween("payment_date",[$first_day_year,$last_day_year])
            //         ->select('nso007_loan_paid.total_amount')
            //         ->get();

            $Total_colllection_payment =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)->where("nso007_loan_process.status",1)
                    ->select(DB::raw('SUM(nso007_loan_process.owe_amount_pay) as Total_owe_amount_pay'))
                    ->first();

            $Total_completed_payment1 = $data;

            $Total_sold_item = ItemModel::where("stock_status",2)->where('sale_stock',2)->select(DB::raw("SUM(price) as sale_price"))->first();
            $Total_sold_item_price = 0;
            if(!empty($Total_sold_item)) $Total_sold_item_price = $Total_sold_item->sale_price;

            $Total_deposit_item = ItemModel::where("stock_status",2)->where('sale_stock',1)->select(DB::raw("SUM(price) as deposit_sale_price"))->first();
            $Total_deposit_item_price = 0;
            if(!empty($Total_deposit_item)) $Total_deposit_item_price = $Total_deposit_item->deposit_sale_price;

            $Total_all_item_price = 0;
            $Total_all_item = ItemModel::select(DB::raw("SUM(price) as total_item_price"))->first();
            if(!empty($Total_all_item)) $Total_all_item_price = $Total_all_item->total_item_price;

            $Total_available_item_price = 0;
            $Total_available_item = ItemModel::where("stock_status",1)->select(DB::raw("SUM(price) as available_sale_price"))->first();
            if(!empty($Total_available_item)) $Total_available_item_price = $Total_available_item->available_sale_price;

            $Total_unavailable_items = ItemModel::where("stock_status",2)->count();

            $total_discount = 0;
            $total_sale_discount = DB::table('nso007_sale_stock')->where("status",1)->select(DB::raw("SUM(discount_amount) as total_discount"))->first();
            if(!empty($total_sale_discount)){
                $total_discount = $total_sale_discount->total_discount;
            }

            $view->with(compact("clients","Total_collected_payment","Total_colllection_payment","Total_completed_payment1","first_date","last_date",'Total_sold_item_price','Total_available_item_price','Total_deposit_item_price','Total_all_item_price','Total_collected_priciple','Total_collected_interest','Total_unavailable_items','total_discount','Total_collected_penalty'));
        });
    }
}
