<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Optional;

class LeaveType extends Model
{
    protected $table = 'leave_types';
    protected $fillable = ['name'];



    public static function getLeaveTypeName ($id){
        if ($id){
            return \optional(self::find($id))->name;
        }
        return null;
    }

    function getFullNameAttribute(){
        return ucfirst(str_replace('_',' ', "{$this->name}"));
    }
}
