<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;

class HrResignModel extends Model
{
    protected $table = "users_resign";

    protected  $casts = [
        'educate' => 'array',
        'language' => 'array',
        'emergency_contact' => 'array',
        'family' => 'array',
        'family_full' => 'array',
        'work_experience' => 'array'
    ];

    public function branchs()
    {
        return $this->belongsTo('App\Models\Hr\HrBranch','branch_id', 'id');
    }
    public function departments()
    {
        return $this->belongsTo('App\Models\Hr\HrDepartmentModel','department_id','id');
    }
    public function positions()
    {
        return $this->belongsTo('App\Models\Hr\HrPositionModel','position_id','id');
    }
}
