<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;

class HrJobPostModel extends Model
{
    protected $table = 'nso007_hr_job_post';

    public function get_department(){
        return $this->belongsTo('App\Models\Hr\HrDepartmentModel','department','id');
    }
    public function get_employment(){
        return $this->belongsTo('App\Models\Hr\HrJobEmploymentTypeModel','employment_type','id');
    }
    public function get_exp_level(){
        return $this->belongsTo('App\Models\Hr\HrExpLevelModel','exp_level','id');
    }
    public function get_job_function(){
        return $this->belongsTo('App\Models\Hr\HrJobFunctionModel','job_function','id');
    }
    public function get_education_level(){
        return $this->belongsTo('App\Models\Hr\HrJobEducationLevelModel','education_level','id');
    }
    public function get_location(){
        return $this->belongsTo('App\ProvinceModel','location','province_id');
    }
}
