<?php

namespace App\Models\Hr;

use Illuminate\Database\Eloquent\Model;

class HrEmployeePromoteModel extends Model
{
    protected $table = "users_promote";

    protected $casts = [
        'educate'           => 'array',
        'language'          => 'array',
        'emergency_contact' => 'array',
        'family'            => 'array',
        'family_full'       => 'array',
        'work_experience'   => 'array'
    ];

    public function get_branch()
    {
        return $this->belongsTo('App\Models\Hr\HrBranch','branch_id', 'id');
    }
    public function get_department()
    {
        return $this->belongsTo('App\Models\Hr\HrDepartmentModel','department_id','id');
    }
    public function get_position()
    {
        return $this->belongsTo('App\Models\Hr\HrPositionModel','position_id','id');
    }
}
