<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProjectModel;
use App\CategoryModel;
use DB;
use App\BlockModel;
use DataTables;
use App\ProductConModel;
class UsingReport extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Using-Report-Construction-List', ['only' => ['index','using_report_get']]);
    }
    public function index()
    {
        $projects = ProjectModel::select(
            DB::raw('name AS project_mixed'),'id')
            ->pluck('project_mixed','id');
        $supps = DB::table('construction_supplier')->select(
            DB::raw('CONCAT(supp_name," | ",supp_phone) AS supplier'),'id')
            ->pluck('supplier','id');
        $blogs=BlockModel::select("nso007_block.name","nso007_block.id",DB::raw("CONCAT(nso007_project_stock.name,' | ',nso007_block.name) as blog_pro"))->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->pluck("blog_pro",'id');
        $products=ProductConModel::select(DB::raw("CONCAT(pro_code,' | ',pro_name) as product"),"id")->pluck("product","id");
        return view('construction-report.using-report.index',compact('projects','supps','blogs','products'));
    }

    public function using_report_get(Request $request)
    {
        # code...
        if ($request->isMethod('GET')){

            $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
            $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
            $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
            $project=isset($request->project_id)? $request->project_id:NULL;
            $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
            $last_months = $request->last_months;
            $date_from='';
            $date_to='';
            $product_id=isset($request->pro_id)?$request->pro_id:NULL;

             $usingproducts_total=DB::table('nso007_using_stock')
                ->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
                ->join("product","product.id","nso007_using_stock.product_id")
                ->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")
                ->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_block","nso007_block.id","nso007_using.blog_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
                ->select("nso007_using.date","nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name","nso007_block.id as b_id","product.id as p_id")
                ->groupBy("nso007_using_stock.id")
                  ->get();

            $usingproducts_filter=DB::table('nso007_using_stock')
            ->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
                ->join("product","product.id","nso007_using_stock.product_id")
                ->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")
                ->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")
                ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
                ->join("nso007_block","nso007_block.id","nso007_using.blog_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
                ->join("unit","unit.id","product.pro_unit_id")
                ->select("nso007_using.date","nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name","nso007_block.id as b_id","product.id as p_id")
                ->groupBy("nso007_using_stock.id")
                ->when(request('supps_id'),function($query) use ($supps_id){
                    $query->whereIn('construction_supplier.id',$supps_id);
                  })
                  ->when(request('project_id'),function($query) use ($project){
                    $query->whereIn('nso007_project_stock.id',$project);
                  })
                  ->when(request('blog_id'),function($query) use ($blog_id){
                    $query->whereIn('nso007_block.id',$blog_id);
                  })
                  ->when(request('form_date',''), function($query) use($form_date,$to_date){
                      $query->whereBetween('nso007_using.date',[$form_date,$to_date]);
                  })
                  ->where(function($query) use($last_months){
                    if(!empty($last_months)){
                      $query->whereBetween('nso007_using.date',\Globals::the_last_month($last_months));
                    }
                  })
                  ->when(request('pro_id'),function ($query) use ($product_id){
                    $query->whereIn("product.id",$product_id);
                  })
                  ->groupBy("nso007_using_stock.id")
                  ->get();

          $usingproducts=DB::table('nso007_using_stock')
          ->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
            ->join("product","product.id","nso007_using_stock.product_id")
            ->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")
            ->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")
            ->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")
            ->join("nso007_block","nso007_block.id","nso007_using.blog_id")
            ->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")
            ->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_using.date","nso007_block.name","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name","nso007_block.id as b_id","product.id as p_id")
            ->groupBy("nso007_using_stock.id")
            ->when(request('supps_id'),function($query) use ($supps_id){
                    $query->whereIn('construction_supplier.id',$supps_id);
                  })
                  ->when(request('project_id'),function($query) use ($project){
                    $query->whereIn('nso007_project_stock.id',$project);
                  })
                  ->when(request('blog_id'),function($query) use ($blog_id){
                    $query->whereIn('nso007_block.id',$blog_id);
                  })
                  ->when(request('form_date',''), function($query) use($form_date,$to_date){
                      $query->whereBetween('nso007_using.date',[$form_date,$to_date]);
                  })
                  ->where(function($query) use($last_months){
                    if(!empty($last_months)){
                      $query->whereBetween('nso007_using.date',\Globals::the_last_month($last_months));
                    }
                  })
                  ->when(request('pro_id'),function ($query) use ($product_id){
                    $query->whereIn("product.id",$product_id);
                  })
                  ->groupBy("nso007_using_stock.id")
              ->take(20);
            return Datatables::of($usingproducts)
                    ->addIndexColumn()
                    ->with([
                        "recordsTotal" => count($usingproducts_total),
                         "recordsFiltered" => count($usingproducts_filter)
                      ])
                    ->editColumn('date',function($usingproducts){
                      return date("d-m-Y",strtotime($usingproducts->date));
                    })
                    ->editColumn("qty",function($usingproducts){
                      return $usingproducts->qty-$usingproducts->return_qty;
                    })
                    ->make(true);
        }
        else{
          dd("OK");
            $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
            $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
            $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
            $project=isset($request->project_id)? $request->project_id:NULL;
            $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
            $date_from='';
            $date_to='';
            $product_id=isset($request->pro_id)?$request->pro_id:NULL;
            $opt_search=$request->opt_search;
            if(empty($request->start_date)&&empty($request->end_date)&&!empty($opt_search)){
                if($opt_search==1){
                    $date_from=date('Y-m-d');
                    $date_to=date('Y-m-d');
                }elseif($opt_search==2){
                    $date_from = Carbon::now()->endOfMonth()->subMonth()->toDateString();
                    $date_to = Carbon::now()->endOfMonth()->toDateString();
                }
                else{
                    $date_from='';
                    $date_to='';
                }
            }
            $usingproducts=DB::table('nso007_using_stock')->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
            ->join("product","product.id","nso007_using_stock.product_id")->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_blog","nso007_blog.id","nso007_using.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_blog.project_id")->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_using.date","nso007_blog.name","nso007_project_stock.project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name","nso007_blog.id as b_id","product.id as p_id")->groupBy("nso007_using_stock.id")
              ->when(request('category_id'),function($query) use ($supps_id){
                $query->where('construction_supplier.id','=',$supps_id);
              })
              ->when(request('project_id'),function($query) use ($project){
                $query->where('nso007_project_stock.id','=',$project);
              })
              ->when(request('blog_id'),function($query) use ($blog_id){
                $query->where('nso007_blog.id',$blog_id);
              })
              ->when(request('form_date',''), function($query) use($form_date,$to_date){
                  $query->whereBetween('nso007_using.date',[$form_date,$to_date]);
              })
              ->when(request('opt_search', ''), function ($query) use ($date_from,  $date_to){ 
                    $query->whereBetween('nso007_using.date', [$date_from, $date_to]);
                })
              ->when(request('pro_id'),function ($query) use ($product_id){
                $query->where("product.id",$product_id);
              })
              ->groupBy("nso007_using_stock.id")
              ->get();

            echo json_encode($usingproducts);
        }
        
    }
    public function using_report_get_print(Request $request)
    {
        $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
        $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
        $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
        $project=isset($request->project_id)? $request->project_id:NULL;
        $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
        $date_from='';
        $date_to='';
        $product_id=isset($request->pro_id)?$request->pro_id:NULL;
        $opt_search=$request->opt_search;
        if(empty($request->start_date)&&empty($request->end_date)&&!empty($opt_search)){
            if($opt_search==1){
                $date_from=date('Y-m-d');
                $date_to=date('Y-m-d');
            }elseif($opt_search==2){
                $date_from = Carbon::now()->endOfMonth()->subMonth()->toDateString();
                $date_to = Carbon::now()->endOfMonth()->toDateString();
            }
            else{
                $date_from='';
                $date_to='';
            }
        }
        $usingproducts=DB::table('nso007_using_stock')->join("nso007_using","nso007_using.id","nso007_using_stock.using_id")
            ->join("product","product.id","nso007_using_stock.product_id")->join("nso007_purchase_stock","nso007_purchase_stock.product_id","product.id")->join("nso007_purchase","nso007_purchase.id","nso007_purchase_stock.purchase_id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_blog","nso007_blog.id","nso007_using.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_blog.project_id")->join("unit","unit.id","product.pro_unit_id")
            ->select("nso007_using.date","nso007_blog.name","nso007_project_stock.project_name","construction_supplier.supp_name","construction_supplier.supp_phone","product.pro_qty","nso007_using_stock.return_qty","pro_name","nso007_using_stock.qty","unit_name","nso007_blog.id as b_id","product.id as p_id")->groupBy("nso007_using_stock.id")
          ->when(request('category_id'),function($query) use ($supps_id){
            $query->where('construction_supplier.id','=',$supps_id);
          })
          ->when(request('project_id'),function($query) use ($project){
            $query->where('nso007_project_stock.id','=',$project);
          })
          ->when(request('blog_id'),function($query) use ($blog_id){
            $query->where('nso007_blog.id',$blog_id);
          })
          ->when(request('form_date',''), function($query) use($form_date,$to_date){
              $query->whereBetween('nso007_using.date',[$form_date,$to_date]);
          })
          ->when(request('opt_search', ''), function ($query) use ($date_from,  $date_to){ 
                $query->whereBetween('nso007_using.date', [$date_from, $date_to]);
            })
          ->when(request('pro_id'),function ($query) use ($product_id){
                $query->where("product.id",$product_id);
              })
          ->groupBy("nso007_using_stock.id")
          ->get();

        return view('administrator.construction-report.using-report.print',compact('usingproducts'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
