<?php


namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use App\Classes\BlockUserEvent;
use Auth;


class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     function __construct()
    {
         $this->middleware('permission:User-List', ['only' => ['index','store']]);
         $this->middleware('permission:User-Create', ['only' => ['create','store']]);
         $this->middleware('permission:User-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:User-Delete', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        
        $data = User::leftJoin("position","position.id","users.position")->select("users.*","position.name as position")->whereIn("users.status",[0,1])->orderBy('id','DESC')->get();
        $status=[];
        foreach($data as $key=>$row){
            if(Auth::user()->id==$row->id){
                 $status[$key]="";
            }
            elseif($row->status==1){
                $status[$key]='<button type="button" class="btn btn-sm btn-default" style="width:80px" id="'.$row->id.'" state="'.$row->status.'" onclick="changeStatus(this)"><i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i></button>';
            }elseif($row->status==0){
                $status[$key]='<button type="button" class="btn btn-sm btn-default" style="width:80px" id="'.$row->id.'" state="'.$row->status.'" onclick="changeStatus(this)"><i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i></button>';
            }else{
                $status[$key]="";
            }
        }
        return view('users.index',compact('data','status'));
    }

    public function update_status($id)
    {   
        $user=User::find($id);
        $status="";
        if($user->status==1){
            $status=0;
            event(new BlockUserEvent(["user_id"=>$id,"user_status"=>"0"]));//Event block user
        }
        elseif($user->status==0){ 
            $status=1; 
        }
        User::where("id",$id)->update(['status'=>$status]);
        return json_encode("OK");
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name','name')->all();
        $position=DB::table("position")->get();
        return view('users.create',compact('roles','position'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|same:confirm-password',
            'roles' => 'required',
            'gender'=>'required',
            'position'=>'required'
        ]);

        $password = Hash::make($request->input('password'));
        $user = new User();

        $user->name=$request->name;
        $user->email=$request->email;
        $user->remember_token=$request->_token;
        $user->password=$password;
        if(!empty($request->dob)){
            $user->dob=date("Y-m-d",strtotime($request->dob));
        }
        $user->gender=$request->gender;
        $user->phone=$request->phone;
        $user->idcard=$request->idcard;
        $user->position=$request->position;
        $user->address=$request->address;
        $user->save();
        $user->assignRole($request->input('roles'));

        DB::table("position")->where("id",$request->position)->update(['status_delete'=>0]);

        return redirect()->route('users.index')
                        ->with('success','User created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $user = User::find($id);
        return view('users.show',compact('user'));
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::pluck('name','name')->all();
        $userRole = $user->roles->pluck('name','name')->all();
        $position = DB::table("position")->pluck('name','id')->all();


        return view('users.edit',compact('user','roles','userRole','position'));
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required|email|unique:users,email,'.$id,
            'password' => 'same:confirm-password',
            'roles' => 'required',
            'position' => 'required'
        ]);

        $user = User::find($id);
        if(count(User::where("position",$user->position)->get())==1){
            DB::table("position")->where("id",$user->position)->update(['status_delete'=>1]);
        }
        
        $input = $request->all();
        if(!empty($input['password'])){ 
            $input['password'] = Hash::make($input['password']);
            $user->password= $input['password'];
        }else{
            $input = array_except($input,array('password'));    
        }
        $user->name=$request->name;
        $user->email=$request->email;
        $user->remember_token=$request->_token;
        if(!empty($request->dob)){
            $user->dob=date("Y-m-d",strtotime($request->dob));
        }
        $user->gender=$request->gender;
        $user->phone=$request->phone;
        $user->idcard=$request->idcard;
        $user->position=$request->position;
        $user->address=$request->address;
        $user->save();

        DB::table("position")->where("id",$request->position)->update(['status_delete'=>0]);

        DB::table('model_has_roles')->where('model_id',$id)->delete();
        $user->assignRole($request->input('roles'));
        return redirect()->route('users.index')
                        ->with('success','User updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $result=0;
        $result=User::where("id",$id)->update(["status"=>2]);
        if($result==1){
            return redirect()->route('users.index')
                        ->with('success','User deleted successfully');
        }else{
            return redirect()->route('users.index')
                        ->with('warning','User deleted not successfull');
        }
        
    }
}