<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProjectModel;
use App\CategoryModel;
use DB;
use App\BlockModel;
use DataTables;

class PurchaseReport extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Purchase-Report-Construction-List', ['only' => ['index','list_report_purchase']]);
    }
    public function index()
    {
        $projects = ProjectModel::select(
            DB::raw('name AS project_mixed'),'id')
            ->pluck('project_mixed','id');
        $supps = DB::table('construction_supplier')->select(
            DB::raw('CONCAT(supp_name," | ",supp_phone) AS supplier'),'id')
            ->pluck('supplier','id');
        $blogs = BlockModel::select("nso007_block.name","nso007_block.id",DB::raw("CONCAT(nso007_project_stock.name,' | ',nso007_block.name) as blog_pro"))->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->pluck("blog_pro",'id');
        $products = DB::table("product")->select("pro_name","id")->pluck('pro_name','id');
        return view('construction-report.purchase-report.index',compact('projects','supps','blogs','products'));
    }
    public function list_report_purchase(Request $request)
    {
        if ($request->isMethod('GET')){

            $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
            $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
            $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
            $project=isset($request->project_id)? $request->project_id:NULL;
            $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
            $last_months = $request->last_months;
            $product=isset($request->product)? $request->product:NULL;

            $purchases_total=DB::table('nso007_purchase_stock')->join("product","product.id","nso007_purchase_stock.product_id")->join("unit","unit.id","product.pro_unit_id")->join("nso007_purchase","nso007_purchase_stock.purchase_id","nso007_purchase.id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_block","nso007_block.id","nso007_purchase.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->select("nso007_purchase.date","nso007_purchase.date_purchase","nso007_block.name","nso007_purchase.id","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","nso007_purchase_stock.amount","nso007_purchase.invoice_num","unit_name","pro_name","unit_price","qty")->get();

            $purchases_filter=DB::table('nso007_purchase_stock')->join("product","product.id","nso007_purchase_stock.product_id")->join("unit","unit.id","product.pro_unit_id")->join("nso007_purchase","nso007_purchase_stock.purchase_id","nso007_purchase.id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_block","nso007_block.id","nso007_purchase.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->select("nso007_purchase.date","nso007_purchase.date_purchase","nso007_block.name","nso007_purchase.id","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","nso007_purchase_stock.amount","nso007_purchase.invoice_num","unit_name","pro_name","unit_price","qty")
                ->when(request('supps_id'),function($query) use ($supps_id){
                    $query->whereIn('construction_supplier.id',$supps_id);
                  })
                  ->when(request('product'),function($query) use ($product){
                    $query->whereIn('product.id',$product);
                  })
                  ->when(request('project_id'),function($query) use ($project){
                    $query->whereIn('nso007_project_stock.id',$project);
                  })
                  ->when(request('blog_id'),function($query) use ($blog_id){
                    $query->whereIn('nso007_block.id',$blog_id);
                  })
                  ->when(request('form_date',''), function($query) use($form_date,$to_date){
                      $query->whereBetween('nso007_purchase.date',[$form_date,$to_date]);
                  })
                  ->where(function($query) use($last_months){
                    if(!empty($last_months)){
                      $query->whereBetween('nso007_purchase.date',\Globals::the_last_month($last_months));
                    }
                  })
                ->orderBy('nso007_purchase.date','DESC')
                ->get();

            $purchases=DB::table('nso007_purchase_stock')->join("product","product.id","nso007_purchase_stock.product_id")->join("unit","unit.id","product.pro_unit_id")->join("nso007_purchase","nso007_purchase_stock.purchase_id","nso007_purchase.id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_block","nso007_block.id","nso007_purchase.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->select("nso007_purchase.date","nso007_purchase.date_purchase","nso007_block.name","nso007_purchase.id","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","nso007_purchase_stock.amount","nso007_purchase.invoice_num","nso007_purchase.person_recieve","unit_name","pro_category_id","pro_name","unit_price","qty")
                ->when(request('supps_id'),function($query) use ($supps_id){
                    $query->whereIn('construction_supplier.id',$supps_id);
                  })
                  ->when(request('project_id'),function($query) use ($project){
                    $query->whereIn('nso007_project_stock.id',$project);
                  })
                  ->when(request('product'),function($query) use ($product){
                    $query->whereIn('product.id',$product);
                  })
                  ->when(request('blog_id'),function($query) use ($blog_id){
                    $query->whereIn('nso007_block.id',$blog_id);
                  })
                  ->when(request('form_date',''), function($query) use($form_date,$to_date){
                      $query->whereBetween('nso007_purchase.date',[$form_date,$to_date]);
                  })
                  ->where(function($query) use($last_months){
                    if(!empty($last_months)){
                      $query->whereBetween('nso007_purchase.date',\Globals::the_last_month($last_months));
                    }
                  })
                  ->orderBy('nso007_purchase.date','DESC')
                ->take(20);

            return Datatables::of($purchases)
                    ->addIndexColumn()
                    ->with([
                        "recordsTotal" => count($purchases_total),
                         "recordsFiltered" => count($purchases_filter)
                      ])
                    ->editColumn("date",function($purchases){
                      return date("d-m-Y",strtotime($purchases->date));
                    })
                    ->editColumn("date_purchase",function($purchases){
                      return date("d-m-Y",strtotime($purchases->date_purchase));
                    })
                    ->addColumn('unit_price',function($purchases){
                      return '$'. number_format($purchases->unit_price,2);
                    })
                    ->addColumn('amount',function($purchases){
                      return '$'. number_format($purchases->amount,2);
                    })
                    ->editColumn('pro_category_id',function($purchases){
                      return optional(DB::table("nso007_category_construction")->where("pcat_id",$purchases->pro_category_id)->first())->pcat_name;
                    })
                    ->make(true);
        }
        
    }
    public function list_report_purchase_print(Request $request)
    {
        $form_date =  (empty($request->form_date))? '': date('Y-m-d',strtotime($request->form_date));
        $to_date   =  (empty($request->to_date))? '': date('Y-m-d',strtotime($request->to_date));
        $supps_id=isset($request->supps_id)? $request->supps_id:NULL;
        $project=isset($request->project_id)? $request->project_id:NULL;
        $blog_id=isset($request->blog_id)? $request->blog_id:NULL;
        $date_from='';
        $date_to='';
        $opt_search=$request->opt_search;
        if(empty($request->start_date)&&empty($request->end_date)&&!empty($opt_search)){
            if($opt_search==1){
                $date_from=date('Y-m-d');
                $date_to=date('Y-m-d');
            }
            else{
                $date_from='';
                $date_to='';
            }
        }
        $purchases=DB::table('nso007_purchase_stock')->join("product","product.id","nso007_purchase_stock.product_id")->join("unit","unit.id","product.pro_unit_id")->join("nso007_purchase","nso007_purchase_stock.purchase_id","nso007_purchase.id")->join("construction_supplier","construction_supplier.id","nso007_purchase.supplier_id")->join("nso007_block","nso007_block.id","nso007_purchase.blog_id")->join("nso007_project_stock","nso007_project_stock.id","nso007_block.project_id")->select("nso007_purchase.date","nso007_purchase.date_purchase","nso007_block.name","nso007_purchase.id","nso007_project_stock.name as project_name","construction_supplier.supp_name","construction_supplier.supp_phone","nso007_purchase_stock.amount","nso007_purchase.invoice_num","unit_name","pro_name","unit_price","qty")
          ->when(request('category_id'),function($query) use ($supps_id){
            $query->where('construction_supplier.id','=',$supps_id);
          })
          ->when(request('project_id'),function($query) use ($project){
            $query->where('nso007_project_stock.id','=',$project);
          })
          ->when(request('blog_id'),function($query) use ($blog_id){
            $query->where('nso007_block.id',$blog_id);
          })
          ->when(request('form_date',''), function($query) use($form_date,$to_date){
              $query->whereBetween('nso007_purchase.date',[$form_date,$to_date]);
          })
          ->when(request('opt_search', ''), function ($query) use ($date_from,  $date_to){ 
                $query->whereBetween('nso007_purchase.date', [$date_from, $date_to]);
            })
          ->get();

        return view('construction-report.purchase-report.print',compact('purchases'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
