<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\ProjectModel;
use DataTables;
use App\ProvinceModel;
use Auth;
use Crypt;
use App\User;
use Gate;
class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    function __construct()
    {
         $this->middleware('permission:Project-List', ['only' => ['index','datatable_get_project']]);
         $this->middleware('permission:Project-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Project-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Project-Delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        return view("project.index");
    }

    public function datatable_get_project(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =ProjectModel::join("users","users.id","nso007_project_stock.user_id")
                        ->where("nso007_project_stock.status",1)
                        ->count();
        $count_filter =ProjectModel::join("users","users.id","nso007_project_stock.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_project_stock.status",1)
                        ->count();

        $projects = ProjectModel::with(['get_province','get_district','get_commune','get_village'])->join("users","users.id","nso007_project_stock.user_id")
                            ->select("nso007_project_stock.*")
                            ->orderBy('nso007_project_stock.id','asc')
                            ->where("nso007_project_stock.status",1)
                            ->take(20);
        return Datatables::of($projects)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->addColumn('action',function($projects){
                $button="";
                if(Gate::check('Project-Edit'))
                    $button.= ' <a href="'.Route("project.edit", Crypt::encrypt($projects->id)).'"  class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';
                if(Gate::check('Project-Delete'))
                {
                    if($projects->delete_status==0){
                        $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($projects->delete_status==1){
                        $button .= ' <button type="button" data-toggle="modal" data-target="#modal-danger'.$projects->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                            <div class="modal fade" id="modal-danger'.$projects->id.'">
                                <form action="'.route("project.delete",$projects->id).'" method="GET" style="display:inline">
                                      <div class="modal-dialog">
                                        <div class="modal-content bg-danger">
                                          <div class="modal-header">
                                            <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>
                                          <div class="modal-body">
                                            <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                          </div>
                                          <div class="modal-footer justify-content-between">
                                            <a>&nbsp;</a>
                                            <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                          </div>
                                        </div>
                                        <!-- /.modal-content -->
                                      </div>
                                      <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                        ';
                    }else{

                    }
                }
                
                return $button;
            })
            ->editColumn("type",function($projects){
                if($projects->type==0){
                    return "<span class='text-success'>Customer</span>";
                }else{
                    return "<span class='text-success'>Client</span>";
                }
            })
            ->editColumn("address",function($projects){
                $location="";
                if(!empty($projects->house_number)) $location.=$projects->house_number;
                if(!empty($projects->street_number)) $location.=" ,".$projects->street_number;
                if(!empty($projects->get_village['village_km'])) $location.="  ភូមិ ".$projects->get_village['village_km'];
                if(!empty($projects->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$projects->get_commune['commune_km'];
                if(!empty($projects->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$projects->get_district['district_km'];
                if(!empty($projects->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$projects->get_province['province_km'];
                return $location;
            })
             ->rawColumns([
                'action' => 'action',
                "type"=>"type"
            ])
            ->make(true); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        return view("project.create",compact("provinces"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required|unique:nso007_project_stock,name'
        ]);
        $project = new ProjectModel;
        $project->name=$request->name;
        $project->house_number=$request->house_number;
        $project->street_number=$request->street_number;
        $project->province=$request->province;
        $project->district=$request->district;
        $project->commune=$request->commune;
        $project->village=$request->village;
        $project->description=$request->description;
        $project->user_id=Auth::user()->id;
        $project->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("project.index")->with("success","Create Successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $project=ProjectModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return view("project.edit",compact('provinces','project'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required|unique:nso007_project_stock,name,'.$id
        ]);
        $project = ProjectModel::find($id);
        $project->name=$request->name;
        $project->house_number=$request->house_number;
        $project->street_number=$request->street_number;
        $project->province=$request->province;
        $project->district=$request->district;
        $project->commune=$request->commune;
        $project->village=$request->village;
        $project->description=$request->description;
        $project->save();

        return redirect()->route("project.index")->with("success","Update Successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        ProjectModel::where("id",$id)->delete();
        return \back()->with("success","successfully !");
    }
}
