<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\User;
use DB;


class PositionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:Position-List', ['only' => ['index','store']]);
        $this->middleware('permission:Position-Create', ['only' => ['create','store']]);
        $this->middleware('permission:Position-Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Position-Delete', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        $data = DB::table("position")->orderBy('id','DESC')->get();
        return view('position.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $title=$request->title;
        $des=$request->description;
        DB::table("position")->insert(['name'=>$title,'description'=>$des]);
        $data=DB::table("position")->orderBy('id','DESC')->get();
        
        return json_encode($data);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update_position(Request $request){
        $title=$request->title;
        $des=$request->description;
        $id=$request->id;
        DB::table("position")->where("id",$id)->update(['name'=>$title,'description'=>$des]);
        return json_encode("OK");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $result=0;
        $result=DB::table("position")->where("id",$id)->where("status_delete",1)->delete();
        if($result==1){
            return \back()->with("success","Delete successfully !");
        }
        else{
            return \back()->with("warning","Delete not successfull !");
        }
    }
}
