<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\ItemModel;
use DataTables;
use App\ClientModel;
use App\AgencyModel;
use App\SaleModel;
use App\SaleDetailModel;
use App\DepositModel;
use Auth;
use App\User;
use App\ProvinceModel;
use App\AccountChartModel;
use App\JournalModel;
use Gate;
use App\Helpers\Globals;
use App\ProjectModel;
use App\BlockModel;
class POSController extends Controller
{

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:POS-List', ['only' => ['create','get_item']]);
    }
    public function create()
    {
        $clients=ClientModel::where("type",1)->where("status",1)->pluck("name","id")->prepend("Please Select","");
        $agencies=AgencyModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $banklist = AccountChartModel::select(DB::raw("CONCAT(code, ' | ',acc_name) as account_name"), "code")
        ->where('code', 11001)
        ->Orwhere('code', 11002)
         ->orderBy('code')
        ->pluck("account_name", "code");

        $projects = ProjectModel::pluck("name","id")->prepend("Please Select","");
        $policy_payments = DB::table("nso007_payment_policy")->pluck("name","id")->prepend("Please Select","");

        return view("pos.create",compact("clients","agencies","provinces","banklist",'projects','policy_payments'));
    }

    public function get_item(Request $request)
    {
        if($request->isMethod("POST")){

        }else{
            $search = $request->input('search.value');
            $input = $request->all();
            $count_total =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where("nso007_item_stock.status",1)
                            ->where("nso007_item_stock.stock_status",1)
                            ->where("nso007_item_stock.sale_stock",0)
                            ->count();
            $count_filter =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where(function($query) use ($input){
                                if(!empty($input['project_id'])){
                                    $query->where('nso007_item_stock.project_id',$input['project_id']);
                                }
                                if(!empty($input['block_id'])){
                                    $query->where("nso007_item_stock.block_id",$input['block_id']);
                                }
                                if(!empty($input['item_name'])){
                                    $query->where('nso007_item_stock.name',$input['item_name']);
                                }
                            })
                            ->where("nso007_item_stock.stock_status",1)
                            ->where("nso007_item_stock.sale_stock",0)
                            ->where("nso007_item_stock.status",1)
                            ->count();

            $items = ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                                ->select("nso007_item_stock.*","nso007_project_stock.name as project_name","nso007_category_stock.name as category_name")
                                ->orderBy('nso007_item_stock.id','asc')
                                ->where("nso007_item_stock.status",1)
                                ->where("nso007_item_stock.stock_status",1)
                                ->where("nso007_item_stock.sale_stock",0)
                                ->where(function($query) use ($input){
                                    if(!empty($input['project_id'])){
                                        $query->where('nso007_item_stock.project_id',$input['project_id']);
                                    }
                                    if(!empty($input['block_id'])){
                                        $query->where("nso007_item_stock.block_id",$input['block_id']);
                                    }
                                    if(!empty($input['item_name'])){
                                        $query->where('nso007_item_stock.name',$input['item_name']);
                                    }
                                })
                                ->take(10);
            return Datatables::of($items)
                ->addIndexColumn()
                ->setRowId("id")
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->editColumn('price',function($items){
                    return "$".number_format($items->price,2);
                })
                ->editColumn('block',function($items){
                    return BlockModel::find($items->block_id)->name;
                })
                ->addColumn('action',function($items){
                    $status="";
                    if(Gate::check('POS-Purchase'))
                    {
                        $status= ' <button type="button" class="btn btn-success btn-sm" data-index="'.$items->id.'" title="Add To Cart" onclick="Add_To_Cart(this)"><i class="fas fa-cart-arrow-down"></i></button> ';
                        if(session()->has("Cart")){
                            $cart=session()->get("Cart");
                            if(isset($cart[$items->id])){
                                $status= ' <button type="button" data-item_price = "'.$items->price.'" class="btn btn-info btn-sm" title="Undo ( Remove Item From Cart )" onclick="Remove_From_Cart(this)"><i class="fas fa-undo-alt"></i></button> ';
                            }
                        }
                    }

                    return $status;
                })
                 ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true);
        }
    }

    public function Add_To_Cart(Request $request)
    {
        $id=$request->id;
        $data=ItemModel::join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                ->select("nso007_item_stock.id","nso007_item_stock.name","nso007_item_stock.price","nso007_item_stock.cost","nso007_item_stock.size","nso007_item_stock.project_id","nso007_project_stock.name as project_name")
                ->where("nso007_item_stock.id",$id)
                ->first();
        if(empty($data)){
            $message=[
                'status'=>'error',
                'type'=>'error',
                "text"=>"Error with your request. Please try again !",
            ];
            return json_encode($message);
        }
        if(session()->has("Cart")){
            $cart=session()->get("Cart");
            if(isset($cart[$id])){
                $message=[
                    'status'=>'warning',
                    'type'=>'exist',
                    "text"=>"Item is exsit !",
                ];
                return json_encode($message);
            }else{
                $cart[$id]=$data;
                session()->put("Cart",$cart);
                $message=[
                    'status'=>'success',
                    'type'=>'added',
                    "text"=>"Add successfully !",
                    "data"=>$cart
                ];
                return json_encode($message);
            }
        }else{
            $cart_data=array(
                $id=>$data
            );
            session()->put("Cart",$cart_data);
            $message=[
                'status'=>'success',
                'type'=>'added',
                "text"=>"Add successfully !",
                "data"=>$cart_data
            ];
            return json_encode($message);
        }
    }
    public function Remove_From_Cart(Request $request){
        $id=$request->id;
        if(session()->has("Cart")){
            $cart=session()->get("Cart");
            unset($cart[$id]);
            session()->put("Cart",$cart);
            return json_encode("OK");

        }else{
            return json_encode("Error");
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request,[
            "client_id"=>"required|numeric",
            // "agency_id"=>"required|numeric",
            // "date"=>"required",
            "contract_date"=>"required",
        ]);
        // DB::beginTransaction();
        // try{
            $sale_amount=0;$check_item="";
            //Get Item From Session store
            if(session()->has("Cart")){
                $data_cart = session()->get("Cart");
                if(empty($data_cart)||count($data_cart)<=0) return json_encode("Error");
                foreach($data_cart as $key => $value){
                    $sale_amount+=$value['price'];
                    $check_item = ItemModel::where("id",$value["id"])
                                  ->where("stock_status",2)->first();
                    if(!empty($check_item)){
                        return json_encode("BOOKED");
                    }

                }
                if($request->deposit_amount>=$sale_amount*20/100) return json_encode("Error-Deposit-Amount");
                session()->forget("Cart");//Delete session Cart
            }else{
                return json_encode("Error");
            }
            //End
            $item_stock         = ItemModel::find($value["id"]);
            $account_code = $request->bank_list ? $request->bank_list : null;

            //Inset into Sale Stock
            $sale_data = array(
                "date" => (!empty($request->date)?date("Y-m-d",strtotime($request->date)):null),
                "sale_amount" => $sale_amount,
                "sale_remain_amount" => $sale_amount,
                "client_id" => $request->client_id,
                "sale_receive_amount" =>0,
                "date_on_contract" => date("Y-m-d",strtotime($request->contract_date)),
                "agency_id" => $request->agency_id,
                "user_id" => Auth::user()->id,
                "condition_convert_to_income"=>20,
                "discount_amount"=>$request->discount_amount,
                "policy_payment_id"=>$request->policy_payment,
                "policy_payment_detail_id"=>$request->policy_payment_detail
            );
            SaleModel::insert($sale_data);
            $sale_id=SaleModel::max("id");
            //End

            $I_name="";$sum_total_price=0;

            foreach($data_cart as $key=>$value){
                //Update item status
                ItemModel::where("id",$value['id'])
                    ->update(['stock_status'=>2,"sale_stock"=>1,"delete_status"=>0]);

                //Insert Sale Detail
                $I_name .= $value['name'].",";

                $sum_total_price+=$value['price'];

                $data_sale_detail = array(
                    "sale_id" => $sale_id,
                    "item_cost" => $value['cost'],
                    "item_price" => $value['price'],
                    "item_id" => $value["id"],
                );
                SaleDetailModel::insert($data_sale_detail);
            }
            if($request->payment_amount[0]>0){
                foreach($request->date_payment as $index=>$value){
                    $data = array(
                        "sale_id"=>$sale_id,
                        "date"=>date("Y-m-d",strtotime($request->date_payment[$index])),
                        "amount"=>$request->payment_amount[$index]
                    );
                    DB::table("nso007_deposit_schedule")->insert($data);
                }
            }

            ClientModel::where("id",$request->client_id)->update(['delete_status'=>0]);//set status_delete
            AgencyModel::where("id",$request->agency_id)->update(['delete_status'=>0]);//set status_delete
            User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//set status_delete

            /*if(!empty($request->deposit_amount))
            {
                //Insert into Deposit
                $deposit_data = array(
                    "sale_id" => $sale_id,
                    "date" => date("Y-m-d",strtotime($request->date)),
                    "deposit_amount" => $request->deposit_amount,
                    "date_on_contract" => date("Y-m-d",strtotime($request->contract_date)),
                    "accountant_name" => $request->accountant_name,
                    // "description" => $request->description,
                    "user_id" => Auth::user()->id,
                    "account_code"=>$account_code
                );
                DepositModel::insert($deposit_data);
                $deposit_max_id = DepositModel::max("id");
                //End

                $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=0;
                $journal->journal_type=1;
                $journal->journal_acccode=$request->bank_list;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Deposit 1';
                $journal->journal_debit=$request->deposit_amount;
                $journal->journal_credit=0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock->project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jj->last_id;
                $journal->journal_type=2;
                $journal->journal_acccode=21003;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Deposit 1';
                $journal->journal_debit=0;
                $journal->journal_credit=$request->deposit_amount;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
                $journal->journal_currency=1;
                $journal->transaction_type='Deposit';
                $journal->journal_referenceid=$deposit_max_id;
                $journal->journal_by_project=$item_stock->project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();
            }*/

            // DB::commit();
            return redirect()->route("deposit.index")->with("success","Create Successfully !");
        // }catch(\Exception $e){
        //     DB::rollback();
        //     return json_encode("Error");
        // }
    }
    public function get_client_search(Request $request)
    {
        $client_name = $request->client_name;
        $data = ClientModel::where("name","LIKE","%".$client_name."%")->where('type',1)->get();
        return json_encode($data);
    }
    public function get_agency_search(Request $request)
    {
        // dd("OK");
        $agency_name = $request->agency_name;
        $data = AgencyModel::where("name","LIKE","%".$agency_name."%")->get();
        return json_encode($data);
    }
}
