<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\JournalModel;
use App\AccountChartModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use Gate;

class LiabilityController extends Controller
{
    function __construct(){
        $this->middleware('permission:Add-Liability', ['only' => ['create','store']]);
        $this->middleware('permission:List-Liability', ['only' => ['index']]);
        $this->middleware('permission:Edit-Liability', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete-Liability', ['only' => ['delete']]);
    }
    public function index(Request $request)
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $last_months = $request->last_months;
                $voucher_ref = $request->voucher_ref;
                $journal_acccode = $request->journal_acccode;
                $count_total = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status",0)
                                ->where("journal_acccode","LIKE","2%")
                                ->whereColumn("journal_credit",">","payable_paid")
                                ->orderBy("jn.journal_paydate","DESC")
                                // ->groupBy("jn.id")
                                ->count();
                $count_filter = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                                ->select(
                                    'chart.acc_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id',
                                    'construction_supplier.supp_name',
                                    'construction_supplier.supp_phone'
                                )
                                ->where("journal_status",0)
                                ->where("journal_acccode","LIKE","2%")
                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id)){
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                    }
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->whereColumn("journal_credit",">","payable_paid")
                                ->orderBy("jn.journal_paydate","DESC")
                                // ->groupBy("jn.id")
                                ->count();
                $data = DB::table('nso007_journal as jn')
                            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                            ->leftJoin("construction_supplier","construction_supplier.id","jn.journal_by_supplier")
                            ->select(
                                'chart.acc_name',
                                'chart.code as account_code',
                                'jn.id',
                                'jn.journal_des',
                                'jn.journal_debit',
                                'jn.journal_credit',
                                'jn.journal_invoice',
                                'jn.journal_paydate',
                                'jn.voucher_type',
                                'jn.voucher_ref',
                                'jn.journal_status',
                                'project.name as project_name',
                                'jn.journal_tran_id as tran_id',
                                'construction_supplier.supp_name',
                                'construction_supplier.supp_phone',
                                'jn.payable_paid'
                            )
                            ->where("journal_status",0)
                            ->where("journal_acccode","LIKE","2%")
                            ->where(function($query) use ($project_id){
                                if(!empty($project_id))
                                    $query->whereIn("jn.journal_by_project",$project_id);
                            })
                            ->where(function($query) use ($start_date,$end_date){
                                if(!empty($start_date)&&!empty($end_date)){
                                    $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                }
                            })
                            ->where(function($query) use ($last_months){
                                if(!empty($last_months)){
                                    $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                }
                            })
                            ->where(function($query) use ($voucher_ref){
                                if(!empty($voucher_ref)){
                                    $query->where("jn.voucher_ref",$voucher_ref);
                                }
                            })
                            ->where(function($query) use ($journal_acccode){
                                if(!empty($journal_acccode)){
                                    $query->whereIn("jn.journal_acccode",$journal_acccode);
                                }
                            })
                            ->whereColumn("journal_credit",">","payable_paid")
                            ->orderBy("jn.journal_paydate","DESC")
                            // ->groupBy("jn.id")
                            ->take(20);
            return DataTables::of($data)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('journal_credit',function($data){
                    return "$".number_format(($data->journal_credit - $data->payable_paid),2);
                })
                ->editColumn('journal_by_supplier',function($data){
                    if(!empty($data->supp_name))
                        return $data->supp_name." (".$data->supp_phone.")";
                    else return "";
                })
                ->editColumn('voucher', function ($data) {
                    $voucher = "";
                    if ($data->voucher_type == 1) {
                        $voucher = "Cash Receipt";
                    } else if ($data->voucher_type == 2) {
                        $voucher = "Cash Disbursement";
                    } else if ($data->voucher_type == 3) {
                        $voucher = "Cash Reimbursement";
                    } else if ($data->voucher_type == 4) {
                        $voucher = "Cash Advance";
                    } else if ($data->voucher_type == 5) {
                        $voucher = "Advance Settlement";
                    } else if ($data->voucher_type == 6) {
                        $voucher = "Journal Entry/Adjustment";
                    }
                    return $voucher;
                })
                ->editColumn('account_code', function ($data) {
                    return $data->account_code . " " . $data->acc_name;
                })
                ->editColumn('journal_paydate',function($data){
                    return date("d-m-Y",strtotime($data->journal_paydate));
                })
                ->addColumn('action',function($data){
                    $btn_edit = '';
                    $btn_delete = '';
                    if($data->journal_status==0){
                        if(Gate::check('Edit-Liability'))
                            $btn_edit.= '<a href="'.route('liability.edit',$data->id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                        if(Gate::check('Delete-Liability'))
                            $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->id.'" onclick="delete_liability('.$data->id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                    }
                    return $btn_edit.$btn_delete;
                })
                ->rawColumns(['action' => 'action'])
                ->make(true);
            }
        }
        return view('accounting.liability.index', ['acc_code' => $acc_code,'projects' => $projects]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('accounting.liability.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required'
        ]);

        $max            = JournalModel::max('journal_tran_id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        JournalModel::insert([
            'journal_parentid'          => 0,
            'journal_type'              => 20000,
            'journal_acccode'           => $request->journal_acccode,
            'voucher_type'              => 2,
            'voucher_ref'               => $voucher_ref,
            'journal_des'               => $request->description,
            'journal_debit'             => 0,
            'journal_credit'            => $request->amount,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by'                => Auth::user()->id,
            'journal_invoice'           => "",
            'journal_transactiondate'   => date('Y-m-d H:i:s'),
            'journal_tran_id'           => $journal_tran_id,
            'journal_by_project'        => $request->journal_by_project,
            'journal_by_supplier'       => $request->journal_by_supplier,
            'journal_status'           => 0,
            'transaction_type'         => "Acc-Liability"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('liability.index')->with("success","Create Successfully!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = JournalModel::find($id);
        return view('accounting.liability.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'journal_credit'=>'required'
        ]);

        JournalModel::where("id",$id)->update([
            'journal_acccode'           => $request->journal_acccode,
            'journal_des'               => $request->description,
            'journal_credit'            => $request->journal_credit,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            'journal_by_supplier'       => $request->journal_by_supplier,
            'transaction_type'         => "Acc-Liability"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('liability.index')->with("success","Update Successfully!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete()
    {
        $journal_id = $_GET['id'];
        JournalModel::find($journal_id)->delete();
        return redirect()->route('liability.index')->with("success","Delete Successfully!");
    }
    public function destroy($id)
    {
        //
    }
}
