<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ItemModel;
use Crypt;
use DataTables;
use App\CategoryModel;
use App\ProjectModel;
use App\BlockModel;
use DB;
use Auth;
use App\User;
use Gate;
use App\SubCategories;
use App\GroupItem;

class ItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Item-List', ['only' => ['index','get_item']]);
         $this->middleware('permission:Item-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Item-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Item-Delete', ['only' => ['destroy']]);
    }
    public function index()
    {
        return view("item.index");
    }
    public function get_item(Request $request)
    {
        if($request->isMethod("POST")){
            if(isset($request->type)&&$request->type==1){
                $data=ItemModel::where("project_id",$request->project_id)->where("category_id",$request->category_id)->where("status",1)->get();
            }else{
                $data=BlockModel::where("project_id",$request->project_id)->where("status",1)->get();
            }
            return json_encode($data);
            
        }else{
            $search = $request->input('search.value');
            $count_total =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->where("nso007_item_stock.status",1)
                            ->count();
            $count_filter =ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
                            ->join("nso007_group_item","nso007_group_item.id","nso007_item_stock.groupitem_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_item_stock.size' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where("nso007_item_stock.status",1)
                            ->count();

            $items = ItemModel::join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                            ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
                            ->join("nso007_group_item","nso007_group_item.id","nso007_item_stock.groupitem_id")
                                ->select("nso007_item_stock.*","nso007_project_stock.name as project_name","nso007_category_stock.name as category_name",'nso007_sub_category.name as subcategory','nso007_group_item.name as groupitem')
                                // ->orderBy('nso007_item_stock.id','asc')
                                ->where("nso007_item_stock.status",1)
                                ->take(20);
            return Datatables::of($items)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->setRowId("id")
                ->editColumn('block',function($items){
                  return BlockModel::find($items->block_id)->name;
                })
                ->editColumn('price',function($items){
                  return "$".number_format($items->price,2);
              })
              ->editColumn('cost',function($items){
                  return "$".number_format($items->cost,2);
              })
                ->addColumn('action',function($items){
                    $button="";
                    if(Gate::check('Item-Edit')){
                      if($items->delete_status==0) $button.= ' <button disabled  class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></button> ';
                      else $button.= ' <a href="'.Route("item.edit", Crypt::encrypt($items->id)).'"  class="btn btn-info btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';
                    }
          
                        
                    if($items->delete_status==0){
                        if(Gate::check('Item-Delete'))
                            $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($items->delete_status==1){
                        if(Gate::check('Item-Delete'))
                            $button .= ' <button type="button" onclick="delete_item('.$items->id.')" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                                <div class="modal fade" id="modal-danger'.$items->id.'">
                                    <form action="'.route("item.delete",$items->id).'" method="GET" style="display:inline">
                                      <div class="modal-dialog">
                                        <div class="modal-content bg-danger">
                                          <div class="modal-header">
                                            <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                              <span aria-hidden="true">&times;</span>
                                            </button>
                                          </div>
                                          <div class="modal-body">
                                            <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                          </div>
                                          <div class="modal-footer justify-content-between">
                                            <a>&nbsp;</a>
                                            <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                          </div>
                                        </div>
                                        <!-- /.modal-content -->
                                      </div>
                                      <!-- /.modal-dialog -->
                                    </form>
                                </div>
                                <!-- /.modal -->
                        ';
                    }else{

                    }
                    return $button;
                })
                 ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true); 
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories=CategoryModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $projects=ProjectModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $subcategories = SubCategories::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $groupitems = GroupItem::where("status",1)->pluck("name","id")->prepend("Please Select","");
        return view("item.create",compact("categories","projects",'subcategories','groupitems'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      // dd($request->all());
        $this->validate($request,[
            'category_id'=>'required|numeric',
            'block_id'=>'required|numeric',
            'price'=>'required|numeric',
            'start_number'=>'required|numeric',
            'number_of_item'=>'required|numeric',
            'project'=>'required|numeric',
            'size'=>'required',
            'name_item.*'=>'required',
            'price_item.*'=>'required',
            'size_item.*'=>'required',
            'groupitem_id'=>'required',
            'subcategory_id'=>'required'
        ]);

        DB::beginTransaction();
        try{
            foreach ($request->name_item as $key => $value) {
                $val_size = explode("x", $request->size_item[$key]);
                $val_size1="";$cp=array();$l=0;$w=0;
                foreach ($val_size as $i => $v) {
                  $val_size1 = explode("m", $v);
                  $cp[$i] = $val_size1[0];
                }
                if($cp[0]>$cp[1]) {
                  $l=$cp[0];$w=$cp[1];
                }
                else{
                  $l=$cp[1];$w=$cp[0];
                } 
                
                $items = array(
                    'name'=>$request->name_item[$key],
                    'cost'=>$request->cost_item[$key],
                    'price'=>$request->price_item[$key],
                    'size'=>$request->size_item[$key],
                    'category_id'=>$request->category_id,
                    'project_id'=>$request->project,
                    'block_id'=>$request->block[$key],
                    'user_id'=>Auth::user()->id,
                    'description'=>$request->description,
                    'length'=>$l,
                    'width'=>$w,
                    'subcategory_id'=>$request->subcategory_id,
                    'groupitem_id'=>$request->groupitem_id  
                );

                ItemModel::insert($items);

                BlockModel::where("id",$request->block[$key])->update(['delete_status'=>0]);//set status_delete
            }

            ProjectModel::where("id",$request->project)->update(['delete_status'=>0]);//set delete_status
            CategoryModel::where("id",$request->category_id)->update(['delete_status'=>0]);//set delete_status
            User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user
            SubCategories::where("id",$request->subcategory_id)->update(['delete_status'=>0]);//set delete_status
            GroupItem::where("id",$request->groupitem_id)->update(['delete_status'=>0]);//set delete_status

            DB::commit();
            return redirect()->route('item.index')
            ->with('success','Item Created successfully!');
        }catch(\Exception $e){
            DB::rollback();
            return redirect()->route('item.index')
            ->with('warning','Sothing wrong !');
        }
        return redirect()->route("item.index")->with("Create successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = Crypt::decrypt($id);
        $categories=CategoryModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $projects=ProjectModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $blocks=BlockModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $item=ItemModel::find($id);
        $subcategories = SubCategories::where("status",1)->pluck("name","id")->prepend("Please Select","");
        $groupitems = GroupItem::where("status",1)->pluck("name","id")->prepend("Please Select","");
        return view("item.edit",compact('categories','projects','blocks','item','subcategories','groupitems'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'category_id'=>'required|numeric',
            'block_id'=>'required|numeric',
            'price'=>'required|numeric',
            'project_id'=>'required|numeric',
            'size'=>'required',
            'name'=>'required',
            'groupitem_id'=>'required',
            'subcategory_id'=>'required'
        ]);

        if(!empty(ItemModel::where("project_id",$request->project_id)->where("name",$request->name)->where("id","!=",$id)->first())) return \back()->with("warning","This item is taken !");

        //check for status_delete or not
        $item = ItemModel::find($id);
        if(count(ItemModel::where("project_id",$item->project_id)->get())==1&&count(BlockModel::where("project_id",$item->project_id)->get())==0){
            ProjectModel::where("id",$item->project_id)->update(['delete_status'=>1]);
        }

        //check for status_delete or not
        if(count(ItemModel::where("category_id",$item->category_id)->get())==1){
            CategoryModel::where("id",$item->category_id)->update(['delete_status'=>1]);
        }

        //check for status_delete or not
        if(count(ItemModel::where("block_id",$item->block_id)->get())==1){
            BlockModel::where("id",$item->block_id)->update(['delete_status'=>1]);
        }

        $val_size = explode("x", $request->size);
          $val_size1="";$cp=array();$l=0;$w=0;
          foreach ($val_size as $i => $v) {
            $val_size1 = explode("m", $v);
            $cp[$i] = $val_size1[0];
          }
          if($cp[0]>$cp[1]) {
            $l=$cp[0];$w=$cp[1];
          }
          else{
            $l=$cp[1];$w=$cp[0];
          } 

        $Item = ItemModel::find($id);
        $Item->name = $request->name;
        $Item->category_id=$request->category_id;
        $Item->project_id=$request->project_id;
        $Item->block_id=$request->block_id;
        $Item->price=$request->price;
        $Item->size=$request->size;
        $Item->cost=$request->cost;
        $Item->description=$request->description;
        $Item->length = $l;
        $Item->width = $w;
        $Item->groupitem_id = $request->groupitem_id;
        $Item->subcategory_id = $request->subcategory_id;
        $Item->save();

        ProjectModel::where("id",$request->project)->update(['delete_status'=>0]);//set status_delete
        CategoryModel::where("id",$request->category_id)->update(['delete_status'=>0]);//set status_delete
        BlockModel::where("id",$request->block_id)->update(['delete_status'=>0]);//set status_delete
        SubCategories::where("id",$request->subcategory_id)->update(['delete_status'=>0]);//set delete_status
        GroupItem::where("id",$request->groupitem_id)->update(['delete_status'=>0]);//set delete_status

        return redirect()->route("item.index")->with("success","Update successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        ItemModel::where("id",$id)->delete();
        return response()->json(['status'=>'success']);
        // return \back()->with("success","successfully !");
    }
    public function get_item_by_zone($zone_id)
    {
      $id = explode(",",$zone_id);
      $data = ItemModel::whereIn("block_id",$id)->where('stock_status',1)->where('sale_stock',0)->get();
      return json_encode($data);
    }
    public function raise_price()
    {
       $projects=ProjectModel::where("status",1)->pluck("name","id")->prepend("Please Select","");
      return view('item.item-raise-price',compact('projects'));
    }
    public function store_raise_price(Request $request)
    {
      $this->validate($request,[
        'project'=>'required',
        'block_id'=>'required',
        'item_id.*'=>'required',
        'item_price.*'=>'required'
      ]);
      foreach ($request->item_price as $key => $value) {
        $old_price =  ItemModel::where('id',$request->item_id[$key])->first()->price;
        ItemModel::where('id',$request->item_id[$key])->update(['price'=>$request->item_price[$key]]);
        if($old_price!=$request->item_price[$key]) 
            DB::table('nso007_edit_old_price_by_block')->insert(['item_id'=>$request->item_id[$key],'item_price'=>$old_price]);
      }
      return redirect()->route("item.index")->with("success","Update successfully !");
    }
    public function get_blogs(Request $request)
    {
        $proj_id=$request->project_id;
        $blogs=BlockModel::where('project_id',$proj_id)->select('id','name')->get();
        return json_encode($blogs);
    }
}
