<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App;
use DateTime;
use App\LoanProcessModel;
use DB;
use App\LoanPaidModel;
use App\AccountChartModel;
use Crypt;
use App\LoanModel;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $month_text_first="first day of January ";
        $month_text_last="last day of December ";
        $from           = new DateTime($month_text_first. date('Y'));
        $to             = new DateTime($month_text_last. date('Y'));

        /*$journal_income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', "4%")
            ->where("jn.journal_status","!=",3)
            ->whereBetween('jn.journal_paydate', [$from, $to])->groupBy('chart.id')->get();*/
        $journal_income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->whereIn("jn.journal_acccode",['11001','11002'])
            ->where("jn.journal_status","!=",3)
            ->where("jn.journal_debit",">",0)
            /*->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
            ->where('jn.journal_audit_status',1)*/
            ->where(function($query) use($from,$to){
                if(!empty($from)&&!empty($to)){
                    $query->whereBetween('jn.journal_paydate', [$from,$to]);
                }
            })
            ->groupBy('chart.id')
            ->get();

        $index      = 0;
        $income     = 0;
        $expense    = 0;
        $data_income = [];
        foreach ($journal_income as $key => $ji) {
            $income += abs($ji->balance);
            $index++;
            $name =  $ji->id . ' - ' . $ji->acc_name;
            $value = abs($ji->balance);

            $data_income[$key] = ['label'=>$name,"y"=>$value];
        }

        /*$journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', "5%")
            ->where("jn.journal_status","!=",3)
            ->whereBetween('jn.journal_paydate', [$from, $to])->groupBy('chart.id')->get();*/
        $journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', "5%")
            ->where('jn.journal_status','!=',3)
            /*->when(!empty($project_id),function($q) use($project_id){
                $q->where('jn.journal_by_project',$project_id);
            })
           ->where('jn.journal_audit_status',1)
             ->whereBetween('jn.journal_paydate', [$from, $to])*/
            ->where(function($query) use($from,$to){
                if(!empty($from)&&!empty($to)){
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                }
            })
            ->groupBy('chart.id')->get();
        $data_expense = [];
        foreach ($journal_expense as $key => $je) {
            $index++;
            $expense += $je->balance;
            $name = $je->id . ' - ' . $je->acc_name;
            $value = $je->balance;

            $data_expense[$key] = ['label'=>$name,"y"=>$value];
        }

        $net_income = abs($income) - abs($expense);

        //Get Collected
        $collected = $this->get_dashbord_chart_month_collected();
       // dd($request->moths);
        $completed = $this->get_dashbord_chart_month_completed();
        //End
        $collection = $this->get_dashbord_chart_month_collection();


        return view('home',compact('data_income','data_expense','net_income','income','expense','collected','completed','collection'));
    }
    public function get_dashbord_chart_month_completed()
    {
        $month_text_first="";
        $month_text_last="";
        $completed = [];
        //January
        $month_text_first="first day of January ";
        $month_text_last="last day of January ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[0] = $data;

        //February
        $month_text_first="first day of February ";
        $month_text_last="last day of February ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[1] = $data;

        //March
        $month_text_first="first day of March ";
        $month_text_last="last day of March ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[2] = $data;

        //April
        $month_text_first="first day of April ";
        $month_text_last="last day of April ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[3] = $data;

        //May
        $month_text_first="first day of May ";
        $month_text_last="last day of May ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[4] = $data;

        //June
        $month_text_first="first day of June ";
        $month_text_last="last day of June ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[5] = $data;

        //July
        $month_text_first="first day of July ";
        $month_text_last="last day of July ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[6] = $data;

        //August
        $month_text_first="first day of August ";
        $month_text_last="last day of August ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[7] = $data;

        //September
        $month_text_first="first day of September ";
        $month_text_last="last day of September ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[8] = $data;

        //October
        $month_text_first="first day of October ";
        $month_text_last="last day of October ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[9] = $data;

        //November
        $month_text_first="first day of November ";
        $month_text_last="last day of November ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[10] = $data;

        //December
        $month_text_first="first day of December ";
        $month_text_last="last day of December ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $completed_payment_by_year =LoanModel::where("nso007_loan.status",1)->where("nso007_loan.amount_os","<=",1)->whereBetween("nso007_loan.diburment_date",[$first_day,$last_day])
                    ->select("nso007_loan.sale_amount",'nso007_loan.discount_amount')
                    ->groupBy("nso007_loan.id")
                    ->get();
        $data=0;

        foreach ($completed_payment_by_year as $key => $value) {
            $data+= $value->sale_amount-$value->discount_amount;
        }
        $completed[11] = $data;
        return $completed;
    }
    public function get_dashbord_chart_month_collected()
    {
        $month_text_first="";
        $month_text_last="";
        $collected = [];
        //January
        $collected_january_value = 0;
        $month_text_first="first day of January ";
        $month_text_last="last day of January ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();

        foreach ($collected_payment_by_year as $key => $value) {
            $collected_january_value+= $value->total_amount;
        }
        $collected[0] = $collected_january_value;

        //February
        $month_text_first="first day of February ";
        $month_text_last="last day of February ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_february_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_february_value+= $value->total_amount;
        }
        $collected[1] = $collected_february_value;

        //March
        $month_text_first="first day of March ";
        $month_text_last="last day of March ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_march_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_march_value+= $value->total_amount;
        }
        $collected[2] = $collected_march_value;

        //April
        $month_text_first="first day of April ";
        $month_text_last="last day of April ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_april_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_april_value+= $value->total_amount;
        }
        $collected[3] = $collected_april_value;

        //May
        $month_text_first="first day of May ";
        $month_text_last="last day of May ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_may_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_may_value+= $value->total_amount;
        }
        $collected[4] = $collected_may_value;

        //June
        $month_text_first="first day of June ";
        $month_text_last="last day of June ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_june_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_june_value+= $value->total_amount;
        }
        $collected[5] = $collected_june_value;

        //July
        $month_text_first="first day of July ";
        $month_text_last="last day of July ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_july_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_july_value+= $value->total_amount;
        }
        $collected[6] = $collected_july_value;

        //August
        $month_text_first="first day of August ";
        $month_text_last="last day of August ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_august_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_august_value+= $value->total_amount;
        }
        $collected[7] = $collected_august_value;

        //September
        $month_text_first="first day of September ";
        $month_text_last="last day of September ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_september_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_september_value+= $value->total_amount;
        }
        $collected[8] = $collected_september_value;

        //October
        $month_text_first="first day of October ";
        $month_text_last="last day of October ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_october_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_october_value+= $value->total_amount;
        }
        $collected[9] = $collected_october_value;

        //November
        $month_text_first="first day of November ";
        $month_text_last="last day of November ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_november_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_november_value+= $value->total_amount;
        }
        $collected[10] = $collected_november_value;

        //December
        $month_text_first="first day of December ";
        $month_text_last="last day of December ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collected_payment_by_year =LoanPaidModel::select("total_amount")
            ->whereBetween("payment_date",[$first_day,$last_day])
            ->where("status",1)
            ->get();
        $collected_december_value = 0;
        foreach ($collected_payment_by_year as $key => $value) {
            $collected_december_value+= $value->total_amount;
        }
        $collected[11] = $collected_december_value;
        return $collected;
    }
    public function get_dashbord_chart_month_collection()
    {
        $month_text_first="";
        $month_text_last="";
        $collection = [];
        //January
        $month_text_first="first day of January ";
        $month_text_last="last day of January ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[0] = $data;

        //February
        $month_text_first="first day of February ";
        $month_text_last="last day of February ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[1] = $data;

        //March
        $month_text_first="first day of March ";
        $month_text_last="last day of March ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[2] = $data;

        //April
        $month_text_first="first day of April ";
        $month_text_last="last day of April ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[3] = $data;

        //May
        $month_text_first="first day of May ";
        $month_text_last="last day of May ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[4] = $data;

        //June
        $month_text_first="first day of June ";
        $month_text_last="last day of June ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[5] = $data;

        //July
        $month_text_first="first day of July ";
        $month_text_last="last day of July ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[6] = $data;

        //August
        $month_text_first="first day of August ";
        $month_text_last="last day of August ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[7] = $data;

        //September
        $month_text_first="first day of September ";
        $month_text_last="last day of September ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[8] = $data;

        //October
        $month_text_first="first day of October ";
        $month_text_last="last day of October ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[9] = $data;

        //November
        $month_text_first="first day of November ";
        $month_text_last="last day of November ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[10] = $data;

        //December
        $month_text_first="first day of December ";
        $month_text_last="last day of December ";
        $first_day = new DateTime($month_text_first. date('Y'));
        $last_day = new DateTime($month_text_last. date('Y'));

        $collection_payment_by_year =LoanProcessModel::where("nso007_loan_process.owe_amount_pay",'>',0)
                    ->select('nso007_loan_process.owe_amount_pay')
                    ->whereBetween("date_payment",[$first_day,$last_day])
                    ->where("nso007_loan_process.status",1)
                    ->get();
        $data=0;

        foreach ($collection_payment_by_year as $key => $value) {
            $data+= $value->owe_amount_pay;
        }
        $collection[11] = $data;
        return $collection;
    }
    public function lang($locale)
    {
        App::setLocale($locale);
        session()->put('locale', $locale);
        return \back();
    }
    public function get_income_expense(Request $request){
        dd("OK");
        $month_text_first="first day of January ";
        $month_text_last="last day of December ";
        $from           = new DateTime($month_text_first. date('Y'));
        $to             = new DateTime($month_text_last. date('Y'));

        $journal_income = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', "4%")
            ->whereBetween('jn.journal_paydate', [$from, $to])->groupBy('chart.id')->get();

        $index      = 0;
        $income     = 0;
        $expense    = 0;
        $data_income = [];
        foreach ($journal_income as $key => $ji) {
            $income += abs($ji->balance);
            $index++;
            $name =  $ji->id . ' - ' . $ji->acc_name;
            $value = abs($ji->balance);

            $data_income[$key] = ['label'=>$name,"y"=>$$value];
        }
        $total_income = $income;

        $journal_expense = DB::table('nso007_journal as jn')
            ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
            ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
            ->where('chart.acctype', 'LIKE', "5%")
            ->whereBetween('jn.journal_paydate', [$from, $to])->groupBy('chart.id')->get();
        $data_expense = [];
        foreach ($journal_expense as $key => $je) {
            $index++;
            $expense += $je->balance;
            $name = $je->id . ' - ' . $je->acc_name;
            $value = $je->balance;

            $data_expense[$key] = ['label'=>$name,"y"=>$value];
        }

        $data = array('journal_income' => $journal_income, 'journal_expense'=>$journal_expense);

        $data = array('data_income' => $data_income);

        return json_encode($data);
    }
}
