<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\AdvanceSalaryModel;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrGenSalaryModel;
use App\Models\Hr\HrPositionModel;
use Yajra\DataTables\DataTables;
use App\User;
use Illuminate\Support\Facades\DB;

class ReportPayrollController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Payroll List', ['only' => ['get_report_payroll']]);
        $this->middleware('permission:Report Salary Authorize List', ['only' => ['authorize_salary_list']]);
        $this->middleware('permission:Report Advance Salary List', ['only' => ['advance_salary_list']]);
    }
    public function get_report_payroll(Request $request)
    {
        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;

        $from_date           = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date             = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

        $count_total    = HrGenSalaryModel::where('status',1)
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('nso007_hr_gen_salaries.emp_id',$emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('nso007_hr_gen_salaries.branch_id',$branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('nso007_hr_gen_salaries.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('nso007_hr_gen_salaries.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('nso007_hr_gen_salaries.from_date', [$from_date, $to_date]);
                            })
                            ->count();
        $data           = HrGenSalaryModel::select('users.english_name','users.email', 'nso007_hr_gen_salaries.*')
                            ->join('users', 'users.id', 'nso007_hr_gen_salaries.emp_id')
                            ->where('nso007_hr_gen_salaries.status',1)
                            ->where(function($q) use($search){
                                // $q->orwhere('users.english_name','LIKE',"%$search%");
                                // $q->orwhere('users.khmer_name','LIKE',"%$search%");
                                $q->orwhere('users.email','LIKE',"%$search%");
                            })
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('nso007_hr_gen_salaries.emp_id',$emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('nso007_hr_gen_salaries.branch_id',$branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('nso007_hr_gen_salaries.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('nso007_hr_gen_salaries.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('nso007_hr_gen_salaries.from_date', [$from_date, $to_date]);
                            });

        $count_filter = $data->count();
        if ($request->ajax())
        {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()
                ->editColumn('emp_id', function ($gen_salary) {
                    return optional($gen_salary->employee)->english_name;
                })
                ->editColumn('branch', function ($data) {
                    return optional($data->branch)->english_name;
                })
                ->editColumn('department', function ($data) {
                    return optional($data->department)->english_name;
                })
                ->editColumn('position', function ($data) {
                    return optional($data->position)->english_name;
                })
                ->editColumn('dob', function($data){
                    return $data->date_of_birth ? date('d-m-Y', strtotime($data->date_of_birth)) : "";
                })
                ->make(true);

        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $branch     = HrBranch::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $department = HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $position   = HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');

        return view('hr.report-payroll.list-payroll', compact('user', 'branch', 'department', 'position'));
    }
    public function authorize_salary_list(Request $request)
    {
        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;

        $from_date      = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));
        $count_total    = HrGenSalaryModel::where('status',1)
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('nso007_hr_gen_salaries.emp_id',$emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('nso007_hr_gen_salaries.branch_id',$branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('nso007_hr_gen_salaries.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('nso007_hr_gen_salaries.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('nso007_hr_gen_salaries.from_date', [$from_date, $to_date]);
                            })
                            ->count();
        $data           = HrGenSalaryModel::select('users.english_name','users.email', 'nso007_hr_gen_salaries.*')
                            ->join('users', 'users.id', 'nso007_hr_gen_salaries.emp_id')
                            ->where('nso007_hr_gen_salaries.status',1)
                            ->where(function($q) use($search){
                                // $q->orwhere('users.english_name','LIKE',"%$search%");
                                // $q->orwhere('users.khmer_name','LIKE',"%$search%");
                                $q->orwhere('users.email','LIKE',"%$search%");
                            })
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('nso007_hr_gen_salaries.emp_id',$emp_id);
                            })
                            ->when($branch_id, function ($q, $branch_id){
                                $q->where('nso007_hr_gen_salaries.branch_id',$branch_id);
                            })
                            ->when($department_id, function ($q, $department_id){
                                $q->where('nso007_hr_gen_salaries.department_id', $department_id);
                            })
                            ->when($position_id, function ($q, $position_id){
                                $q->where('nso007_hr_gen_salaries.position_id', $position_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('nso007_hr_gen_salaries.from_date', [$from_date, $to_date]);
                            });

        $count_filter = $data->count();
        if ($request->ajax())
        {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()
                ->editColumn('employee', function ($gen_salary) {
                    return optional($gen_salary->employee)->english_name;
                })
                ->editColumn('branch', function ($data) {
                    return optional($data->branch)->english_name;
                })
                ->editColumn('department', function ($data) {
                    return optional($data->department)->english_name;
                })
                ->editColumn('position', function ($data) {
                    return optional($data->position)->english_name;
                })
                ->editColumn('dob', function($data){
                    return $data->user_dob ? date('d-m-Y', strtotime($data->user_dob)) : "";
                })
                ->editColumn('basic_salary', function($data){
                    return $data->basic_salary ? '$ '.number_format($data->basic_salary, 2) : 0;
                })
                ->editColumn('advance_salary', function($data){
                    return $data->advance_salary ? '$ '.number_format($data->advance_salary, 2) : 0;
                })
                ->editColumn('take_leave', function($data){
                    return $data->take_leave ? '$ '.number_format($data->take_leave, 2) : 0;
                })
                ->editColumn('benefit', function($data){
                    return $data->benefit ? '$ '.number_format($data->benefit, 2) : 0;
                })
                ->editColumn('total_ot', function($data){
                    return $data->total_ot ? '$ '.number_format($data->total_ot, 2) : 0;
                })
                ->editColumn('net_pay_kh', function($data){
                    return $data->net_pay_kh ? '៛ '.number_format($data->net_pay_kh, 2) : 0;
                })
                ->editColumn('net_pay_th', function($data){
                    return $data->net_pay_th ? '฿ '.number_format($data->net_pay_th, 2) : 0;
                })
                ->editColumn('net_pay', function($data){
                    return $data->net_pay ? '$ '.number_format($data->net_pay, 2) : 0;
                })
                ->make(true);

        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $branch     = HrBranch::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $department = HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $position   = HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');

        return view('hr.report-payroll.salary-authorize-list', compact('user', 'branch', 'department', 'position'));
    }
    public function advance_salary_list(Request $request)
    {
        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;

        $from_date      = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

        $count_total    = AdvanceSalaryModel::where('approve', 0)
                                        ->when($emp_id, function($q, $emp_id){
                                            $q->where('nso007_hr_advance_salaries.emp_id',$emp_id);
                                        })
                                        ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                            $query->whereBetween('nso007_hr_advance_salaries.effect_date', [$from_date, $to_date]);
                                        })
                                        ->count();
        $data           = AdvanceSalaryModel::where('approve', 0)
                                        ->when($emp_id, function($q, $emp_id){
                                            $q->where('nso007_hr_advance_salaries.emp_id',$emp_id);
                                        })
                                        ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                            $query->whereBetween('nso007_hr_advance_salaries.effect_date', [$from_date, $to_date]);
                                        });
        $count_filter   = $data->count();
        if ($request->ajax()) {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('employee', function ($data) {
                    return optional($data->get_employee)->english_name;
                })
                ->editColumn('advance_salary', function($data){
                    return $data->advance_salary ? '$ '.$data->advance_salary : '';
                })
                ->editColumn('effect_date', function($data){
                    return $data->effect_date != null ? date('d-m-Y', strtotime($data->effect_date)) : '';
                })
                ->addIndexColumn()
                ->make(true);
        }
        $user       = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $branch     = HrBranch::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $department = HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'), '');
        $position   = HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'));

        return view('hr.report-payroll.advance-salary-list', compact('user', 'branch', 'department', 'position'));
    }
}
