<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\HrEmployeeBenefitModel;
use Yajra\DataTables\DataTables;

class ReportBenefitController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Benefit List', ['only' => ['get_report_benefit']]);
    }
    public function get_report_benefit(Request $request)
    {
        $search         = $request->input('search.value');
        $emp_id         = $request->emp_id;
        $branch_id      = $request->branch_id;
        $department_id  = $request->department_id;
        $position_id    = $request->position_id;

        $from_date           = (empty($request->from_date)) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date             = (empty($request->to_date)) ? '' : date('Y-m-d', strtotime($request->to_date));

        $count_total    = HrEmployeeBenefitModel::where('status',1)->groupBy('emp_id')
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('users.date', [$from_date, $to_date]);
                            })
                            ->count();
        $data           = HrEmployeeBenefitModel::where('status',1)
                            ->groupBy('emp_id')
                            ->where(function($q) use($search){
                                $q->orwhere('nso007_hr_employee_benefit.id','LIKE',"%$search%");
                            })
                            ->when($emp_id, function($q, $emp_id){
                                $q->where('nso007_hr_employee_benefit.emp_id', $emp_id);
                            })
                            ->when(request('from_date', ''), function ($query) use ($from_date, $to_date) {
                                $query->whereBetween('users.date', [$from_date, $to_date]);
                            });

        $count_filter = $data->count();
        if ($request->ajax())
        {
            return DataTables::of($data->take(10))
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->addIndexColumn()
                ->editColumn('emp_id', function ($data) {
                    return optional($data->get_employee)->name;
                })
                ->editColumn('benefit_id', function ($data) {
                    $benefit = HrEmployeeBenefitModel::where('emp_id', $data->emp_id)->get();

                    $show_benefit = '';
                    foreach ($benefit as $row)
                    {
                        $show_benefit .= '<span class="button_info">' . optional($row->get_benefit)->name . '</span>';
                    }
                    return $show_benefit;
                })
                ->rawColumns(['benefit_id' => 'benefit_id'])
                ->make(true);

        }
        return view('hr.report-benefit.list-benefit');
    }
}
