<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\OvertimeTypeModel;
use Yajra\DataTables\DataTables;

class OvertimeTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = OvertimeTypeModel::take(20);
            return DataTables::of($data)
                        ->addIndexColumn()
                        ->editColumn('date', function($data){
                            return $data->date ? date('d-m-Y', strtotime($data->date)) : "";
                        })
                        ->addColumn('action', function($data){
                            $btn_edit = '<a href="'.route('overtime-type.edit', encrypt($data->id)).'" class="button_warning"><span class="fa fa-pencil-square-o"></span></a>';
                            $btn_delete = '<a class="button_danger btn_delete" data-id="'.$data->id.'"><span class="fa fa-trash-o"></span></a>';
    
                            return $btn_edit.$btn_delete;
                        })
                        ->rawColumns(['action', 'action'])
                        ->make(true);
        }
        return view('hr.overtime-type.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.overtime-type.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'en_name' => 'required',
            'kh_name' => 'required',
            'date'    => 'required'
        ]);

        $overtime_type          = new OvertimeTypeModel();
        $overtime_type->en_name = $request->en_name;
        $overtime_type->kh_name = $request->kh_name;
        $overtime_type->date    = $request->date;
        $overtime_type->note    = $request->note;
        $overtime_type->save();

        return redirect()->route('overtime-type.index')->with('success', 'Data was saved successful!.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $overtime_type = OvertimeTypeModel::findOrFail($id);
        return view('hr.overtime-type.edit', compact('overtime_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'en_name' => 'required',
            'kh_name' => 'required',
            'date'    => 'required'
        ]);

        $overtime_type          = OvertimeTypeModel::findOrFail($id);
        $overtime_type->en_name = $request->en_name;
        $overtime_type->kh_name = $request->kh_name;
        $overtime_type->date    = $request->date;
        $overtime_type->note    = $request->note;
        $overtime_type->update();

        return redirect()->route('overtime-type.index')->with('success', 'Data was updated successful!.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //delete overtime type

    public function delete_overtime_type(Request $request)
    {
        $id = $request->delete_id;
        OvertimeTypeModel::where('id', $id)->delete();
        return redirect()->route('overtime-type.index')->with('success', 'Data was deleted successful!.');
    }
}
