<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrWorkdayModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;

class HrWorkdayController extends Controller
{

    public function index()
    {
        return view('hr.work-day.index');
    }
    public function get_workday()
    {
        $data = HrWorkdayModel::get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $bedit = '';
                if($data->status == 0){
                    $bedit = '<a href="'.route('hr-work-day.edit',encrypt($data->id)).'" class="button_warning">'.$edit.'</a>';
                }
                return $bedit;
            })
            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }
    public function create()
    {
        return view('hr.work-day.create');
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'code' => 'required|unique:nso007_hr_work_day,code',
            'name' => 'required',
            'work' => 'required',
        ]);
        $day = new HrWorkdayModel();
        $day -> code = $request->code;
        $day -> name = $request->name;
        $day -> work = $request->work;
        $day -> save();
        return redirect()->route('hr-work-day.index')->with('success','Workday was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $day = HrWorkdayModel::find(decrypt($id));
        return view('hr.work-day.edit',compact('day'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'code' => 'required|unique:nso007_hr_work_day,code,'.$id,
            'name' => 'required',
            'work' => 'required',
        ]);
        $day = HrWorkdayModel::find($id);
        $day -> code = $request->code;
        $day -> name = $request->name;
        $day -> work = $request->work;
        $day -> update();
        return redirect()->route('hr-work-day.index')->with('success','Workday was updated successful...');
    }

    public function destroy($id)
    {
        //
    }
}
