<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrTravelRequestModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrTravelRequestController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Travel Request List', ['only' => ['index', 'get_travel_request']]);
        $this->middleware('permission:Travel Request Create', ['only' => ['create','store']]);
        $this->middleware('permission:Travel Request Show', ['only' => ['view_modal']]);
        $this->middleware('permission:Travel Request Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Travel Request Approve', ['only' => ['travel_status']]);
    }

    public function index()
    {
        return view('hr.travel-request.index');
    }

    public function get_travel_request()
    {
        $data = HrTravelRequestModel::take(20);
        return DataTables::of($data)
            ->addIndexColumn()
            ->editColumn('emp_id', function ($data) {
                return optional($data->employee)->english_name;
            })
            ->editColumn('amount', function ($data) {
                return $data->amount.($data->currency == 'riel'?' ៛':' $');
            })
            ->editColumn('from_date', function ($data){
                return $data->from_date ? date('d-m-Y', strtotime($data->from_date)) : "";
            })
            ->editColumn('to_date', function ($data){
                return $data->to_date ? date('d-m-Y', strtotime($data->to_date)) : "";
            })
            ->editColumn('status', function ($data) {
                $status = '';
                $label = '';
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $pending = "រង់ចាំ";
                    $approve = "ទទួលយកសំណើរ";
                    $reject = "បដិសេធសំណើរ";
                } else {
                    $pending = "Pending";
                    $reject = "Rejected";
                    $approve = "Approved";
                }
                if($data->status == 0){
                    $status = $pending;
                    $label = 'text-warning';
                }
                if($data->status == 1){
                    $status = $approve;
                    $label = 'text-success';
                }
                if($data->status == 2){
                    $status = $reject;
                    $label = 'text-danger';
                }
                return ' <a class="viewPopLink '.$label.'" role="button" data-id="' . $data->id . '" data-status="' . $data->status . '"  data-toggle="modal tooltip" data-target="#myModal" data-placement="top" title="'.$status.'">'.$status.'</a>';

            })
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $view = "បង្ហាញ";
                    $delete = "លុបចោល";
                } else {
                    $edit = "Edit";
                    $view = "View";
                    $delete = "Delete";
                }
                $btn_edit = "";
                $btn_view ="";
                $btn_delete="";
                if (Gate::check('Travel Request Show')) {
                    if($data->status == 0) {
                        $btn_edit .= '<a href="' . route('hr-travel-request.edit', encrypt($data->id)) . '" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                    }
                }
                if (Gate::check('Travel Request Edit')) {
                    $btn_view .= ' <a class="btn btn-sm btn-info viewtravel" role="button" data-id="' . $data->id . '" data-toggle="modal tooltip" data-target="#viewModal" data-placement="top" title="' . $view . '"><span class="fa fa-eye"></span> Show</a>&nbsp;';
                }
                if (Gate::check('Travel Request Delete')) {
                    $btn_delete .= '<a class="btn btn-sm btn-danger btn-delete-travel" role="button" data-id="' . $data->id . '" data-toggle="modal tooltip" data-target="" data-placement="top" title="' . $delete . '"><span class="fa fa-trash"></span> Delete</a>';
                }
                return $btn_view.$btn_edit.$btn_delete;
            })
            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }

    public function create()
    {
        $emp = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        return view('hr.travel-request.create', compact('emp'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'emp_id'            => 'required',
            'travel_by'         => 'required',
            'purpose'           => 'required',
            'from'              => 'required',
            'to'                => 'required',
            'from_date'         => 'required',
            'to_date'           => 'required',
            'currency'          => 'required',
            'amount'            => 'required',

        ]);
        $travel         = new HrTravelRequestModel();
        $mili           = round(microtime(true) * 1000);
        $mili           = substr_replace($mili,'','0','9');
        $file1          = $request->file1;
        $file2          = $request->file12;
        $file_name1     = '';
        $file_name2     = '';
        if ($file1) {
            $file_name1 = $file1->getClientOriginalName();
            $file_name1 = $request->emp_id.date('d').$mili .'_'. $file_name1;
            $destinationPath = 'assets/attachment_file';
            if ($file1->move($destinationPath, $file_name1)) {
                $travel->file1 = $file_name1;
            }
        }
        if ($file2) {
            $file_name2 = $file2->getClientOriginalName();
            $file_name2 = $request->emp_id.date('d').$mili .'_'. $file_name2;
            $destinationPath = 'assets/attachment_file';
            if ($file2->move($destinationPath, $file_name2)) {
                $travel->file2 = $file_name2;
            }
        }
        $travel->emp_id     = $request->emp_id;
        $travel->travel_by  = $request->travel_by;
        $travel->purpose    = $request->purpose;
        $travel->from       = $request->from;
        $travel->to         = $request->to;
        $travel->from_date  = date('Y-m-d',strtotime($request->from_date));
        $travel->to_date    = date('Y-m-d',strtotime($request->to_date));
        $travel->amount     = $request->amount;
        $travel->currency   = $request->currency;
        $travel->note       = $request->note;
        $travel->status     = 0;
        $travel->file1      = $file_name1;
        $travel->file2      = $file_name2;

        $travel->save();

        return redirect()->route('hr-travel-request.index')->with('success', 'Travel request was saved ...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $emp    = User::pluck('english_name', 'id')->prepend(__('administrator.please_select'),'');
        $travel = HrTravelRequestModel::find(decrypt($id));
        return view('hr.travel-request.edit', compact('emp','travel'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'emp_id'        => 'required',
            'travel_by'     => 'required',
            'purpose'       => 'required',
            'from'          => 'required',
            'to'            => 'required',
            'from_date'     => 'required',
            'to_date'       => 'required',
            'currency'      => 'required',
            'amount'        => 'required',

        ]);
        $travel         = HrTravelRequestModel::find($id);
        $mili           = round(microtime(true) * 1000);
        $mili           = substr_replace($mili,'','0','9');
        $file1          = $request->file1;
        $file2          = $request->file12;
        $file_name1     = '';
        $file_name2     = '';

        if ($file1) {
            $file_name1 = $file1->getClientOriginalName();
            $file_name1 = $request->emp_id.date('d').$mili .'_'. $file_name1;
            $destinationPath = 'assets/attachment_file';
            if ($file1->move($destinationPath, $file_name1)) {
                $travel->file1 = $file_name1;
                if (file_exists(public_path() . '/assets/attachment_file/' . $request->old_file1)) {
                    if ($request->old_file1 != '') {
                        unlink(public_path() . '/assets/attachment_file/' . $request->old_file1);
                    }
                }
            }
        }else{
            $travel->file1 = $request->old_file1;
        }
        if ($file2) {
            $file_name2 = $file2->getClientOriginalName();
            $file_name2 = $request->emp_id.date('d').$mili .'_'. $file_name2;
            $destinationPath = 'assets/attachment_file';
            if ($file2->move($destinationPath, $file_name2)) {
                $travel->file2 = $file_name2;
                if (file_exists(public_path() . '/assets/attachment_file/' . $request->old_file2)) {
                    if ($request->old_file2 != '') {
                        unlink(public_path() . '/assets/attachment_file/' . $request->old_file2);
                    }
                }
            }
        }else{
            $travel->file2 = $request->old_file2;
        }
        $travel->emp_id         = $request->emp_id;
        $travel->travel_by      = $request->travel_by;
        $travel->purpose        = $request->purpose;
        $travel->from           = $request->from;
        $travel->to             = $request->to;
        $travel->from_date      = date('Y-m-d',strtotime($request->from_date));
        $travel->to_date        = date('Y-m-d',strtotime($request->to_date));
        $travel->amount         = $request->amount;
        $travel->currency       = $request->currency;
        $travel->note           = $request->note;
        $travel->file1          = $file_name1;
        $travel->file2          = $file_name2;

        $travel->update();

        return redirect()->route('hr-travel-request.index')->with('success', 'Travel request was updated ...');
    }

    public function destroy($id)
    {
        //
    }
    public function travel_status(Request $request){
        $travel             = HrTravelRequestModel::find($request->id);
        $travel->status     = $request->status;
        $travel->update();
        return redirect()->route('hr-travel-request.index')->with('success','Travel status was change successful...');
    }
    public function view_modal(){
        $travel = HrTravelRequestModel::find($_GET['id']);
        $employee = optional($travel->employee);
        $status = '';
        $check_language = Fun::lang();
        if ($check_language == 'km') {
            $pending = "រង់ចាំ";
            $approve = "ទទួលយកសំណើរ";
            $reject = "បដិសេធសំណើរ";
        } else {
            $pending = "Pending";
            $reject = "Rejected";
            $approve = "Approved";
        }
        if($travel->status == 1){
            $status = '<span class="label label-success">'.$approve.'</span>';
        }
        if($travel->status == 0){
            $status = '<span class="label label-warning">'.$pending.'</span>';
        }
        if($travel->status == 2){
            $status = '<span class="label label-danger">'.$reject.'</span>';
        }
        $amount = $travel->amount.($travel->currency == 'riel'?' ៛':' $');
        $data = [
            'employee'      => $employee->name,
            'travel_by'     => $travel->travel_by,
            'purpose'       => $travel->purpose,
            'from'          => $travel->from,
            'to'            => $travel->to,
            'from_date'     => date('d-m-Y',strtotime($travel->from_date)),
            'to_date'       => date('d-m-Y',strtotime($travel->to_date)),
            'amount'        => $amount,
            'note'          => $travel->note,
            'file1'         => $travel->file1,
            'file2'         => $travel->file2,
            'statuss'       => $status,
        ];
        return response()->json(['datas' => $data]);
    }
    // delete travel request
    public function delete_travel(Request $request)
    {
        $id = $request->delete_id;
        HrTravelRequestModel::where('id', $id)->delete();
        return redirect()->route('hr-travel-request.index')->with('success', 'Deleted Successful!..');
    }
}
