<?php

namespace App\Http\Controllers\HR;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DataTables;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class HrRoleController extends Controller
{
    function __construct()
    {
        //$this->middleware('permission:Employee Resign Edit', ['only' => ['edit','update']]);
    }
    public function index()
    {
        $data = Role::where('group_role','hr')->get();
        return view('hr.hr-role.index',compact('data'));
    }


    public function create()
    {
        $group_app_name = Permission::where('app_name','HR')->groupBy('group_name')->get();

        return view('hr.hr-role.create',compact('group_app_name'));
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:roles,name',
            'permission' => 'required',
        ]);
        $role = new Role();
        $role->name =  $request->input('name');
        $role->group_role =  'hr';
        $role->save();
        $role->syncPermissions($request->input('permission'));
        return redirect()->back()
            ->with('success','Hr-Role created successfully !');
    }
    public function show($id)

    {
        $decrypt_id = Crypt::decrypt($id);
        $role = Role::find($decrypt_id);

        $rolePermissions = Permission::join("role_has_permissions","role_has_permissions.permission_id","=","permissions.id")
            ->where("role_has_permissions.role_id",$decrypt_id)
            ->get();
        return view('hr.hr-role.show',compact('role','rolePermissions'));

    }
    public function edit($id)

    {

        $role = Role::find($id);
        $permission = Permission::get();
        $group_app_name = Permission::where('app_name','HR')->groupBy('group_name')->get();
        $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$id)
            ->pluck('role_has_permissions.permission_id','role_has_permissions.permission_id')
            ->all();
        return view('hr.hr-role.edit',compact('role','permission','rolePermissions','group_app_name'));

    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required',
            'permission' => 'required',
        ]);
        $role = Role::find($id);
        $role->name = $request->input('name');
        $role->group_role =  'app';
        $role->save();

        $role->syncPermissions($request->input('permission'));
        return redirect()->back()
            ->with('success','Hr-Role updated successfully !');


    }


    public function destroy($id)

    {

        DB::table("roles")->where('id',$id)->delete();

        return redirect()->route('hr-roles.edit')

            ->with('success','Hr-Role deleted successfully');

    }

}
