<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrResignModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrResignController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Employee Resign List', ['only' => ['index', 'get_emp_resign']]);
        $this->middleware('permission:Employee Resign Create', ['only' => ['create']]);
        $this->middleware('permission:Employee Resign Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Employee Resign Delete', ['only' => ['delete_resign']]);
    }
    public function index()
    {
        return view('hr.resign.index');
    }

    //get resign
    public function get_emp_resign()
    {
        $data = HrResignModel::take(20);
        return DataTables::of($data)
                        ->addIndexColumn()
                        ->editColumn('resign_date', function($data){
                            return $data->resign_date ? date('d-m-Y', strtotime($data->resign_date)) : "";
                        })
                        ->editColumn('branch_id', function($data){
                            return optional($data->branchs)->english_name;
                        })
                        ->editColumn('department_id', function($data){
                            return optional($data->departments)->english_name;
                        })
                        ->editColumn('position_id', function($data){
                            return optional($data->positions)->english_name;
                        })
                        ->editColumn('action', function($data){
                            $btn_view ="";
                            $btn_delete ="";
                            if(Gate::check('Employee Resign Edit')){
                                $btn_view .= '<a href="'.route('hr-emp-resign.edit', $data->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                            }
                            if(Gate::check('Employee Resign Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn-delete-resign" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_view.$btn_delete;
                        })
                        ->rawColumns(['action' => 'Action'])
                        ->make(true);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp = User::where('status',1)->pluck('name','id');
        return view('hr.resign.create', compact('emp'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\HrResignModel  $hrResignModel
     * @return \Illuminate\Http\Response
     */
    public function show(HrResignModel $hrResignModel)
    {

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\HrResignModel  $hrResignModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $emp = User::where('status',1)->pluck('english_name','id');
        return view('hr.resign.edit', compact('emp','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrResignModel  $hrResignModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request,[
            'resign_date' => 'required',
            'reason' => 'required',
            'status' => 'required',
            'type' => 'required'
        ]);

        if($request->status == "0"){
            $emp = User::find($id);
            $emp->status = $request->status;
            $emp->save();

        }
        if($request->status == "0"){
            $resign = new HrResignModel();
            $emp = User::where('id', $id)->first();
            $resign->parent_id          = $emp->parent_id;
            $resign->leader_id          = $emp->leader_id;
            $resign->group_id           = $emp->group_id;
            $resign->branch_id          = $emp->branch_id;
            $resign->department_id      = $emp->department_id;
            $resign->position_id        = $emp->position_id;
            $resign->employment_id      = $emp->employment_id;
            $resign->user_year          = $emp->user_year;
            $resign->code               = $emp->user_code;
            $resign->name               = $emp->english_name;
            $resign->name_kh            = $emp->khmer_name;
            $resign->phone              = $emp->user_phone;
            $resign->email              = $emp->email;
            $resign->nationality        = $emp->nationality;
            $resign->date_of_birth      = $emp->user_dob;
            $resign->address            = $emp->address;
            $resign->place_of_birth     = $emp->place_of_birth;
            $resign->gender             = $emp->user_gender;
            $resign->marital_status     = $emp->marital_status;
            $resign->id_card            = $emp->user_cardid;
            $resign->avartar            = $emp->avatar;
            $resign->joined_date        = $emp->joined_date;
            $resign->department         = $emp->department;
            $resign->is_role            = $emp->role;
            $resign->role               = $emp->role;
            $resign->supervisor         = $emp->supervisor;
            $resign->certificate        = $emp->certificate;
            $resign->skill              = $emp->skill;
            $resign->dependent          = $emp->dependent;
            $resign->note               = $emp->note;
            $resign->status             = $emp->status;
            $resign->user_type          = $emp->user_type;
            $resign->basic_salary       = $emp->basic_salary;
            $resign->language           = $emp->language;
            $resign->educate            = $emp->educate;
            $resign->emergency_contact  = $emp->emergency_contact;
            $resign->family             = $emp->family;
            $resign->family_full        = $emp->family_full;
            $resign->work_experience    = $emp->work_experience;
            $resign->spouse             = $emp->spouse;
            $resign->child              = $emp->child;
            $resign->increment          = $emp->increment;
            $resign->meal_transport_allowance = $emp->meal_transport_allowance;
            $resign->position_allowance = $emp->position_allowance;
            $resign->other_allowance    = $emp->other_allowance;

            $resign->resign_date        = date('Y-m-d',strtotime($request->resign_date));
            $resign->reason             = $request->reason;
            $resign->status             = $request->status;
            $resign->type               = $request->type;
            $resign->save();
        }
        return redirect()->route('hr-resign.index')->with('Success','Successful');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrResignModel  $hrResignModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(HrResignModel $hrResignModel)
    {

    }

    //delete resign
    public function delete_resign(Request $request)
    {
        $id = $request->delete_id;
        HrResignModel::where('id', $id)->delete();
        return redirect()->route('hr-resign.index')->with('success', 'Deleted Successful!..');
    }

}
