<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\RecommendationModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class HrRecommendationController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Recommendation Create', ['only' => ['create', 'store']]);
        $this->middleware('permission:Recommendation List', ['only' => ['index']]);
        $this->middleware('permission:Recommendation Edit', ['only' => ['update','edit']]);
    }
    public function index(Request $request)
    {
        $recommend = RecommendationModel::with(['get_employee', 'get_request_to'])->get();
        if($request->ajax())
        {
            return DataTables::of($recommend->take(20))
                            ->addIndexColumn()
                            ->with([
                                "recordsTotal" => $recommend->count(),
                                "recordsFiltered" => $recommend->count()
                            ])
                            ->addColumn('employee', function($row){
                                return optional($row->get_employee)->english_name;
                            })
                            ->addColumn('request_to', function($row){
                                return optional($row->get_request_to)->english_name;
                            })
                            ->addColumn('action', function($row){
                                $btn_edit = '';
                                if(Gate::check('Recommendation Edit')){
                                    $btn_edit = '<a href="'.route('hr-recommendation.edit',$row->id).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>';
                                }
                                return $btn_edit;
                            })
                            ->rawColumns(['action'])
                            ->make(true);
        }
        return view('hr.recommendation.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp = User::where('status',1)->pluck('english_name','id');
        return view('hr.recommendation.create', compact('emp'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'emp_id' => 'required',
            'request_to' => 'required'
        ]);
        //dd($request->all());
        $recommend = new RecommendationModel();
        $recommend->emp_id = $request->emp_id;
        $recommend->request_to = $request->request_to;

        $recommend->increment_comment = $request->in_comment;
        $recommend->increment_date = date('Y-m-d',strtotime($request->in_date));
        $recommend->increment_description = $request->in_description;

        $recommend->bonus_comment = $request->bonus_comment;
        $recommend->bonus_date = date('Y-m-d',strtotime($request->bonus_date));
        $recommend->bonus_description = $request->bonus_description;

        $recommend->promote_comment = $request->pro_comment;
        $recommend->promote_description = $request->pro_description;

        $recommend->opportunity_comment = $request->opp_comment;
        $recommend->opportunity_description = $request->opp_description;

        $recommend->save();

        return redirect()->route('hr-recommendation.index')->with('success', 'Added Successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\RecommendationModel  $recommendationModel
     * @return \Illuminate\Http\Response
     */
    public function show(RecommendationModel $recommendationModel)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\RecommendationModel  $recommendationModel
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $recommend = RecommendationModel::find($id);
        $emp = User::where('status',1)->pluck('english_name','id');
        return view('hr.recommendation.edit',compact('recommend','emp'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\RecommendationModel  $recommendationModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'emp_id' => 'required',
            'request_to' => 'required'
        ]);

        $recommend = RecommendationModel::find($id);
        $recommend->emp_id = $request->emp_id;
        $recommend->request_to = $request->request_to;

        $recommend->increment_comment = $request->increment_comment;
        $recommend->increment_date = date('Y-m-d',strtotime($request->increment_date));
        $recommend->increment_description = $request->increment_description;

        $recommend->bonus_comment = $request->bonus_comment;
        $recommend->bonus_date = date('Y-m-d',strtotime($request->bonus_date));
        $recommend->bonus_description = $request->bonus_description;

        $recommend->promote_comment = $request->promote_comment;
        $recommend->promote_description = $request->promote_description;

        $recommend->opportunity_comment = $request->opportunity_comment;
        $recommend->opportunity_description = $request->opportunity_description;

        $recommend->update();

        return redirect()->route('hr-recommendation.index')->with('success', 'Updated Successful!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\RecommendationModel  $recommendationModel
     * @return \Illuminate\Http\Response
     */
    public function destroy(RecommendationModel $recommendationModel)
    {
        //
    }
}
