<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrLeaveDetailModel;
use App\Models\Hr\HrLeaveRequestModel;
use App\Models\Hr\HrLeaveTypeModel;
use App\Models\Hr\HrWorkdayModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\DataTables;

class HrLeaveRequestController extends Controller
{
    public function index()
    {
        return view('hr.leave.index');
    }

    public function staff_leave()
    {
        return view('hr.leave.staff-leave');
    }

    public function get_leave()
    {
        $data = HrLeaveRequestModel::get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $view = "បង្ហាញ";
                } else {
                    $edit = "Edit";
                    $view = 'View';
                }
                $bedit = '';
                if ($data->status == 0) {
                    $bedit = '<a href="' . route('hr-leave-request.edit', encrypt($data->id)) . '" class="button_warning">' . $edit . '</a>';
                }
                return ' <a class="button_success viewLeave" role="button" data-id="' . $data->id . '" data-toggle="modal tooltip" data-target="#viewModal" data-placement="top" title="' . $view . '">' . $view . '</a>' . $bedit;
            })
            ->editColumn('emp_id', function ($data) {
                return optional($data->employee)->name;
            })
            ->editColumn('leave_type', function ($data) {
                return optional($data->leaveType)->name;
            })
            ->editColumn('to_date', function ($data) {
                return date('d-m-Y', strtotime($data->to_date));
            })
            ->editColumn('from_date', function ($data) {
                return date('d-m-Y', strtotime($data->from_date));
            })
            ->editColumn('status', function ($data) {
                $status = '';
                $label = '';
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $pending = "រង់ចាំ";
                    $approve = "ទទួលយកសំណើរ";
                    $reject = "បដិសេធសំណើរ";
                } else {
                    $pending = "Pending";
                    $reject = "Rejected";
                    $approve = "Approved";
                }
                if ($data->status == 0) {
                    $status = $pending;
                    $label = 'warning';
                }
                if ($data->status == 1) {
                    $status = $approve;
                    $label = 'success';
                }
                if ($data->status == 2) {
                    $status = $reject;
                    $label = 'danger';
                }
                return ' <a class="viewPopLink label label-' . $label . '" role="button" data-id="' . $data->id . '" data-status="' . $data->status . '"  data-toggle="modal tooltip" data-target="#myModal" data-placement="top" title="' . $status . '">' . $status . '</a>';

            })
            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }

    public function get_leave_staff()
    {
        $data = HrLeaveRequestModel::where('emp_id', Auth::user()->id)->get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                    $view = "បង្ហាញ";
                } else {
                    $edit = "Edit";
                    $view = "View";
                }
                return '<a href="' . route('hr-leave-request.edit', encrypt($data->id)) . '" class="button_warning">' . $edit . '</a>';
            })
            ->editColumn('emp_id', function ($data) {
                return optional($data->employee)->name;
            })
            ->editColumn('leave_type', function ($data) {
                return optional($data->leaveType)->name;
            })
            ->editColumn('to_date', function ($data) {
                return date('d-m-Y', strtotime($data->to_date));
            })
            ->editColumn('from_date', function ($data) {
                return date('d-m-Y', strtotime($data->from_date));
            })
            ->editColumn('status', function ($data) {
                $status = '';
                $label = '';
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $pending = "រង់ចាំ";
                    $approve = "ទទួលយកសំណើរ";
                    $reject = "បដិសេធសំណើរ";
                } else {
                    $pending = "Pending";
                    $reject = "Rejected";
                    $approve = "Approved";
                }
                if ($data->status == 0) {
                    $status = $pending;
                    $label = 'warning';
                }
                if ($data->status == 1) {
                    $status = $approve;
                    $label = 'success';
                }
                if ($data->status == 2) {
                    $status = $reject;
                    $label = 'danger';
                }
                return '<span class="label label-' . $label . '">' . $status . '</span>';
            })
            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }

    public function create()
    {
        $emp = User::where('status', 1)->pluck('name', 'id');
        $ltype = HrLeaveTypeModel::pluck('name', 'id');
        $wd = HrWorkdayModel::get();
        return view('hr.leave.create', compact('emp', 'ltype', 'wd'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
            'emp_id' => 'required',
            'leave_type' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'reason' => 'required',
        ]);
        $leave = new HrLeaveRequestModel();
        $leave->emp_id = $request->emp_id;
        $leave->leave_type = $request->leave_type;
        $leave->from_date = date('Y-m-d', strtotime($request->from_date));
        $leave->to_date = date('Y-m-d', strtotime($request->to_date));
        $leave->reason = $request->reason;
        if($leave->save()){
            $detail  = $request->leavedate;
            $type  = $request->daytype;
            foreach ($detail as$key => $row){
                $de_leave = new HrLeaveDetailModel();
                $de_leave->date = date('Y-m-d',strtotime($row));
                $de_leave->type = $type[$key];
                $de_leave->status = 0;
                $de_leave->leave_id = $leave->id;
                $de_leave->save();
            }
        }
        return redirect()->route('hr-leave-request.index')->with('success', 'Leave request was inserted successful...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $leave = HrLeaveRequestModel::find(decrypt($id));
        $emp = User::where('status', 1)->pluck('name', 'id');
        $ltype = HrLeaveTypeModel::pluck('name', 'id');
        $detail = HrLeaveDetailModel::where('leave_id',$leave->id)->get();
        $wd = HrWorkdayModel::get();
        return view('hr.leave.edit', compact('leave', 'emp', 'ltype','detail','wd'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'emp_id' => 'required',
            'leave_type' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'reason' => 'required',
        ]);
        $leave = HrLeaveRequestModel::find($id);
        $leave->emp_id = $request->emp_id;
        $leave->leave_type = $request->leave_type;
        $leave->from_date = date('Y-m-d', strtotime($request->from_date));
        $leave->to_date = date('Y-m-d', strtotime($request->to_date));
        $leave->reason = $request->reason;
        if($leave->update()){
            $detail  = $request->leavedate;
            $type  = $request->daytype;
            HrLeaveDetailModel::where('leave_id', $leave->id)->delete();
            foreach ($detail as$key => $row){
                $de_leave = new HrLeaveDetailModel();
                $de_leave->date = date('Y-m-d',strtotime($row));
                $de_leave->type = $type[$key];
                $de_leave->status = 0;
                $de_leave->leave_id = $leave->id;
                $de_leave->save();
            }
        }
        return redirect()->route('hr-leave-staff')->with('success', 'Leave request was updated successful...');
    }

    public function destroy($id)
    {
    }

    public function staff_leave_status(Request $request)
    {
        $id = $_GET['id'];
        $leave = HrLeaveRequestModel::find($id);
        $leave->status = $request->status;
        $leave->update();

        return redirect()->route('hr-leave-request.index')->with('success', 'Leave status was changed...');
    }

    public function view_modal()
    {
        $leave = HrLeaveRequestModel::find($_GET['id']);
        $employee = User::find($leave->emp_id);
        $leave_type = HrLeaveTypeModel::find($leave->leave_type);
        $status = '';
        $check_language = Fun::lang();

        if ($check_language == 'km') {
            $approve = "ទទួលយកសំណើរ";
            $reject = "បដិសេធសំណើរ";
            $pending = "រង់ចាំ";
            $mon = 'ថ្ងៃចន្ទ';
            $tue = 'ថ្ងៃអង្គារ';
            $wed = 'ថ្ងៃពុធ';
            $thu = 'ថ្ងៃព្រហស្បតិ៍';
            $fri = 'ថ្ងៃសុក្រ';
            $sat = 'ថ្ងៃសៅរ៍';
            $sun = 'ថ្ងៃអាទិត្យ';
        } else {
            $approve = "Approved";
            $reject = "Rejected";
            $pending = "Pending";
            $mon = 'Monday';
            $tue = 'Tuesday';
            $wed = 'Wednesday';
            $thu = 'Thursday';
            $fri = 'Friday';
            $sat = 'Saturday';
            $sun = 'Sunday';
        }
        $arr_day = [
            "Mon"=>$mon,
            "Tue"=>$tue,
            "Wed"=>$wed,
            "Thu"=>$thu,
            "Fri"=>$fri,
            "Sat"=>$sat,
            "Sun"=>$sun,
        ];
        if ($leave->status == 1) {
            $status = '<span class="label label-success">' . $approve . '</span>';
        }
        if ($leave->status == 0) {
            $status = '<span class="label label-warning">' . $pending . '</span>';
        }
        if ($leave->status == 2) {
            $status = '<span class="label label-danger">' . $reject . '</span>';
        }
        $detail = HrLeaveDetailModel::where('leave_id',$leave->id)->get();
        $detail_arr = [];
        foreach($detail as $key=>$row){
            $detail_arr[$key]['date'] = date('d-m-Y',strtotime($row->date));
            $detail_arr[$key]['type'] = $row->type;
            $detail_arr[$key]['code'] = $arr_day[date('D',strtotime($row->date))];
        }

        $data = [
            'employee' => $employee->name,
            'leave_type' => $leave_type->name,
            'from_date' =>  date('d-m-Y',strtotime($leave->from_date)),
            'to_date' =>  date('d-m-Y',strtotime($leave->to_date)),
            'reason' => $leave->reason,
            'status' => $status,
            'detail' => $detail_arr,
        ];
        return response()->json(['datas' => $data]);
    }
}
