<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrEmployeePromoteModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrEmployeePromoteController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:Employee Promote List', ['only' => ['index', 'get_emp_promote']]);
        $this->middleware('permission:Employee Promote Show', ['only' => ['show_promote']]);
        $this->middleware('permission:Employee Promote Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Employee Promote Delete', ['only' => ['delete_promote']]);
    }
    public function index()
    {
        return view('hr.employee-promote.index');
    }

    //get promote
    public function get_emp_promote()
    {
        $data = HrEmployeePromoteModel::take(20);

        return DataTables::of($data)
                        ->addIndexColumn()
                        ->editColumn('branch_id', function($data){
                            return optional($data->get_branch)->english_name;
                        })
                        ->editColumn('department_id', function($data){
                            return optional($data->get_department)->english_name;
                        })
                        ->editColumn('position_id', function($data){
                            return optional($data->get_position)->english_name;
                        })
                        ->editColumn('increment_date', function($data){
                            return $data->increment_date ? date('d-m-Y', strtotime($data->increment_date)) : "";
                        })
                        ->editColumn('basic_salary', function($data){
                            return $data->basic_salary ? "$ ".$data->basic_salary : "";
                        })
                        ->editColumn('increment_salary', function($data){
                            return $data->increment_salary ? "$ ".$data->increment_salary : "";
                        })
                        ->editColumn('action', function($data){
                            $btn_view   ="";
                            $btn_delete ="";
                            if(Gate::check('Employee Promote Show')){
                                $btn_view .= '<a class="btn btn-sm btn-info btn-view" data-id="'.$data->id.'"><span class="fa fa-eye"></span> Show</a>&nbsp;';
                            }
                            if(Gate::check('Employee Promote Delete')) {
                                $btn_delete .= '<a class="btn btn-sm btn-danger btn-delete-promote" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_view.$btn_delete;
                        })
                        ->rawColumns(['action' => 'action'])
                        ->make(true);
    }

    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        //
    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $id = decrypt($id);
        $promote = User::find($id);
        return view('hr.employee-promote.edit', compact('id', 'promote'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\HrEmployeePromoteModel  $hrEmployeePromoteModel
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'type'              => 'required',
            'increment_date'    => 'required',
            'reason'            => 'required'
        ]);

        if($request->type == 1)
        {
            $emp = User::where('id', $id)->first();

            $employee_promote                            = new HrEmployeePromoteModel();

            $employee_promote->parent_id                 = $emp->parent_id;
            $employee_promote->leader_id                 = $emp->leader_id;
            $employee_promote->group_id                  = $emp->group_id;
            $employee_promote->branch_id                 = $emp->branch_id;
            $employee_promote->department_id             = $emp->department_id;
            $employee_promote->position_id               = $emp->position_id;
            $employee_promote->employment_id             = $emp->employment_id;
            $employee_promote->user_year                 = $emp->user_year;
            $employee_promote->code                      = $emp->user_code;
            $employee_promote->name                      = $emp->english_name;
            $employee_promote->name_kh                   = $emp->khmer_name;
            $employee_promote->phone                     = $emp->user_phone;
            $employee_promote->email                     = $emp->email;
            $employee_promote->nationality               = $emp->nationality;
            $employee_promote->date_of_birth             = $emp->user_dob;
            $employee_promote->address                   = $emp->address;
            $employee_promote->place_of_birth            = $emp->place_of_birth;
            $employee_promote->gender                    = $emp->user_gender;
            $employee_promote->marital_status            = $emp->marital_status;
            $employee_promote->id_card                   = $emp->user_cardid;
            $employee_promote->avartar                   = $emp->avatar;
            $employee_promote->joined_date               = $emp->joined_date;
            $employee_promote->department                = $emp->department;
            $employee_promote->is_role                   = $emp->role;
            $employee_promote->role                      = $emp->role;
            $employee_promote->supervisor                = $emp->supervisor;
            $employee_promote->certificate               = $emp->certificate;
            $employee_promote->skill                     = $emp->skill;
            $employee_promote->dependent                 = $emp->dependent;
            $employee_promote->note                      = $emp->note;
            $employee_promote->status                    = $emp->status;
            $employee_promote->user_type                 = $emp->user_type;
            $employee_promote->basic_salary              = $emp->basic_salary;
            $employee_promote->increment_salary          = $request->amount;
            $employee_promote->language                  = $emp->language;
            $employee_promote->educate                   = $emp->educate;
            $employee_promote->emergency_contact         = $emp->emergency_contact;
            $employee_promote->family                    = $emp->family;
            $employee_promote->family_full               = $emp->family_full;
            $employee_promote->work_experience           = $emp->work_experience;
            $employee_promote->spouse                    = $emp->spouse;
            $employee_promote->child                     = $emp->child;
            $employee_promote->increment                 = $emp->increment;
            $employee_promote->meal_transport_allowance  = $emp->meal_transport_allowance;
            $employee_promote->position_allowance        = $emp->position_allowance;
            $employee_promote->other_allowance           = $emp->other_allowance;
            $employee_promote->status                    = $emp->status;

            $employee_promote->increment_date            = date('Y-m-d',strtotime($request->increment_date));
            $employee_promote->reason                    = $request->reason;
            $employee_promote->type                      = $request->type;

            $employee_promote->save();
        }
        if($request->type == 1)
        {
            $employee = User::where('id', $id)->first();
            $employee->basic_salary        += $request->amount;
            $employee->update();
        }

        return redirect()->route('hr-emp-promote.index')->with('success','Updated Successful!');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\HrEmployeePromoteModel  $hrEmployeePromoteModel
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    //show promote
    public function show_promote(Request $request)
    {
        $id     = $request->id;
        $data   = HrEmployeePromoteModel::find($id);
        $data->load(['get_branch', 'get_department', 'get_position']);
        return response()->json($data);
    }

    //delete promote
    public function delete_promote(Request $request)
    {
        $id = $request->delete_id;
        HrEmployeePromoteModel::where('id', $id)->delete();
        return redirect()->route('hr-emp-promote.index')->with('success', 'Deleted Successful!..');

    }
}
