<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Fun\Fun;
use App\Helpers\Globals;
use App\Models\Hr\HrEmpFileModel;
use App\Models\Hr\HrEmploymentStatusModel;
use App\Models\Hr\HrPositionModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\TimePolicyModel;
use Illuminate\Support\Facades\Auth;
use Image;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrEmployeeController extends Controller
{
    function __construct()
    {

        $this->middleware('permission:Employee List', ['only' => ['index','get_employee']]);
        $this->middleware('permission:Employee Create', ['only' => ['create','store']]);
        $this->middleware('permission:Employee Show', ['only' => ['show']]);
        $this->middleware('permission:Employee Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Employee active', ['only' => ['change_status']]);
        $this->middleware('permission:Employee View Contract', ['only' => ['get_emp_contract']]);

    }
    public function index()
    {
        return view('hr.employee.index');
    }
    public function get_employee()
    {
        $user = User::where('status',1)->take(20);
        return DataTables::of($user)
            ->addIndexColumn()
            ->editColumn('avatar', function($data){
                return $data->avatar ? asset('images/upload/'.$data->avatar) : asset('images/upload/profile.png');
            })
            ->editColumn('user_dob', function ($data) {
                return $data->user_dob ? date('d-m-Y', strtotime($data->user_dob)) : '';
            })
            ->editColumn('branch_id', function ($data) {
                return optional($data->branch)->english_name;
            })
            ->editColumn('department_id', function ($data) {
                return optional($data->_department)->english_name;
            })
            ->editColumn('position_id', function ($data) {
                return optional($data->position)->english_name;
            })
            ->editColumn('employment_id', function ($data) {
                return optional($data->employment)->name;
            })
            ->editColumn('gender', function ($data) {
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $male = "ប្រុស";
                    $female = "ស្រី";
                } else {
                    $male = "Male";
                    $female = "Female";
                }
                return $data->gender == 'male' ? $male : $female;
            })
            ->addColumn('khmer_name', function($data){
                return '';
            })
            ->addColumn('english_name', function($data){
                return $data->english_name;
            })
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $edit   = "កែសម្រួល";
                    $action = "សកម្មភាព";
                    $ag     = "មានក្រុមហើយ";
                    $ng     = "កំណត់ក្រុមអ្នកប្រើប្រាស់";
                    $view   = "បង្ហាញ";
                    $set    = "កណត់គណនេយ្យ";
                } else {
                    $ag     = "Already in Group";
                    $ng     = "Set user group";
                    $edit   = "Edit";
                    $action = 'Action';
                    $view   = 'View';
                    $set    = 'Account Setting';
                }
                $btn_more = '<div class="btn-group" style="margin-right: 5px;">
                          <button type="button" class="btn btn-sm btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            More
                          </button>
                          <div class="dropdown-menu">';
                if (Gate::check('Upgrade Resign')) {
                    $btn_more .= '<li><a href="' . url('hr-resign/' . encrypt($data->id) . '/edit') . '" class="dropdown-item">Resign</a></li> ';
                }
                if (Gate::check('Upgrade Rotation')) {
                    $btn_more .= '<li><a href="' . route('hr-emp-rotate.edit', encrypt($data->id)) . '" class="dropdown-item">Upgrade Rotation</a></li>';
                }
                if (Gate::check('Upgrade Promote')) {
                    $btn_more .= '<li><a href="' . route('hr-emp-promote.edit', encrypt($data->id)) . '" class="dropdown-item">Upgrade Promote</a></li> ';
                }
                if (Gate::check('Employee View Contract')) {
                    $btn_more .= '<li><a href="' . route('hr.get-emp-contract', encrypt($data->id)) . '" data-id="' . $data->id . '" target="_blank" class="dropdown-item">View Contract</a></li> ';
                }
                $btn_more .="</div></div>";
                $btn_action='<div class="btn-group" style="margin-right: 5px;">
                          <button type="button" class="btn btn-sm btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            '.$action.'
                          </button>
                          <div class="dropdown-menu">';
                if(Gate::check('Employee Show')){
                    $btn_action  .= '<li><a href="' . route('hr-employee.show', encrypt($data->id)) . '" class="dropdown-item">' . $view . '</a></li>';
                }
                if(Gate::check('Employee Edit')){
                    $btn_action  .= '<li><a href="' . route('hr-employee.edit', encrypt($data->id)) . '" class="dropdown-item">' . $edit . '</a></li>';
                }
                // if(Gate::check('Employee Account Setting')){
                    // $btn_action  .= '<li><a href="' . route('users.edit', encrypt($data->id)) . '" class="dropdown-item">' . $set . '</a></li>';
                // }
                $btn_action .='</div></div>';

                return  $btn_more.$btn_action;
            })
            ->addColumn('status', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $activated = "តំណើរការ";
                    $deactivated = "ផ្អាកតំណើរការ";
                } else {
                    $activated = "Activated";
                    $deactivated = "Deactivated";
                }
                if (Auth::user()->id !== $data->id) {
                    if ($data->status == 0) {
                        return ' <a class="viewPopLink text-danger" role="button" data-id="' . $data->id . '" data-status="' . $data->status . '" data-toggle="modal tooltip" data-target="#myModal" data-placement="top" title="Disactive"><span class="fa fa-times"></span> ' . $deactivated . '</a>';
                    }
                    if ($data->status == 1) {
                        return ' <a class="viewPopLink text-success" role="button" data-id="' . $data->id . '" data-status="' . $data->status . '"  data-toggle="modal tooltip" data-target="#myModal" data-placement="top" title="Active"><span class="fa fa-check"></span> ' . $activated . '</a>';
                    }
                } else {
                    return ' <span class="fa fa-check"></span>' . $activated;
                }
            })
            ->rawColumns(['action' => 'action', 'status' => 'status'])
            ->make(true);
    }

    public function create()
    {
        $emp_status = HrEmploymentStatusModel::pluck('name', 'id');
        $position   = HrPositionModel::pluck('english_name', 'id');
        $department = HrDepartmentModel::pluck('english_name','id');
        $branch     = HrBranch::pluck('name', 'id');
        $time_policy= TimePolicyModel::pluck('name', 'id');
        $increase   = Globals::increase_employee();
        return view('hr.employee.create', compact('emp_status', 'position','department', 'branch', 'time_policy', 'increase'));
    }
    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            // 'user_code'         => 'required|unique:users,user_code',
            'english_name'      => 'required',
            'khmer_name'        => 'required',
            'nationality'       => 'required',
            'user_dob'          => 'required',
            'basic_salary'      => 'required',
            'joined_date'       => 'required',
            'email'             => 'required|unique:users,email',
            'branch_id'         => 'required',
            'department_id'     => 'required',
            'position_id'       => 'required'
            // 'avatar'            => 'image|mimes:jpeg,png,jpg',
        ]);

        $oldImage = $request->hidden_image_name;
        if ($request->file('avatar') == null) {
            $file_name = $oldImage;
        } else {
            $newfile = $request->file('avatar');
            $file_name = $newfile->getClientOriginalName();
            if (file_exists(public_path() . 'images/upload/' . $oldImage)) {
                if ($oldImage != '') {
                    //unlink(public_path() . 'images/upload/' . $oldImage);
                }
            }
            $file_name = date('his') . $file_name;
            $destinationPath = 'images/upload';
            //$get_img = Image::make($newfile->getRealPath())->resize(256, 256);
            $newfile->move($destinationPath, $file_name);
        }

        $file_title                     = $request->file_title;
        $file_note                      = $request->file_note;
        $att_file                       = $request->file('att_file');
        $emp                            = new User();


        $emp->user_year                 = date('Y');
        $emp->english_name              = $request->english_name;
        $emp->khmer_name                = $request->khmer_name;
        $emp->basic_salary              = $request->basic_salary;
        $emp->user_code                 = $request->user_code;
        $emp->avatar                    = $file_name;
        $emp->user_cardid               = $request->id_card;
        $emp->nationality               = $request->nationality;
        $emp->user_dob                  = date('Y-m-d', strtotime($request->user_dob));
        $emp->user_gender               = $request->gender;
        $emp->marital_status            = $request->marital_status;
        $emp->employment_id             = $request->employment_id;
        $emp->branch_id                 = $request->branch_id;
        $emp->department_id             = $request->department_id;
        $emp->position_id               = $request->position_id;
        $emp->user_phone                = $request->contact;
        $emp->email                     = $request->email;
        $emp->address                   = $request->address;
        $emp->place_of_birth            = $request->place_of_birth;
        $emp->joined_date               = date('Y-m-d', strtotime($request->joined_date));
        $emp->note                      = $request->note;
        $emp->role                      = 'Administrator';
        $emp->spouse                    = $request->spouse;
        $emp->child                     = $request->child;
        $emp->increment                 = $request->increment;
        $emp->meal_transport_allowance  = $request->meal_transport;
        $emp->position_allowance        = $request->position_allowance;
        $emp->other_allowance           = $request->other_allowance;
        $emp->fingerprint_no            = $request->fingerprint_no;
        $emp->time_policy_id            = $request->time_policy_id;
        //dd($request->all());
        $emp->save();

        if ($att_file) {
            foreach ($att_file as $key => $row) {
                if ($row->isValid()) {
                    $file_name = $row->getClientOriginalName();
                    $file_name = date('his') . $file_name;
                    $destinationPath = 'assets/attachment_file';
                    if ($row->move($destinationPath, $file_name)) {
                        $file = new HrEmpFileModel();
                        $file->emp_id = $emp->id;
                        $file->name = $file_title[$key];
                        $file->note = $file_note[$key];
                        $file->file = $file_name;
                        $file->save();
                    }
                }
            }
        }
        return redirect()->route('hr-employee.index')->with('success', 'New employee was inserted successful...');

    }

    public function show($id)
    {
        $emp = User::find(decrypt($id));
        $file = HrEmpFileModel::where('emp_id',$emp->id)->get();
        return view('hr.employee.show', compact('emp','file'));

    }

    public function edit($id)
    {
        $emp            = User::find(decrypt($id));
        $emp_status     = HrEmploymentStatusModel::pluck('name', 'id');
        $position       = HrPositionModel::pluck('english_name', 'id');
        $file           = HrEmpFileModel::where('emp_id', $emp->id)->get();
        $department     = HrDepartmentModel::pluck('english_name','id');
        $branch         = HrBranch::pluck('name', 'id');
        $time_policy = TimePolicyModel::pluck('name', 'id');

        return view('hr.employee.edit', compact('emp_status', 'position', 'emp', 'file','department', 'branch', 'time_policy'));
    }

    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'english_name'      => 'required',
            'khmer_name'        => 'required',
            'nationality'       => 'required',
            'user_dob'          => 'required',
            'basic_salary'      => 'required',
            'joined_date'       => 'required',
            'email'             => 'required|unique:users,email,'.$id,
            'branch_id'         => 'required',
            'department_id'     => 'required',
            'position_id'       => 'required'
            // 'avatar'            => 'image|mimes:jpeg,png,jpg',
        ]);

        $oldImage = $request->hidden_image_name;
        if ($request->file('avatar') == null) {
            $file_name = $oldImage;
        } else {
            $newfile = $request->file('avatar');
            $file_name = $newfile->getClientOriginalName();
            if (file_exists(public_path() . 'images/upload/' . $oldImage)) {
                if ($oldImage != '') {
                    unlink(public_path() . 'images/upload/' . $oldImage);
                }
            }
            $file_name = date('his') . $file_name;
            $destinationPath = 'images/upload';
            //$get_img = Image::make($newfile->getRealPath())->resize(256, 256);
            //$get_img->save($destinationPath . '/' . $file_name);
            $newfile->move($destinationPath, $file_name);
        }

        $file_title                      = $request->file_title;
        $file_note                       = $request->file_note;
        $old_id                          = $request->old_id;
        $oldfile                         = $request->old_file;
        $att_file                        = $request->file('att_file');
        $emp                             = User::find($id);

        $emp->user_year                  = date('Y');
        $emp->english_name               = $request->english_name;
        $emp->khmer_name                 = $request->khmer_name;
        $emp->basic_salary               = $request->basic_salary;
        $emp->user_code                  = $request->user_code;
        $emp->avatar                     = $file_name;
        $emp->user_cardid                = $request->id_card;
        $emp->nationality                = $request->nationality;
        $emp->user_dob                   = date('Y-m-d', strtotime($request->user_dob));
        $emp->user_gender                = $request->gender;
        $emp->marital_status             = $request->marital_status;
        $emp->employment_id              = $request->employment_id;
        $emp->branch_id                  = $request->branch_id;
        $emp->department_id              = $request->department_id;
        $emp->position_id                = $request->position_id;
        $emp->user_phone                 = $request->phone;
        $emp->email                      = $request->email;
        $emp->joined_date                = date('Y-m-d', strtotime($request->joined_date));
        $emp->note                       = $request->note;
        $emp->place_of_birth             = $request->place_of_birth;
        $emp->address                    = $request->address;
        $emp->spouse                     = $request->spouse;
        $emp->child                      = $request->child;
        $emp->increment                  = $request->increment;
        $emp->meal_transport_allowance   = $request->meal_transport_allowance;
        $emp->position_allowance         = $request->position_allowance;
        $emp->other_allowance            = $request->other_allowance;
        $emp->fingerprint_no             = $request->fingerprint_no;
        $emp->time_policy_id             = $request->time_policy_id;
        // dd($request->all());
        $emp->update();

        if ($att_file) {
            foreach ($att_file as $key => $row) {
                if ($row->isValid()) {
                    $file_name = $row->getClientOriginalName();
                    if ($file_name != null) {
                        $file_name = strtotime((date('is'))) . '-' . $key . '.' . $row->extension();
                        $destinationPath = 'assets/attachment_file/';

                        if (file_exists(public_path() . '/assets/attachment_file/' . $oldfile[$key])) {
                            if ($oldfile[$key] != '') {
                                unlink(public_path() . '/assets/attachment_file/' . $oldfile[$key]);
                            }
                        }
                        if ($row->move($destinationPath, $file_name)) {
                            $file = HrEmpFileModel::find($old_id[$key]);
                            if ($file) {
                                $file->name = $file_title[$key];
                                $file->note = $file_note[$key];
                                $file->file = $file_name;
                                $file->update();
                            } else {
                                $file1 = new HrEmpFileModel();
                                $file1->emp_id = $emp->id;
                                $file1->name = $file_title[$key];
                                $file1->note = $file_note[$key];
                                $file1->file = $file_name;
                                $file1->save();
                            }
                        }
                    }
                }
            }
        }
        return redirect()->route('hr-employee.index')->with('success', 'employee was updated successful...');

    }

    public function destroy($id)
    {
        //
    }
    public function change_status(Request $request)
    {
        $st = User::find($request->id);
        $st->status = $request->status;
        $st->update();
        return redirect()->route('hr-employee.index')->with('success', 'Employee status was changed successful...');
    }

    //get contract
    public function get_emp_contract($id)
    {
        $id = decrypt($id);
        $emp = User::find($id);
        return view('hr.employee.contract', compact('emp'));
    }
}
