<?php

namespace App\Http\Controllers\HR;

use App\Models\Hr\HrBranch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Hr\HrDepartmentModel;
use Illuminate\Support\Facades\Gate;

class HrBranchController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Branch List', ['only' => ['index']]);
        $this->middleware('permission:Branch Create', ['only' => ['create','store']]);
        $this->middleware('permission:Branch Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Branch set_main', ['only' => ['branch_changeStatus']]);
    }
    public function index()
    {
        $branch = HrBranch::all();
        return view('hr.branch.index', compact('branch'));
    }

    public function create()
    {
        return view('hr.branch.create');
    }
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'     => 'required',
            'phone'    => 'required',
            'address'  => 'required',
        ]);

        $branch                         = new HrBranch();
        $branch->name                   = $request->name;
        $branch->english_name           = $request->name;
        $branch->khmer_name             = $request->name_kh;
        $branch->phone                  = $request->phone;
        $branch->address                = $request->address;
        $branch->email                  = $request->email;
        $branch->note                   = $request->note;
        $branch->save();

        return response()->json('success');
    }

    public function edit($id)
    {
        $branch = HrBranch::find($id);
        return response()->json($branch);
    }

    public function update(Request $request)
    {

        $this->validate($request,[
            'name'          => 'required',
            'phone'         => 'required',
            'address'       => 'required',
            'id'            => 'required',
        ]);

        $branch                         = HrBranch::find($request->id);
        $branch->name                   = $request->name;
        $branch->english_name           = $request->name;
        $branch->khmer_name             = $request->name_kh;
        $branch->phone                  = $request->phone;
        $branch->address                = $request->address;
        $branch->email                  = $request->email;
        $branch->note                   = $request->note;
        $branch->update();

        return response()->json('success');
    }

    public function branch_changeStatus(Request $request)

    {

        HrBranch::where('main',1)->update(['main'=>0]);

        HrBranch::find($request->id)->update(['main'=>1]);;

        return response()->json(['success'=>'Status change successfully.']);

    }
}
