<?php

namespace App\Http\Controllers\HR;

use App\Fun\Fun;
use App\Models\Hr\HrAttendanceModel;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class HrAttendanceController extends Controller
{
    public function index()
    {
        return view('hr.attendance.index');
    }

    public function get_attendance()
    {
        $data = HrAttendanceModel::get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->editColumn('leave_per_year', function ($data){
                $check_language = Fun::lang();
                if ($check_language == 'km') {
                    $day = "ថ្ងៃ";
                } else {
                    $day = "Day";
                }
                return $data->leave_per_year.$day;
            })
            ->editColumn('emp_id', function ($data) {
                return optional($data->employee)->english_name;
            })
            ->editColumn('time_in', function ($data) {
                return substr_replace($data->time_in,' ',5,1);
            })
            ->editColumn('time_out', function ($data) {
                return substr_replace($data->time_out,' ',5,1);
            })
            ->addColumn('action', function ($data) {
                $check_language = Fun::lang();

                if ($check_language == 'km') {
                    $edit = "កែសម្រួល";
                } else {
                    $edit = "Edit";
                }
                $del = '';
                return '<a href="'.route('hr-attendance.edit',encrypt($data->id)).'" class="button_warning">'.$edit.'</a>';
            })

            ->rawColumns(['action' => 'action', 'complete_status' => 'complete_status'])
            ->make(true);
    }
    public function create()
    {
        $employee = User::select('english_name AS name', 'id')
            ->where('status',1)->pluck('name','id');
        return view('hr.attendance.create',compact('employee'));
    }
    public function store(Request $request)
    {
        $this->validate($request,[
            'emp_id'    => 'required',
            'f_hh'      => 'required',
            'f_mm'      => 'required',
            'f_shift'   => 'required',
            't_hh'      => 'required',
            't_mm'      => 'required',
            't_shift'   => 'required',
            'date'      => 'required',
        ]);

        $att    	    = new HrAttendanceModel();
        $att->emp_id    = $request->emp_id;
        $att->date      = date('Y-m-d',strtotime($request->date));
        $att->note      = $request->note;
        $start          = $request->f_hh.':'.$request->f_mm.':'.$request->f_shift;
        $end            = $request->t_hh.':'.$request->t_mm.':'.$request->t_shift;
        $att->time_in   = $start;
        $att->time_out  = $end;
        $att->save();
        return redirect()->route('hr-attendance.index')->with('success','Attendance was save successful...');
    }
    public function show($id)
    {
        //
    }
    public function edit($id)
    {
        $att = HrAttendanceModel::find(decrypt($id));
        $employee = User::select('english_name AS name', 'id')
            ->where('status',1)->pluck('name','id');
        $start[]    = explode(':',$att->time_in);
        $end[]      = explode(':',$att->time_out);
        return view('hr.attendance.edit',compact('att','employee','start','end'));
    }
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'emp_id'    => 'required',
            'f_hh'      => 'required',
            'f_mm'      => 'required',
            'f_shift'   => 'required',
            't_hh'      => 'required',
            't_mm'      => 'required',
            't_shift'   => 'required',
            'date'      => 'required',
        ]);

        $att            = HrAttendanceModel::find($id);
        $att->emp_id    = $request->emp_id;
        $att->date      = date('Y-m-d',strtotime($request->date));
        $att->note      = $request->note;
        $start          = $request->f_hh.':'.$request->f_mm.':'.$request->f_shift;
        $end            = $request->t_hh.':'.$request->t_mm.':'.$request->t_shift;
        $att->time_in   = $start;
        $att->time_out  = $end;
        $att->update();
        return redirect()->route('hr-attendance.index')->with('success','Attendance was updated successful...');
    }
    public function destroy($id)
    {
        //
    }
}
