<?php

namespace App\Http\Controllers\HR;

use App\Helpers\GenAtt;
use App\Helpers\IDate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\Employee;
use App\Models\Hr\HrBranch;
use App\Models\Hr\HrDepartmentModel;
use App\Models\Hr\HrPositionModel;
use App\Models\Hr\TimeAttendanceGenModel;
use App\User;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class GenerateAttendanceController extends Controller
{


    function __construct()
    {
        $this->middleware('permission:Generate Attendance List', ['only' => ['index']]);
        $this->middleware('permission:Generate Attendance Create', ['only' => ['create','store']]);
        $this->middleware('permission:Generate Attendance Delete', ['only' => ['delete_generate_attendance']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $count_total    = TimeAttendanceGenModel::count();
            $count_filter   = TimeAttendanceGenModel::count();
            $data           = TimeAttendanceGenModel::take(20);
            return DataTables::of($data)
                        ->addIndexColumn()
                        ->with([
                            "recordsTotal" => $count_total,
                            "recordsFiltered" => $count_filter,
                        ])
                        ->addColumn('employee', function($value){
                            return optional($value->employee)->english_name;
                        })
                        ->addColumn('action', function($data){
                            $btn_edit = '';
                            $btn_delete = '';
                            // $btn_edit = '<a href="'.route('hr-generate-attendance.show',encrypt($data->id)).'" class="button_success"><span class="fa fa-eye"></span></a>';
                            if(Gate::check('Generate Attendance Delete')) {
                                $btn_delete = '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                            }
                            return $btn_edit.$btn_delete;
                        })
                        ->rawColumns(['action', 'employee'])
                        ->make(true);
        }
        return view('hr.generate-attendance.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $emp        = User::where('status',1)->pluck('english_name','id');
        $branch     = HrBranch::pluck('english_name', 'id');
        $department = HrDepartmentModel::pluck('english_name', 'id');
        $position   = HrPositionModel::pluck('english_name', 'id');

        return view('hr.generate-attendance.create', compact('emp','branch','department','position'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $from_date  = $request->from_date;
        $to_date    = $request->to_date;
        $month_year = $request->month_year;

        $em = Employee::getEmp($request);
        if ($em['rows'] != null) {
            if (count($em['rows']) > 0) {
                foreach ($em['rows'] as $row) {
                    if ($row->time_policy_id > 0) {
                        GenAtt::getGenerateAttend($row->id, $from_date, $to_date, $row->time_policy_id, $row->fingerprint_no, $month_year);
                    }
                }
            }
        }

        return redirect()->route('hr-generate-attendance.index')->with('success', 'Data was save successful!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //generate attendance
    public function get_generate_attendance(Request $request)
    {


    }

    //delete generate attendance
    public function delete_generate_attendance(Request $request)
    {
        $id = $request->delete_id;
        TimeAttendanceGenModel::where('id', $id)->delete();
        return redirect()->route('hr-generate-attendance.index')->with('success', 'Data was deleted successful!');

    }
}
