<?php

namespace App\Http\Controllers\HR;


use App\Models\Hr\HrExchangeRateModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class ExchangeRateController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Exchange Rate List', ['only' => ['index','get_exchange_rate']]);
        $this->middleware('permission:Exchange Rate Create', ['only' => ['create','store']]);
        $this->middleware('permission:Exchange Rate Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Exchange Rate Delete', ['only' => ['delete_exchange_rate']]);
    }

    public function index()
    {
        return view('hr.exchange-rate.index');
    }

    public function get_exchange_rate()
    {
        $rate = HrExchangeRateModel::where('status',1)->take(20);
        return DataTables::of($rate)
                            ->addIndexColumn()
                            ->editColumn('date', function($data){
                                return $data->date ? date('d-m-Y', strtotime($data->date)) : "";
                            })
                            ->addColumn('action', function($data){
                                $btn_edit="";
                                $btn_delete="";
                                if(Gate::check('Exchange Rate Edit')){
                                    $btn_edit .= '<a href="'. route('hr-exchange-rate.edit', $data->id) .'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                                }
                                if(Gate::check('Exchange Rate Delete')) {
                                    $btn_delete .= '<a class="btn btn-sm btn-danger btn_delete_exchange_rate" data-id="' . $data->id . '"><span class="fa fa-trash"></span> Delete</a>';
                                }

                                return $btn_edit.$btn_delete;
                            })
                            ->rawColumns(['action' => 'action'])
                            ->make(true);
    }

    public function create()
    {
        return view('hr.exchange-rate.create');
    }

    public function store(Request $request)
    {

        $this->validate($request,[
            'general_rate'      => 'required',
            'khmer_rate'    => 'required',
            'thai_rate'     => 'required',
        ]);

        $rate                   = new HrExchangeRateModel();
        $rate->general_rate     = $request->gen_rate;
        $rate->khmer_rate       = $request->khmer_rate;
        $rate->thai_rate        = $request->thai_rate;
        $rate->other_rate       = $request->other_rate;
        $rate->date             = $request->date ? date('Y-m-d',strtotime($request->date)): now();
        $rate->save();
        return redirect()->route('hr-exchange-rate.index')->with('success','Rate was saved successful ...');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $rate = HrExchangeRateModel::find($id);
        return view('hr.exchange-rate.edit',compact('rate'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'general_rate'      => 'required',
            'khmer_rate'    => 'required',
            'thai_rate'     => 'required',
        ]);
        $rate                   = HrExchangeRateModel::find($id);
        $rate->general_rate     = $request->general_rate;
        $rate->khmer_rate       = $request->khmer_rate;
        $rate->thai_rate        = $request->thai_rate;
        $rate->other_rate       = $request->other_rate;
        $rate->date             = date('Y-m-d',strtotime($request->date));;
        $rate->update();
        return redirect()->route('hr-exchange-rate.index')->with('success','Rate was updated successful ...');
    }

    public function destroy($id)
    {
        //
    }

    public function delete_exchange_rate(Request $request)
    {
        $id = $request->delete_id;
        HrExchangeRateModel::where('id', $id)->delete();
        return redirect()->route('hr-exchange-rate.index')->with('success','Rate was Deleted successful ...');

    }

}
