<?php

namespace App\Http\Controllers\HR;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Hr\AbsentPolicyModel;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Gate;

class AbsentPolicyController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:Absent Policy List', ['only' => ['index']]);
        $this->middleware('permission:Absent Policy Create', ['only' => ['create','store']]);
        $this->middleware('permission:Absent Policy Edit', ['only' => ['edit','update']]);
        $this->middleware('permission:Absent Policy Delete', ['only' => ['delete_absent_policy']]);
    }
    public function index(Request $request)
    {
        if($request->ajax())
        {
            $data = AbsentPolicyModel::take(20);
            return DataTables::of($data)
                    ->addIndexColumn()
                    ->editColumn('date', function($data){
                        return $data->date ? date('d-m-Y', strtotime($data->date)) : '';
                    })
                    ->addColumn('action', function($data){
                        $btn_edit="";
                        $btn_delete ="";
                        if(Gate::check('Absent Policy Edit')){
                            $btn_edit = '<a href="'.route('hr-absent-policy.edit', encrypt($data->id)).'" class="btn btn-sm btn-warning"><span class="fa fa-edit"></span> Edit</a>&nbsp;';
                        }
                        if(Gate::check('Absent Policy Delete')) {
                            $btn_delete = '<a class="btn btn-sm btn-danger btn_delete" data-id="' . $data->id . '"><span class="fa fa-times"></span> Delete</a>';
                        }
                        return $btn_edit.$btn_delete;
                    })
                    ->rawColumns(['action', 'action'])
                    ->make(true);
        }
        return view('hr.absent-policy.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hr.absent-policy.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name'          => 'required',
            'deduct_money'  => 'required',
            'date'          => 'required'
        ]);

        $absent_policy                  = new AbsentPolicyModel();
        $absent_policy->name            = $request->name;
        $absent_policy->deduct_money    = $request->deduct_money;
        $absent_policy->date            = date('Y-m-d', strtotime($request->date));
        $absent_policy->note            = $request->note;
        $absent_policy->save();

        return redirect()->route('hr-absent-policy.index')->with('success', 'Data was inserted Successful!...');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $abent_policy = AbsentPolicyModel::findOrFail($id);
        return view('hr.absent-policy.edit', compact('abent_policy'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name'          => 'required',
            'deduct_money'  => 'required',
            'date'          => 'required'
        ]);

        $absent_policy                  = AbsentPolicyModel::findOrFail($id);
        $absent_policy->name            = $request->name;
        $absent_policy->deduct_money    = $request->deduct_money;
        $absent_policy->date            = date('Y-m-d', strtotime($request->date));
        $absent_policy->note            = $request->note;
        $absent_policy->update();

        return redirect()->route('hr-absent-policy.index')->with('success', 'Data was updated Successful!...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function delete_absent_policy(Request $request)
    {
        $id = $request->delete_id;
        AbsentPolicyModel::where('id', $id)->delete();
        return redirect()->route('hr-absent-policy.index')->with('success', 'Data was deleted Successful!...');
    }
}
