<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use DataTables;
use Auth;
use App\GroupItem;
use App\User;
use Gate;

class GroupItemController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Group-Item-List', ['only' => ['index','get_group_item']]);
         $this->middleware('permission:Group-Item-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Group-Item-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Group-Item-Delete', ['only' => ['delete']]);
    }
    public function index()
    {
        return view("group-item.index");
    }

    public function get_group_item(Request $request)
    {
        if($request->isMethod('get')){
            $search = $request->input('search.value');
            $count_total =GroupItem::join("users","users.id","nso007_group_item.user_id")
                            ->where("nso007_group_item.status",1)
                            ->count();
            $count_filter =GroupItem::join("users","users.id","nso007_group_item.user_id")
                            ->where(function($query) use ($search){
                                $query->orWhere('nso007_group_item.name' , 'LIKE' , '%'.$search.'%');
                                $query->orWhere('nso007_group_item.description' , 'LIKE' , '%'.$search.'%');
                            })
                            ->where("nso007_group_item.status",1)
                            ->count();

            $category = GroupItem::select("nso007_group_item.*")
                                ->orderBy('nso007_group_item.id','asc')
                                ->where("nso007_group_item.status",1)
                                ->take(20);
            return Datatables::of($category)
                ->addIndexColumn()
                ->setRowId('id')
                ->with([
                    "recordsTotal" => $count_total,
                     "recordsFiltered" => $count_filter,
                  ])
                ->addColumn('action',function($category){
                    $button="";
                    if(Gate::check('Group-Item-Edit'))
                        $button.= ' <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#" title="Edit" onclick="edit_category(this)"><i class="fas fa-edit"></i></button> ';
                    if(Gate::check('Group-Item-Delete')){
                        if($category->delete_status==0){
                            $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                        }elseif($category->delete_status==1){
                            $button .= ' <button type="button" data-toggle="modal" data-target="#modal-danger'.$category->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>
                             <div class="modal fade" id="modal-danger'.$category->id.'">
                                <form action="'.route("group_item.delete",$category->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Group")." ".__("application.Item").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                            ';
                        }else{

                        }
                    }
                    
                    return $button;
                })
                ->rawColumns([
                    'action' => 'action',
                ])
                ->make(true); 
        }
        else{

            $id=$request->id;
            $data=GroupItem::where("id",$id)->first();
            return json_encode($data);

        }
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required|unique:nso007_group_item,name'
            // 'code'=>'required|unique:nso007_category_stock,code'
        ]);
        $category=new GroupItem;
        $category->name=$request->name;
        $category->description=$request->description;
        $category->user_id=Auth::user()->id;
        $category->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("group_item.index")->with("success","Create successfully !");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required | unique:nso007_group_item,name,'.$id
        ]);
        $Category=GroupItem::find($id);
        $Category->name=$request->name;
        $Category->description=$request->des;
        $Category->save();
        return json_encode(['id'=>$id,'name'=>$request->name,'description'=>$request->des]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        GroupItem::where("id",$id)->delete();
        return \back()->with("success","successfully !");
    }
}
