<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\CommissionModel;
use DataTables;
use DB;
use Crypt;
use App\JournalModel;
use Auth;
use Gate;

class CommissionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Commission-List', ['only' => ['index','get_index']]);
         $this->middleware('permission:Commission-Pay', ['only' => ['save_withdraw_commission']]);
         $this->middleware('permission:Commission-Show-Withdraw-History', ['only' => ['get_commission_history']]);
         $this->middleware('permission:Commision-Print-Invoice', ['only' => ['print_invoice_commission']]);
    }
    public function index()
    {
        return view("commission.index");
    }
    public function get_index(Request $request)
    {
        $search = $request->input('search.value');
        $count_total = CommissionModel::join("nso007_client","nso007_client.id","nso007_commission.client_id")
                        ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                        // ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_commission.sale_id")
                        // ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                        // ->join("nso007_project_stock","nso007_item_stock.project_id","nso007_project_stock.id")
                        ->where("nso007_client.status",1)
                        ->where("nso007_commission.status",1)
                        ->where("nso007_agency.status",1)
                        // ->where("nso007_sale_detail_stock.status",1)
                        // ->where("nso007_item_stock.status",1)
                        // ->where("nso007_project_stock.status",1)
                        // ->groupBy("nso007_commission.sale_id")
                        ->count();
        $count_filter = CommissionModel::join("nso007_client","nso007_client.id","nso007_commission.client_id")
                        ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                        ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_commission.sale_id")
                        ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                        ->join("nso007_project_stock","nso007_item_stock.project_id","nso007_project_stock.id")
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_commission.date' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where("nso007_client.status",1)
                    ->where("nso007_commission.status",1)
                    ->where("nso007_agency.status",1)
                    ->where("nso007_sale_detail_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_project_stock.status",1)
                    ->groupBy("nso007_commission.sale_id")
                    ->get();

        $commissions = CommissionModel::join("nso007_client","nso007_client.id","nso007_commission.client_id")
                        ->join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                        ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_commission.sale_id")
                        ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                        ->join("nso007_project_stock","nso007_item_stock.project_id","nso007_project_stock.id")
                        ->select(
                            "nso007_commission.*",
                            "nso007_client.name as client_name",
                            "nso007_agency.name as agency_name",
                            "nso007_project_stock.name as project_name",
                            DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name")
                        )
                        ->where("nso007_client.status",1)
                        ->where("nso007_commission.status",1)
                        ->where("nso007_agency.status",1)
                        ->where("nso007_sale_detail_stock.status",1)
                        ->where("nso007_item_stock.status",1)
                        ->where("nso007_project_stock.status",1)
                        ->groupBy("nso007_commission.sale_id")
                        ->take(20);

        return Datatables::of($commissions)
            ->addIndexColumn()
            ->setRowId("id")
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => !empty($count_filter)?count($count_filter):0,
              ])   
            ->editColumn("amount_available",function($commissions){
                return "<span id='amount-available-".$commissions->id."'>".$commissions->amount_available."</span>";
            })
            ->editColumn("amount_withdraw",function($commissions){
                return "<span id='amount-withdraw-".$commissions->id."'>".$commissions->amount_withdraw."</span>";
            }) 
            ->editColumn('item_name',function($commissions)
            {
                $sale_item = DB::table("nso007_sale_detail_stock")->where("sale_id",$commissions->sale_id)->select("item_id")->get();
                $item_names="";
                foreach ($sale_item as $key => $value) {
                    $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                    if(isset($sale_item[$key+1])) $item_names.=",";
                }
                return $item_names;
            })
            // ->editColumn("item_name",function($commissions){
            //     $data_items=DB::table("nso007_sale_detail_stock")->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")->select("nso007_item_stock.*")->where("nso007_sale_detail_stock.sale_id",$commissions->sale_id)->get();
            //     $item="";
            //     foreach ($data_items as $key => $value) {
            //         $item.=$value->name;
            //         if($key<count($data_items)-1){
            //             $item.=",";
            //         }
            //     }
            //     return $item;
            // })
            ->addColumn("action",function($commissions){
                $button = "";
                if($commissions->withdraw_status!=0){
                    if(Gate::check('Commission-Show-Withdraw-History'))
                        $button.=" <span id='btn-view-commission-history-".$commissions->id."'><a href='javascript:void(0)' onclick='view_history(".$commissions->id.",this)' class='btn btn-sm btn-info' title='view withdraw history'><i class='fas fa-eye'></i></a><span>";
                }
                else{
                    if(Gate::check('Commission-Show-Withdraw-History'))
                    $button.=" <button disabled class='btn btn-sm btn-info' title='view withdraw history'><i class='fas fa-eye'></i></button>";
                }

                if($commissions->amount_available>0){
                    if(Gate::check('Commission-Pay'))
                        $button.=" <a href='javascript:void(0)' class='btn btn-sm btn-success' title=' withdraw commission' onclick='withdraw_form(this)'><i class='fas fa-dollar-sign'></i></a>";
                }else{
                    if(Gate::check('Commission-Pay'))
                        $button.=" <button disabled class='btn btn-sm btn-success' title=' withdraw commission'><i class='fas fa-dollar-sign'></i></button>";
                }

                return $button;

            })
            ->rawColumns([
                'action' => 'action',
                'amount_available'=>"amount_available",
                "amount_withdraw"=>"amount_withdraw"
            ])
            ->make(true);
    }

    public function get_commission_history(Request $request){
        $this->validate($request,[
            "commission_id"=>"required"
        ]);

        $commission_id = $request->commission_id;

        $data = DB::table("nso007_commission_history")->where("commission_id",$commission_id)->get();

        return json_encode($data);
    }

    public function print_invoice_commission($id)
    {
        $data = DB::table("nso007_commission_history")
                ->join("nso007_commission","nso007_commission.id","nso007_commission_history.commission_id")
                ->join("nso007_agency","nso007_agency.id","nso007_commission_history.agency_id")
                ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_commission.sale_id")
                ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_commission.sale_id")
                ->leftJoin("nso007_loan","nso007_loan.sale_id","nso007_commission.sale_id")
                ->select(
                    "nso007_project_stock.name as project_name",
                    "nso007_category_stock.name as category_name",
                    "nso007_agency.name as agency_name",
                    "nso007_agency.phone as agency_phone",
                    "nso007_commission_history.*",
                    "nso007_sale_stock.sale_amount",
                    "nso007_loan.discount_amount",
                    DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name")
                )
                ->where("nso007_commission_history.id",$id)
                ->groupBy("nso007_commission_history.id")
                ->first();
                // dd($data);
        return view("invoice.commission_invoice",compact("data"));
    }
    public function get_commission_info(Request $request)
    {
        $this->validate($request,[
            "commission_id"=>"required|numeric"
        ]);
        $data = CommissionModel::where("id",$request->commission_id)->first();
        return json_encode($data);
    }
    public function save_withdraw_commission(Request $request)
    {
        $this->validate($request,[
            "commission_id"=>"required|numeric",
            "withdraw_amount"=>"required|numeric",
            "date"=>'required'
        ]);

        DB::beginTransaction();
        try
        {
            $commission_id = $request->commission_id;
            $withdraw_amount = $request->withdraw_amount;
            $description = $request->description;
            $date = $request->date;
            //Update Commission
            CommissionModel::where("id",$commission_id)->decrement("amount_available",$withdraw_amount);
            CommissionModel::where("id",$commission_id)->increment("amount_withdraw",$withdraw_amount);
            $withdraw_status=array('withdraw_status'=>1);
            CommissionModel::where("id",$commission_id)->update($withdraw_status);
            //End

            //Get data for Insert to commission history
            $data_info = CommissionModel::join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")
                ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_commission.sale_id")
                ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                ->where("nso007_commission.id",$commission_id)
                ->select(
                    "nso007_commission.*",
                    "nso007_agency.name as agency_name",
                    "nso007_agency.id as agency_id",
                    DB::raw("GROUP_CONCAT(DISTINCT nso007_item_stock.name) as item_name")
                )
                ->first();
            //complete withdraw
            if($data_info->commission_amount==$data_info->amount_withdraw){
                $withdraw_status=array('withdraw_status'=>2);
                CommissionModel::where("id",$commission_id)->update($withdraw_status);
            }
            //End

            //Insert into commission history
            $data = array(
                "commission_id"=>$commission_id,
                "agency_id"=>$data_info->agency_id,
                "item_name"=>$data_info->item_name,
                "amount"=>$withdraw_amount,
                "date"=>date("Y-m-d",strtotime($date)),
                "description"=>$description
            );
            DB::table("nso007_commission_history")->insert($data);

            $commission_history_id = DB::table("nso007_commission_history")->max("id");
            //End

            //Accounting
            if($withdraw_amount>0){

                $item_id = DB::table("nso007_sale_detail_stock")->where("sale_id",$data_info->sale_id)->first()->item_id;
                $project_id = DB::table("nso007_item_stock")->where("id",$item_id)->first()->project_id;

                $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=0;
                $journal->journal_type=5;
                $journal->journal_acccode=11001;
                $journal->voucher_type=2;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $data_info->sale_id).' Commission Withdraw';
                $journal->journal_debit= 0;
                $journal->journal_credit=$withdraw_amount;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($date));
                $journal->journal_currency=1;
                $journal->transaction_type='Commission-Withdraw';
                $journal->journal_referenceid=$commission_history_id;
                $journal->journal_by_project=$project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jj->last_id;
                $journal->journal_type=2;
                $journal->journal_acccode=21001;
                $journal->voucher_type=2;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $data_info->sale_id).' Commission Withdraw';
                $journal->journal_debit=$withdraw_amount;
                $journal->journal_credit = 0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($date));
                $journal->journal_currency=1;
                $journal->transaction_type='Commission-Withdraw';
                $journal->journal_referenceid=$commission_history_id;
                $journal->journal_by_project=$project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();
            }
            //End
            DB::commit();
            return json_encode($data_info);
        }
        catch (\Exception $ex)
        {
            DB::rollback();
            return json_encode("ERROR");
        }
    }
}
