<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ClientModel;
use DataTables;
use App\LoanModel;
use Crypt;
use DB;
use App\LoanProcessModel;
use Auth;
use App\CommissionModel;
use App\LoanPaidModel;
use App\LoanClientRelationshipModel;
use App\AccountChartModel;
use App\JournalModel;
use Gate;
use App\SaleDetailModel;
use App\ItemModel;
use App\ProjectModel;
use App\DepositModel;
use App\SaleModel;
use App\CategoryModel;

class ClientPaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Client-Payment-Show', ['only' => ['index','get_client_payment','show','client_payment_list_detail']]);
         $this->middleware('permission:Client-Payment-Print-Contract', ['only' => ['print_contract']]);
         $this->middleware('permission:Client-Payment-Print-Schedule', ['only' => ['print_schedule']]);
         $this->middleware('permission:Client-Payment-Pay', ['only' => ['payment_method']]);
         $this->middleware('permission:Client-Payment-Print-Invoice', ['only' => ['print_invoice_payment']]);
    }
    public function index()
    {
        $projects = ProjectModel::pluck("name","id")->prepend("Please Select","");
        $categories = CategoryModel::pluck("name","id")->prepend("Please Select","");
        $items = ItemModel::where("sale_stock",2)->pluck("name","id")->prepend("Please Select","");
        return view("client-payment.index",compact('projects','categories','items'));
    }

    public function get_client_payment(Request $request)
    {
        $search = $request->input('search.value');
        $input=$request->all();
        $count_total = ClientModel::join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                        ->where("nso007_client.status",1)
                        ->where("nso007_loan.status",1)
                        ->groupBy("nso007_client.id")
                        ->get();
        $count_filter = ClientModel::join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                    ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_client.id' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->where('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->where('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->where('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['block_id']))
                            $query->where('nso007_item_stock.block_id' ,$input['block_id']);
                    })
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.status",1)
                    ->groupBy("nso007_client.id")
                    ->get();

        $client_loans = ClientModel::with(['get_province','get_district','get_commune','get_village'])
                    ->join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                    ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->select("nso007_client.*","nso007_loan.id as loan_id")
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.status",1)
                    ->where(function($query) use ($input){
                        if(!empty($input['item_id']))
                            $query->where('nso007_item_stock.id' ,$input["item_id"]);
                        if(!empty($input['project_id']))
                            $query->where('nso007_project_stock.id' ,$input['project_id']);
                        if(!empty($input['category_id']))
                            $query->where('nso007_category_stock.id' ,$input['category_id']);
                        if(!empty($input['block_id']))
                            $query->where('nso007_item_stock.block_id' ,$input['block_id']);
                    })
                    ->groupBy("nso007_client.id")
                    ->take(20);

        return Datatables::of($client_loans)
            ->addIndexColumn()
            ->setRowId("loan_id")
            ->with([
                "recordsTotal" => count($count_total),
                 "recordsFiltered" => count($count_filter),
              ])
            ->editColumn('date_of_birth',function($client_loans){
                return date("d-m-Y",strtotime($client_loans->date_of_birth));
            })
            ->editColumn("code",function($client_loans){
                $code="0000".$client_loans->id;
                return $code;
            })
            ->editColumn("address",function($client_loans){
                $location="";
                if(!empty($client_loans->house_number)) $location.=$client_loans->house_number;
                if(!empty($client_loans->street_number)) $location.=" ,".$client_loans->street_number;
                if(!empty($client_loans->get_village['village_km'])) $location.="  ភូមិ ".$client_loans->get_village['village_km'];
                if(!empty($client_loans->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$client_loans->get_commune['commune_km'];
                if(!empty($client_loans->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$client_loans->get_district['district_km'];
                if(!empty($client_loans->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$client_loans->get_province['province_km'];
                return $location;
            })
            ->addColumn("action",function($client_loans){
                return "<a href='".route("client-payment.show",Crypt::encrypt($client_loans->id))."' class='btn btn-sm btn-info' title='view'><i class='fas fa-eye'></i></a>";
            })
            ->rawColumns([
                'action' => 'action'
            ])
            ->make(true);
    }


    public function show($id)
    {
        $banklist = AccountChartModel::select(DB::raw("CONCAT(code, ' | ',acc_name) as account_name"), "code")
        ->where('code', 11001)
        ->Orwhere('code', 11002)
         ->orderBy('code')
        ->pluck("account_name", "code");

        $client_id = Crypt::decrypt($id);

        return view("client-payment.show",['client_id'=>$client_id,'banklist'=>$banklist]);
    }

    public function client_payment_list_detail(Request $request,$client_id)
    {
        $search = $request->input('search.value');
        $count_total = ClientModel::join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.id",$client_id)
                    // ->groupBy("nso007_loan.sale_id")
                    ->count();
        $count_filter = ClientModel::join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where(function($query) use ($search){
                        $query->orWhere('nso007_item_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_category_stock.name' , 'LIKE' , '%'.$search.'%');
                        $query->orWhere('nso007_project_stock.name' , 'LIKE' , '%'.$search.'%');
                    })
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.id",$client_id)
                    // ->groupBy("nso007_loan.sale_id")
                    ->count();

        $client_loans = ClientModel::with(['get_province','get_district','get_commune','get_village'])
                    ->join("nso007_loan","nso007_client.id","nso007_loan.client_id")
                    ->join("nso007_sale_detail_stock","nso007_loan.sale_id","nso007_sale_detail_stock.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->leftJoin("nso007_agency","nso007_agency.id","nso007_loan.agency_id")
                    ->select(
                        "nso007_client.*",
                        "nso007_loan.id as loan_id",
                        "nso007_loan.sale_id as sale_id",
                        "nso007_category_stock.name as category_name",
                        "nso007_project_stock.name as project_name",
                        DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
                        "nso007_loan.sale_amount",
                        "nso007_loan.discount_amount",
                        "nso007_loan.interest",
                        "nso007_loan.duration",
                        "nso007_loan.commission_status",
                        "nso007_loan.interest_second_option",
                        "nso007_agency.name as agency_name",
                        "nso007_loan.agency_id"
                    )
                    ->where("nso007_project_stock.status",1)
                    ->where("nso007_category_stock.status",1)
                    ->where("nso007_item_stock.status",1)
                    ->where("nso007_client.status",1)
                    ->where("nso007_loan.status",1)
                    ->where("nso007_client.id",$client_id)
                    ->groupBy("nso007_loan.sale_id")
                    ->take(20);

        return Datatables::of($client_loans)
            ->addIndexColumn()
            ->setRowId("loan_id")
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->editColumn("sale_amount",function ($client_loans){
                return "$".number_format(($client_loans->sale_amount - $client_loans->discount_amount),2);
            })
            ->editColumn("interest",function($client_loans){
                $interest_value="";
                if(isset($client_loans->interest)&&!empty(optional($client_loans)->interest)){
                    if($client_loans->interest_second_option==2){
                        $data_interest_change = DB::table("nso007_loan_change_interest")->where("loan_id",$client_loans->loan_id)->get();
                        foreach($data_interest_change as $ch_key=>$value_ch){
                            $interest_value .= $value_ch->interest."%"." ចាប់ពីខែទី".$value_ch->from_month." ដល់ ខែទី".$value_ch->to_month;
                            if($ch_key<count($data_interest_change)-1) $interest_value .= "<br>";
                        }
                        return $interest_value;
                    }else{
                        $str = explode("/",$client_loans->interest);
                        if(count($str)>3&&isset($str[0])&&isset($str[1])&&isset($str[2])&&isset($str[3])){
                            $interest_value=$str[0]."% ".$str[1].",<br>".$str[2]."% ".$str[3];
                        }
                        else if(count($str)>2&&isset($str[0])&&isset($str[1])&&isset($str[2])){
                            $interest_value=$str[0]."% "."<br>".$str[1]."%".$str[2];
                        }else if(isset($str[0])&&isset($str[1])){

                            $interest_value=$str[0]."% ".$str[1];
                        }
                        else if(isset($str[0])){

                            $interest_value=$str[0]."% ";
                        }
                        else {return "";}
                        return $interest_value;
                    }
                }else{
                    return "0%";
                }
            })
            ->editColumn('item_name',function($client_loans)
            {
                $sale_item = DB::table("nso007_sale_detail_stock")->where('status',1)->where("sale_id",$client_loans->sale_id)->select("item_id")->get();
                $item_names="";
                foreach ($sale_item as $key => $value) {
                    $item_names.=DB::table("nso007_item_stock")->where("id",$value->item_id)->select("name")->first()->name;
                    if(isset($sale_item[$key+1])) $item_names.=",";
                }
                return $item_names;
            })
            ->addColumn("action",function($client_loans){
                $loan_process_count = LoanProcessModel::where("loan_id",$client_loans->loan_id)->where("status",1)->where("owe_amount_pay",'>',0)->count();
                $button="";

                if(Gate::check('Client-Payment-Print-Contract')){
                    $button .=' <a href="'.route("client-payment.print_contract",$client_loans->loan_id).'" class="btn btn-sm btn-info" title="Print Contract" target="_blank"><i class="fas fa-file-signature"></i></a>';
                    $button .= ' <a href="javascript:void(0)" onclick = "show_form_more_info_contract('.$client_loans->loan_id.')" class="btn btn-sm btn-warning" title="Add contract more information"><i class="fas fa-edit"></i></a>';
                }

                if(Gate::check('Client-Payment-Print-Schedule'))
                {
                    $button .=' <a href="'.route('client-payment.print_schedule',$client_loans->loan_id).'" class="btn btn-sm btn-success" title="Print Schedule Pay" target="_blank"><i class="fas fa-calendar-alt"></i></a>';
                    $button .=' <a href="javascript:void(0)" class="btn btn-sm btn-primary" title="Add Remark to Schedule Pay" onclick="schedule_remark('.$client_loans->loan_id.')"><i class="fa fa-calendar-plus"></i></a>';
                }
                /*if(Gate::check('Client-Payment-Show-Client-Relationship'))
                    $button .=' <a href="#" class="btn btn-sm btn-success" title="View Client Relationship" onclick="view_client_relationship(this)"><i class="fas fa-eye"></i></a>';*/

                if(Gate::check('Client-Payment-Item-Border'))
                    $button .=' <a href="javascript:void(0)" class="btn btn-sm btn-info" title="Border" onclick="border_item('.$client_loans->loan_id.')"><i class="fas fa-border-all"></i></a>';
                if(Gate::check('Client-Payment-Edit-Installment')){
                    $button .= ' <a data-toggle="modal" href="#modal-danger-delete'.$client_loans->loan_id.'" title="Delete Payment" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>

                    <div class="modal fade" id="modal-danger-delete'.$client_loans->loan_id.'">
                    <form action="'.route("delete_payment",$client_loans->loan_id).'" method="GET" style="display:inline">
                      <div class="modal-dialog">
                        <div class="modal-content bg-danger">
                          <div class="modal-header">
                            <h4 class="modal-title">Delete Payment</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          <div class="modal-body">
                            <p style="font-size: 120%;">Are you sure want to delete this ?</p>
                          </div>
                          <div class="modal-footer justify-content-between">
                            <a>&nbsp;</a>
                            <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                          </div>
                        </div>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                      </form>
                    </div>
                    <!-- /.modal -->

                ';
                }

                if($loan_process_count==0)// payment don't complete
                {

                }
                else//Pay completed
                {
                    if(Gate::check('Client-Payment-Edit-Installment')){
                        $button .= '<span id="loan-'.$client_loans->loan_id.'">
                                <a class ="btn btn-sm btn-info" title="Reschedule" href="'.route("installment.edit",$client_loans->loan_id).'"><i class = "fa fa-edit"></i>
                                </a>
                            </span>';
                        $button .= ' <a data-toggle="modal" href="#modal-danger'.$client_loans->loan_id.'" title="Cancel Payment" class="btn btn-sm btn-danger"><i class="fa fa-times"></i></a>

                            <div class="modal fade" id="modal-danger'.$client_loans->loan_id.'">
                            <form action="'.route("cancel_payment",$client_loans->loan_id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">Cancel Payment</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">Are you sure want to cancel this ?</p>
                                    <p style="font-size: 120%;">Date : <input type="date" name="date" class="form control" value="'.date("d-m-Y").'" required></p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->

                        ';

                    }
                }
                if(Gate::check('Client-Payment-Change-Client'))
                    $button .=' <a href="javascript:void(0)" class="btn btn-sm btn-info" title="Change Client" onclick="display_form_change_client('.$client_loans->loan_id.')"><i class="fas fa-users"></i></a>';
                return $button;
            })
            ->rawColumns(['action' => 'action','interest'=>'interest'])
            ->make(true);
    }
    public function get_client_payment_detailt_list($loan_id)
    {
        $data = LoanProcessModel::where("loan_id",$loan_id)->where("status",1);
        $data = $data->get();
        return json_encode($data);
    }
    public function get_data_for_payment(Request $request)
    {
        $loan_process_id = $request->loan_process_id;
        $data = LoanProcessModel::where("id",$loan_process_id)->first();
        return json_encode($data);
    }
    public function payment(Request $request)
    {
        dd($request->all());
    }
    public function print_contract($id)
    {
        $loan_data=LoanModel::where("id",$id)->first();
        $client_data = ClientModel::find($loan_data->client_id);
        $client_relatatonship_data = LoanClientRelationshipModel::where("sale_id",$loan_data->sale_id)->get();
        $client_relatatonship_data_info="";$client_relationship_name = "";
        if(empty($client_relatatonship_data)) $client_relatatonship_data_info ="";
        else{
             foreach($client_relatatonship_data as $value)
             {
                $client_relationship_name.=" , ".$value->ClientRelationshipModels->name;
                $client_relatatonship_data_info .=
                    " <b>និង</b><br/> ឈ្មោះ <b>".$value->ClientRelationshipModels->name."</b> ត្រូវជា".$value->relationship_type." ភេទ".($value->ClientRelationshipModels->gender=="Male"?"ប្រុស":"ស្រី")." ថ្ញៃខែឆ្នាំកំណើត​ ថ្ងៃទី ".\Globals::date_khmers($value->ClientRelationshipModels->date_of_birth)." ជនជាតិ ខ្មែរ សញ្ជាតិខ្មែរ អត្តសញ្ញាណប័ណ្ណលេខ ".$value->ClientRelationshipModels->id_card_number." ចុះថ្ងៃទី ".\Globals::date_khmers($value->ClientRelationshipModels->date_of_birth)." មានទីលំនៅ ".(!empty($value->ClientRelationshipModels->village)?(" ភូមិ".$value->ClientRelationshipModels->get_village->village_km):"").(!empty($value->ClientRelationshipModels->commune)?(" ឃុំ".$value->ClientRelationshipModels->get_commune->commune_km):"").(!empty($value->ClientRelationshipModels->phone)?(" ទូរស័ព្ទលេខ ".$value->ClientRelationshipModels->phone):"");

                    // dd($value->ClientRelationshipModels->get_district->district_km);

                $client_relatatonship_data_info." ស្រុក".$value->ClientRelationshipModels->get_district->district_km;

                $client_relatatonship_data_info.=(!empty($value->ClientRelationshipModels->province)?(" ខេត្ត".$value->ClientRelationshipModels->get_province->province_km):"");
             }
        }
        $sale_detail = SaleDetailModel::where("sale_id",$loan_data->sale_id)->where("status",1)->get();
        $item_info = array();$item_info[0]="";$item_info[1]="";
        $project_id ="";$sub_category = "";$item_width = "";$item_lenght = "";
        foreach ($sale_detail as $key => $value) {
            $item_info[0].=  ItemModel::find($value->item_id)->name;
             $item_info[1].=  ItemModel::find($value->item_id)->size;
             $item_width = ItemModel::find($value->item_id)->width;
             $item_lenght = ItemModel::find($value->item_id)->length;
             $project_id = ItemModel::find($value->item_id)->project_id;
             $sub_category = optional(DB::table("nso007_sub_category")->where("id",ItemModel::find($value->item_id)->subcategory_id)->first())->name;
            if(isset($sale_detail[$key+1]))  {
                $item_info[0].=","; $item_info[1].=",";
            }
        }
        $address_project="";
        $project = ProjectModel::find($project_id);
        $address_project .= (!empty($project->commune)?("ផ្លូវលេខ".$project->street_number):"");
        $address_project .= (!empty($project->village)?(" ភូមិ".$project->get_village->village_km):"");
        $address_project .= (!empty($project->commune)?(" ឃុំ".$project->get_commune->commune_km):"");
        $address_project .= (!empty($project->district)?(" ស្រុក".$project->get_district->district_km):"");
        $address_project .= (!empty($project->province)?(" ខេត្ត".$project->get_province->province_km):"");

        $project_name = $project->name;

        $deposit_data_info ="<div style='margin-left:7%;'>";$loan_amount =$loan_data->sale_amount - $loan_data->discount_amount;
        $deposit_data = DepositModel::where("sale_id",$loan_data->sale_id)->where("status",1)->get();

        $item_border = DB::table('nso007_item_loan_border')->where("loan_id",$id)->first();

        foreach($deposit_data as $key => $value){
            $deposit_data_info .= ' - ភាគី(ខ)បាន យល់ព្រមកក់ប្រាក់លើកទី '.($key+1).' ចំនួន '.number_format($value->deposit_amount,2).' USD ថ្ងៃទី​ '.\Globals::date_khmers(date('d-m-Y',strtotime($value->date))).'';
            $loan_amount -=$value->deposit_amount;
            if(isset($deposit_data[$key+1])) $deposit_data_info.="<br/>";
        }

        if(empty($deposit_data)||count($deposit_data)<=0)  $deposit_data_info .='- ភាគី(ខ)បាន យល់ព្រមកក់ប្រាក់លើកទី1 ចំនួន '.number_format(0,2).' USD';

        $deposit_data_info.=" ។</div>";

        $contract_date = \Globals::date_khmer_get_word($loan_data->sales->date_on_contract);

        return view("contract.client-payment-contract",compact("loan_data",'client_data','client_relatatonship_data_info','item_info','address_project','deposit_data_info','loan_amount','item_border','project_name','client_relationship_name','client_relatatonship_data','item_width','item_lenght','sub_category','contract_date'));
    }
    public function print_schedule($id)
    {
        $tr_data="";
        $loan_process_data = LoanProcessModel::where("loan_id",$id)->get();
        $loan_info = LoanModel::join("nso007_client","nso007_client.id","nso007_loan.client_id")
                    ->leftJoin("nso007_agency","nso007_agency.id","nso007_loan.agency_id")
                    ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
                    ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
                    ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
                    ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
                    ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
                    ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_loan.sale_id")
                    ->select(
                        "nso007_project_stock.name as project_name",
                        "nso007_client.name as client_name",
                        "nso007_loan.client_id as Cus_id",
                        "nso007_agency.name as agency_name",
                        "nso007_agency.phone as agency_phone",
                        "nso007_client.phone as client_phone",
                        "nso007_client.id_card_number",
                        "nso007_loan.sale_amount as sale_amount",
                        "nso007_loan.discount_amount as discount_amount",
                        "nso007_sale_stock.sale_receive_amount as deposit_amount",
                        "nso007_sale_stock.id as sale_id",
                        "nso007_sale_stock.date as sale_date",
                        DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
                        DB::raw("GROUP_CONCAT(nso007_item_stock.size) as item_size"),
                        'nso007_loan.duration',
                        "nso007_loan.first_date_pay",
                        "nso007_loan.interest",
                        "nso007_loan.id as loan_id",
                        "nso007_loan.duration_by_year",
                        "nso007_loan.interest_by_year",
                        "nso007_loan.interest_second_option",
                        "nso007_sub_category.name as sub_name"
                    )
                    ->where("nso007_loan.id",$id)
                    ->groupBy("nso007_sale_detail_stock.sale_id")
                    ->first();
        $end_date_payment ="";$total_priciple=0;$total_interest=0;$total_payment_amount =0;
        foreach($loan_process_data as $key => $value){
            $tr_data .= '
                <tr>
                    <td align="center">'.\Globals::LatinnumberTokhnumber(($key+1)).'</td>
                    <td>'.(!empty($value->date_payment)?\Globals::date_khmer_get_word(date("d-m-Y",strtotime($value->date_payment))):"").'</td>
                    <td>'.number_format($value->principle,2).' $</td>
                    <td>'.number_format($value->interest_amount,2).' $</td>
                    <td>'.number_format($value->owe_amount,2).' $</td>
                    <td>'.number_format($value->principle_os,2).' $</td>
                    <td></td>
                </tr>

            ';
            $total_priciple+=$value->principle;
            $total_interest+=$value->interest_amount;
            $total_payment_amount+=$value->owe_amount;
            $end_date_payment = $value->date_payment ;
        }
        $tr_data.='<tr>
                        <td>សរុប</td>
                        <td></td>
                        <td>'.number_format($total_priciple,2).' $</td>
                        <td>'.number_format($total_interest,2).' $</td>
                        <td>'.number_format($total_payment_amount,2).' $</td>
                        <td colspan="2"></td>
                    </tr>';
        $client_data ="";
        $client_data = ClientModel::where("id",$loan_info->Cus_id)->first();

        $client_relatatonship_data = LoanClientRelationshipModel::where("loan_id",$id)->get();
        $client_relatatonship_name =",";
        if(empty($client_relatatonship_data)) $client_relatatonship_name ="";
        else if(count($client_relatatonship_data)<=0) $client_relatatonship_name ="";
        else{
            foreach($client_relatatonship_data as $key=>$value)
            {
                $client_relatatonship_name .=$value->ClientRelationshipModels->name;
                if(isset($client_relatatonship_data[$key+1])) $client_relatatonship_name.=",";
            }
        }

        $sale_data = SaleModel::find($loan_info->sale_id);

        $data_payment_policy = optional(DB::table("nso007_payment_policy")->where("id",$sale_data->policy_payment_id)->first())->name;
        $data_payment_policy_detail = optional(DB::table("nso007_payment_policy_detail")->where("id",$sale_data->policy_payment_detail_id)->first())->name;

        $payment_policy_info = "";
        if(empty($data_payment_policy)) $payment_policy_info = "";
        else if(!empty($data_payment_policy_detail)){
            $payment_policy_info = $data_payment_policy."(".$data_payment_policy_detail.")";
        }
        else if(empty($data_payment_policy_detail)){
            $payment_policy_info = $data_payment_policy;
        }
        else $payment_policy_info = "";

        $scheduel_remark = DB::table("nso007_schedule_remark")->where("loan_id",$id)->first();

        return view("schedule.schedule-client-payment",compact('tr_data','loan_info','client_data','end_date_payment','client_relatatonship_name','payment_policy_info','scheduel_remark'));
    }
    public function add_commission(Request $request)
    {
        $this->validate($request,[
            'sale_id'=>'required|numeric',
            'agency_id'=>'required|numeric',
            'commission_amount'=>'required|numeric',
            'date'=>'required',
            'commission_condition'=>'required|numeric'
        ]);

        $sale_data = SaleModel::where("id",$request->sale_id)->first();

        $data = array([
            'agency_id'=>$request->agency_id,
            'client_id'=>$sale_data->client_id,
            'sale_id'=>$request->sale_id,
            'user_id'=>Auth::user()->id,
            'sale_amount'=>$sale_data->sale_amount,
            'commission_amount'=>$request->commission_amount,
            'amount_available'=>0,
            'date'=>date("Y-m-d",strtotime($request->date)),
        ]);
        CommissionModel::insert($data);

        $commission_id = CommissionModel::max("id");
        $item_id = DB::table("nso007_sale_detail_stock")->where("sale_id",$request->sale_id)->first()->item_id;
        $project_id = DB::table("nso007_item_stock")->where("id",$item_id)->first()->project_id;

        $commission_condition_data = DB::table('nso007_commission_condition_detail_setting')->where("commission_condition_id",$request->commission_condition)->get();
        foreach ($commission_condition_data as $key => $value) {
            DB::table("nso007_sale_commission_condition")->insert(
                [
                    'commission_condition_id'=>$request->commission_condition,
                    'sale_id'=>$request->sale_id,
                    'commission_condition'=>$value->commission_condition,
                    'can_withdraw_condion'=>$value->can_withdraw_condion,
                    'commission_title'=>DB::table("nso007_commission_condition_setting")->where("id",$request->commission_condition)->first()->title,
                    'commission_type'=>$value->commission_type
                ]
            );
        }
        DB::table("nso007_commission_condition_setting")->where("id",$request->commission_condition)->update(["delete_status"=>0]);

        //Update Loan
        SaleModel::where("id",$request->sale_id)->update(['commission_status'=>1]);

        \Globals::calculate_commission($request->sale_id);

        if($request->commission_amount>0){
            $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=0;
            $journal->journal_type=50000;
            $journal->journal_acccode=51014;
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $request->sale_id).' Commission ';
            $journal->journal_debit= $request->commission_amount;
            $journal->journal_credit=0;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d H:i:s");
            $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
            $journal->journal_currency=1;
            $journal->transaction_type='Commission';
            $journal->journal_referenceid=$commission_id;
            $journal->journal_by_project=$project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();

            $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=$jj->last_id;
            $journal->journal_type=20000;
            $journal->journal_acccode=21001;
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $request->sale_id).' Commission ';
            $journal->journal_debit=0;
            $journal->journal_credit = $request->commission_amount;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d H:i:s");
            $journal->journal_paydate=date("Y-m-d",strtotime($request->date));
            $journal->journal_currency=1;
            $journal->transaction_type='Commission';
            $journal->journal_referenceid=$commission_id;
            $journal->journal_by_project=$project_id;
            $journal->journal_by=auth()->user()->id;
            $journal->save();
        }

        return json_encode(['commission_status'=>1]);
    }
    public function get_edit_commission(Request $request)
    {
        $this->validate($request,[
            "sale_id"=>"required|numeric"
        ]);

        $sale_id = $request->sale_id;

        $data_commission = CommissionModel::join("nso007_agency","nso007_agency.id","nso007_commission.agency_id")->select("nso007_commission.*","nso007_agency.name as agency_name")->where("sale_id",$sale_id)->first();
        $data = array(
            'data_commission' =>$data_commission ,
            "commission_condition"=>DB::table("nso007_sale_commission_condition")->where("sale_id",$sale_id)->get(),
            'commission_condition_setting'=>DB::table('nso007_commission_condition_setting')->get()
        );

        return json_encode($data);
    }
    public function save_edit_commission(Request $request)
    {
        $this->validate($request,[
            "sale_id"=>"required|numeric",
            "commission_amount"=>"required|numeric",
            "date"=>'required',
        ]);

        $sale_data = SaleModel::where("id",$request->sale_id)->first();

        $data = array(
            'date'=>date("Y-m-d",strtotime($request->date)),
            "commission_amount"=>$request->commission_amount
        );

        CommissionModel::where("sale_id",$request->sale_id)->update($data);

        DB::table("nso007_sale_commission_condition")->where('sale_id',$request->sale_id)->delete();
        $commission_condition_data = DB::table('nso007_commission_condition_detail_setting')->where("commission_condition_id",$request->edit_commission_condition)->get();
        foreach ($commission_condition_data as $key => $value) {
            DB::table("nso007_sale_commission_condition")->insert(
                [
                    'commission_condition_id'=>$request->edit_commission_condition,
                    'sale_id'=>$request->sale_id,
                    'commission_condition'=>$value->commission_condition,
                    'can_withdraw_condion'=>$value->can_withdraw_condion,
                    'commission_title'=>DB::table("nso007_commission_condition_setting")->where("id",$request->edit_commission_condition)->first()->title,
                    "commission_type"=>$value->commission_type
                ]
            );
        }

        DB::table("nso007_commission_condition_setting")->where("id",$request->edit_commission_condition)->update(["delete_status"=>0]);

        \Globals::calculate_commission($request->sale_id);

        $commission_id = CommissionModel::where("sale_id",$request->sale_id)->first()->id;
        $item_id = DB::table("nso007_sale_detail_stock")->where("sale_id",$request->sale_id)->first()->item_id;
        $project_id = DB::table("nso007_item_stock")->where("id",$item_id)->first()->project_id;

        if($request->commission_amount>0){
            $j=JournalModel::where("journal_referenceid",$commission_id)->where("transaction_type","=","Commission")->where("journal_by_project",$project_id)->get();
            $data = array(
                "journal_debit"=> $request->commission_amount,
                "journal_transactiondate"=>date("Y-m-d H:i:s"),
                "journal_paydate"=>date("Y-m-d",strtotime($request->date)),
            );
            JournalModel::where("id",$j[0]->id)->update($data);

            $data1 = array(
                "journal_credit"=> $request->commission_amount,
                "journal_transactiondate"=>date("Y-m-d H:i:s"),
                "journal_paydate"=>date("Y-m-d",strtotime($request->date)),
            );
            JournalModel::where("id",$j[1]->id)->update($data1);
        }

        return json_encode("OK");
    }

    public function payment_method(Request $request)
    {
        // dd($request->all());
        $this->validate($request,[
            'principle'=>'required|numeric',
            'interest'=>'required|numeric',
            'payment_amount'=>'required|numeric',
            'pay_amount'=>'required|numeric',
            'payment_method_type'=>'required|numeric',
            'date'=>'required',
            'loan_process_id'=>'required',
            'payment_method'=>'required'
        ]);
        if($request->payment_method == 2){
            $this->validate($request,[
                'from_bank_name'=>'required',
                'from_bank_account'=>'required',
                'to_bank_name'=>'required',
                'to_bank_account'=>'required'
            ]);
        }
        if($request->payment_method == 3){
            $this->validate($request,[
                'bank_of_cheque'=>'required',
                'cheque_number'=>'required',
            ]);
        }
        $data_payment = $request->all();
        //get loan process info
        $data_loan_process = LoanProcessModel::where("id",$request->loan_process_id)->first();
        if(empty($data_loan_process)) return;
        //end

        $this->payment_process($data_payment,$data_loan_process);

        return redirect()->back();
    }
    public function payment_process($data_payment,$data_loan_process){
        //get loan info
        $data_loan = LoanModel::where("id",$data_loan_process->loan_id)->first();
        //end

        $sale_price = $data_loan->sale_amount - $data_loan->discount_amount;

        $interest_amount_pay = $data_loan_process->interest_amount_pay;

        $principle_pay = $data_loan_process->principle_pay;

        $owe_amount_pay = $data_loan_process->owe_amount_pay;

        $no = $data_loan_process->no;

        $data_payment['bank_list'] = ($data_payment['payment_method']==1?"11001":"11002");

        if($data_payment['pay_amount']>0&&$data_payment['pay_amount'] < ($data_payment['principle'] + $data_payment['interest'])){
//            dd($data_loan_process->id.'-1');
            if($data_payment['pay_amount'] <= $data_payment['principle']){

                $curr_principle_pay = $data_payment['pay_amount'];

                $principle_percentage_paid = $curr_principle_pay*100/$sale_price;
                //update loan
                LoanModel::where("id",$data_loan_process->loan_id)->decrement('amount_os',$curr_principle_pay);

                LoanModel::where("id",$data_loan_process->loan_id)->increment('percentage_paid', $principle_percentage_paid);
                //end

                //update loan_process
                $data = [
                    "principle_pay"=> $principle_pay - $curr_principle_pay,
                    "owe_amount_pay"=> $owe_amount_pay - $curr_principle_pay,
                    "date_paid"=> date("Y-m-d",strtotime($data_payment['date'])),
                    "create_date"=> date("Y-m-d",strtotime($data_payment['date'])),
                    'paid_type'=>1
                ];
                LoanProcessModel::where("id",$data_loan_process->id)->update($data);
                //end

                //insert loan paid
                $data_paid = array(
                    'loan_process_id' => $data_loan_process->id,
                    'payment_date'=> date("Y-m-d",strtotime($data_payment['date'])),
                    'interest'=>  0,
                    'principle'=> $curr_principle_pay,
                    'penalty'=>(isset($data_payment['penalty_pay'])&&$data_payment['penalty_pay']>0?$data_payment['penalty_pay']:0),
                    'total_amount'=> $curr_principle_pay + (isset($data_payment['penalty_pay'])&&$data_payment['penalty_pay']>0?$data_payment['penalty_pay']:0),
                    'user_id'=> Auth::user()->id,
                    'remark'=> $data_payment['description'],
                    'accountant'=> $data_payment['accountant'],
                    'acc_code'=> ($data_payment['payment_method']==1?"11001":"11002"),
                    'payment_type'=>$data_payment['payment_method'],
                    'from_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_name']:null),
                    'from_account_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_account']:null),
                    'to_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_name']:null),
                    'to_account_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_account']:null),
                    'bank_cheque'=>($data_payment['payment_method']==3?$data_payment['bank_of_cheque']:null),
                    'cheque_number'=>($data_payment['payment_method']==3?$data_payment['cheque_number']:null)
                );
                LoanPaidModel::insert($data_paid);
                //end
                $loan_paid_id = LoanPaidModel::max("id");
                //Accounting
                $sale_id = $data_loan->sale_id;
                $des_data = $this->set_payment_description_return_project_with_des($data_loan_process->id);
                $loan_projectid = $des_data['project_id'];
                if($data_loan->loan_convert_to_income_status==0){
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $curr_principle_pay;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=21003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$curr_principle_pay;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }else{
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $curr_principle_pay;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=11003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$curr_principle_pay;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }
                //End
            }else{

                $curr_interest_pay = $data_payment['pay_amount'] - $principle_pay;

                $principle_percentage_paid = $principle_pay*100/$sale_price;
                //update loan
                LoanModel::where("id",$data_loan_process->loan_id)->decrement('amount_os',$principle_pay);

                LoanModel::where("id",$data_loan_process->loan_id)->increment('percentage_paid', $principle_percentage_paid);
                //end

                //update loan_process
                $data = [
                    "interest_amount_pay"=>$interest_amount_pay - $curr_interest_pay,
                    "principle_pay"=> 0,
                    "owe_amount_pay"=> $owe_amount_pay - $curr_interest_pay - $principle_pay,
                    "date_paid"=> date("Y-m-d",strtotime($data_payment['date'])),
                    "create_date"=> date("Y-m-d",strtotime($data_payment['date'])),
                    "paid_type"=>1
                ];
                LoanProcessModel::where("id",$data_loan_process->id)->update($data);
                //end

                //insert loan paid
                $data_paid = array(
                    'loan_process_id' => $data_loan_process->id,
                    'payment_date'=> date("Y-m-d",strtotime($data_payment['date'])),
                    'interest'=>  $curr_interest_pay,
                    'principle'=> $principle_pay,
                    'penalty'=>(isset($data_payment['penalty_pay'])?$data_payment['penalty_pay']:0),
                    'total_amount'=> $principle_pay + $curr_interest_pay + (isset($data_payment['penalty_pay'])?$data_payment['penalty_pay']:0),
                    'user_id'=> Auth::user()->id,
                    'remark'=> $data_payment['description'],
                    'accountant'=> $data_payment['accountant'],
                    'acc_code'=> ($data_payment['payment_method']==1?"11001":"11002"),
                    'payment_type'=>$data_payment['payment_method'],
                    'from_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_name']:null),
                    'from_account_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_account']:null),
                    'to_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_name']:null),
                    'to_account_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_account']:null),
                    'bank_cheque'=>($data_payment['payment_method']==3?$data_payment['bank_of_cheque']:null),
                    'cheque_number'=>($data_payment['payment_method']==3?$data_payment['cheque_number']:null)
                );
                LoanPaidModel::insert($data_paid);
                //end
                $loan_paid_id = LoanPaidModel::max("id");
                //Accounting
                $sale_id = $data_loan->sale_id;
                $des_data = $this->set_payment_description_return_project_with_des($data_loan_process->id);
                $loan_projectid = $des_data['project_id'];
                if($data_loan->loan_convert_to_income_status==0){
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=$principle_pay;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=21003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$principle_pay;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }else{
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $principle_pay;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=11003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$principle_pay;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }
                if($curr_interest_pay>0){
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $curr_interest_pay;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=41004;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$curr_interest_pay;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }

                //End
            }
        }
        else{
            while ($data_payment['pay_amount'] >= ($data_payment['principle'] + $data_payment['interest'])) {

//                $data_loan_process = LoanProcessModel::where("loan_id",$data_loan_process->loan_id)->where("status",1)->where("no",$no)->first();
                if(empty($data_loan_process)) return;
//                dd($data_loan_process->id.'-2');
                $data_payment['interest'] = $data_loan_process->interest_amount_pay;
                $interest_amount_pay = $data_payment['interest'];

                $principle_pay = $data_loan_process->principle_pay;
                $data_payment['principle'] = $principle_pay;

                $owe_amount_pay = $data_loan_process->owe_amount_pay;

                $principle_percentage_paid = $principle_pay*100/$sale_price;
                //update loan
                LoanModel::where("id",$data_loan_process->loan_id)->decrement('amount_os',$principle_pay);

                LoanModel::where("id",$data_loan_process->loan_id)->increment('percentage_paid', $principle_percentage_paid);
                //end

                //update loan_process
                $data = [
                    "interest_amount_pay"=> 0,
                    "principle_pay"=>0,
                    "owe_amount_pay"=> 0,
                    "date_paid"=> date("Y-m-d",strtotime($data_payment['date'])),
                    "create_date"=> date("Y-m-d",strtotime($data_payment['date'])),
                    "paid_type"=> 1
                ];
                LoanProcessModel::where("id",$data_loan_process->id)->update($data);
                //end

                $payment = $data_payment['interest'] + $data_payment['principle'] + (isset($data_payment['penalty_pay'])&&$data_payment['penalty_pay']>0?$data_payment['penalty_pay']:0);

                //insert loan paid
                $data_paid = array(
                    'loan_process_id' => $data_loan_process->id,
                    'payment_date'=> date("Y-m-d",strtotime($data_payment['date'])),
                    'interest'=>  $data_payment['interest'],
                    'principle'=> $data_payment['principle'],
                    'penalty'=>(isset($data_payment['penalty_pay'])&&$data_payment['penalty_pay']>0?$data_payment['penalty_pay']:0),
                    'total_amount'=> $data_payment['interest'] + $data_payment['principle'] + (isset($data_payment['penalty_pay'])&&$data_payment['penalty_pay']>0?$data_payment['penalty_pay']:0),
                    'user_id'=> Auth::user()->id,
                    'remark'=> $data_payment['description'],
                    'accountant'=> $data_payment['accountant'],
                    'acc_code'=> ($data_payment['payment_method']==1?"11001":"11002"),
                    'payment_type'=>$data_payment['payment_method'],
                    'from_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_name']:null),
                    'from_account_bank'=>($data_payment['payment_method']==2?$data_payment['from_bank_account']:null),
                    'to_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_name']:null),
                    'to_account_bank'=>($data_payment['payment_method']==2?$data_payment['to_bank_account']:null),
                    'bank_cheque'=>($data_payment['payment_method']==3?$data_payment['bank_of_cheque']:null),
                    'cheque_number'=>($data_payment['payment_method']==3?$data_payment['cheque_number']:null)
                );
                LoanPaidModel::insert($data_paid);
                //end
                $loan_paid_id = LoanPaidModel::max("id");
                //Accounting
                $sale_id = $data_loan->sale_id;
                $des_data = $this->set_payment_description_return_project_with_des($data_loan_process->id);
                $loan_projectid = $des_data['project_id'];
                if($data_loan->loan_convert_to_income_status==0){
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=$data_payment['principle'];
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=21003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$data_payment['principle'];
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }else{
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $data_payment['principle'];
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=11003;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$data_payment['principle'];
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }
                if($data_payment['interest']>0){
                    $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=0;
                    $journal->journal_type=10000;
                    $journal->journal_acccode=$data_payment['bank_list'];
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit= $data_payment['interest'];
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();

                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=20000;
                    $journal->journal_acccode=41004;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
                    $journal->journal_debit=0;
                    $journal->journal_credit=$data_payment['interest'];
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Payment';
                    $journal->journal_referenceid=$loan_paid_id;
                    $journal->journal_by_project=$loan_projectid;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }

                //End

                // dd($data_payment['principle']);
                $data_payment['pay_amount'] -=$data_payment['principle'];

                $no++;
                $data_payment['penalty_pay'] = 0;

                break;
            }

        }

        if($data_payment['penalty_pay']>0){
            $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=0;
            $journal->journal_type=10000;
            $journal->journal_acccode=$data_payment['bank_list'];
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
            $journal->journal_debit= $data_payment['penalty_pay'];
            $journal->journal_credit=0;
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d H:i:s");
            $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
            $journal->journal_currency=1;
            $journal->transaction_type='Payment';
            $journal->journal_referenceid=$loan_paid_id;
            $journal->journal_by_project=$loan_projectid;
            $journal->journal_by=auth()->user()->id;
            $journal->save();

            $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

            $journal=new JournalModel;
            $journal->branch_id=0;
            $journal->journal_parentid=$jj->last_id;
            $journal->journal_type=20000;
            $journal->journal_acccode=41005;
            $journal->voucher_type=1;
            $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
            $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Payment '.$no;
            $journal->journal_debit=0;
            $journal->journal_credit=$data_payment['penalty_pay'];
            $journal->journal_tran_id=$j->last_num+1;
            $journal->journal_transactiondate=date("Y-m-d H:i:s");
            $journal->journal_paydate=date("Y-m-d",strtotime($data_payment['date']));
            $journal->journal_currency=1;
            $journal->transaction_type='Payment';
            $journal->journal_referenceid=$loan_paid_id;
            $journal->journal_by_project=$loan_projectid;
            $journal->journal_by=auth()->user()->id;
            $journal->save();
        }

        // \Globals::convert_to_income($data_loan_process->loan_id,$data_payment['date'],$loan_projectid);

        \Globals::calculate_commission($sale_id);

    }
    public function get_paid_loan_process(Request $request)
    {
        $loan_process_id = $request->loan_process_id;
        $loan_paid = LoanPaidModel::where("loan_process_id",$loan_process_id)->where("status",1)->get();
        return json_encode($loan_paid);
    }
    public function print_invoice_payment($id)
    {
//        dd($id);
        $data = LoanPaidModel::join("nso007_loan_process","nso007_loan_process.id","nso007_loan_paid.loan_process_id")
            ->join("nso007_loan","nso007_loan.id","nso007_loan_process.loan_id")
            ->join("nso007_client","nso007_client.id","nso007_loan.client_id")
            ->join("nso007_sale_detail_stock","nso007_sale_detail_stock.sale_id","nso007_loan.sale_id")
            ->join("nso007_item_stock","nso007_item_stock.id","nso007_sale_detail_stock.item_id")
            ->join("nso007_project_stock","nso007_project_stock.id","nso007_item_stock.project_id")
            ->join("nso007_category_stock","nso007_category_stock.id","nso007_item_stock.category_id")
            ->join("nso007_sub_category","nso007_sub_category.id","nso007_item_stock.subcategory_id")
            ->join("nso007_sale_stock","nso007_sale_stock.id","nso007_sale_detail_stock.sale_id")
            ->select(
                "nso007_loan_paid.*",
                "nso007_loan.sale_amount",
                "nso007_loan.amount_os",
                "nso007_loan.discount_amount",
                "nso007_loan.id as loan_id",
                "nso007_category_stock.name as category_name",
                "nso007_project_stock.name as project_name",
                "nso007_client.name as client_name",
                "nso007_client.phone as client_phone",
                "nso007_sale_stock.date as sale_date",
                "nso007_sale_stock.sale_receive_amount",
                DB::raw("GROUP_CONCAT(nso007_item_stock.name) as item_name"),
                "nso007_sub_category.name as sub_category_name",
            )
            ->where("nso007_loan_paid.id",$id)
            ->first();

            $data_loanprocess = LoanProcessModel::where("loan_id",$data->loan_id)->where("status",1)->get();

        return view("invoice.client_payment_invoice",compact("data","data_loanprocess"));
    }

    public function get_loan_client_relationship(Request $request){
        $data = LoanClientRelationshipModel::where("loan_id",$request->loan_id)->get();
        $info =[];
        if(count($data)>0){
            foreach ($data as $key => $value) {
                $info[$key]=[
                    'name'=>$value->ClientRelationshipModels->name,
                    'phone'=>$value->ClientRelationshipModels->phone,
                    'type'=>$value->relationship_type
                ];
            }
            return $info;
        }
        else{
            return "Error";
        }
    }
    //    payment description
    public function set_payment_description_return_project_with_des($id)
    {
        $data = DB::select("
            SELECT
            item.name AS item_des,
            lprocess.no AS lpro_des,
            item.project_id as project_id
            FROM nso007_loan_process AS lprocess
            LEFT JOIN nso007_loan AS loan ON lprocess.loan_id = loan.id
            LEFT JOIN nso007_sale_detail_stock AS stock ON loan.sale_id = stock.sale_id
            LEFT JOIN nso007_item_stock AS item ON stock.item_id = item.id
            WHERE lprocess.id = $id
        ");
        // dd("OK");
        $description = $data[0]->item_des . ', Step: ' . $data[0]->lpro_des;
        $data=array(
            'des'=>$description,
            'project_id'=>$data[0]->project_id
        );
        return $data;
    }
    public function item_border($id='',Request $request)
    {
        if($request->isMethod("GET"))
        {

            $loan_data = DB::table("nso007_item_loan_border")->where("loan_id",$id)->first();
            if(empty($loan_data)) return json_encode("empty");
            else return json_encode($loan_data);
        }
        else{
            if(empty(DB::table("nso007_item_loan_border")->where("loan_id",$request->loan_id)->first()))
                DB::table("nso007_item_loan_border")->insert(['border_east'=>$request->border_east,'border_west'=>$request->border_west,'border_south'=>$request->border_south,'border_north'=>$request->border_north,'loan_id'=>$request->loan_id]);

            else DB::table("nso007_item_loan_border")->where("loan_id",$request->loan_id)->update(['border_east'=>$request->border_east,'border_west'=>$request->border_west,'border_south'=>$request->border_south,'border_north'=>$request->border_north]);

            return json_encode("OK");
        }
    }
    public function add_more_contract_information(Request $request){
        $this->validate($request,[
            'loan_id'=>'required'
        ]);
        DB::table("nso007_contract_more_info")->where("loan_id",$request->loan_id)->delete();
        DB::table("nso007_contract_more_info")->insert(['loan_id'=>$request->loan_id,'house_height_description'=>$request->house_height_description,'house_height'=>$request->house_height,'house_street'=>$request->house_street,'date_offer_house'=>(!empty($request->date_offer_house)?date("Y-m-d",strtotime($request->date_offer_house)):null)]);
        return \back()->with("success","successfully!");
    }
    public function get_all_client_for_change($loan_id)
    {
        $data = array(
            'clients'=>ClientModel::where("id","!=",LoanModel::where('id',$loan_id)->first()->client_id)->get(),
            'origin_client'=>ClientModel::where("id",LoanModel::where('id',$loan_id)->first()->client_id)->first()
        );
        return json_encode($data);
    }
    public function loan_client_change_store(Request $request)
    {
        $first_client = "";$installment_date = "";$old_client="";
        $loan = LoanModel::find($request->loan_id);

        $old_client = $loan->client_id;

        $client_pos = LoanModel::where("client_id",$old_client)->where("status",1)->first();
        if(empty($client_pos)) ClientModel::where("id",$old_client)->update(['pos_status'=>0]);

        ClientModel::where("id",$request->new_client_id)->update(['pos_status'=>1]);

        if($loan->client_have_change_status==0){
            $first_client = $loan->client_id;
            $installment_date = $loan->diburment_date;
        }
        else{
            $change_client = DB::table('nso007_changing_client_loan')->where('loan_id',$request->loan_id)->first();
            $first_client = $change_client->first_client_id;
            $installment_date = $change_client->installment_date;
        }

        DB::table('nso007_changing_client_loan')->insert(
            [
                'first_client_id'=>$first_client,
                'installment_date'=>date("Y-m-d",strtotime($installment_date)),
                'loan_id'=>$request->loan_id,
                'curen_client_id'=>$request->new_client_id,
                'date_changed'=>date('Y-m-d',strtotime($request->date)),
                'user_id'=>Auth::user()->id
            ]
        );

        $loan->client_have_change_status=1;
        $loan->client_id = $request->new_client_id;
        $loan->save();

        return json_encode("");
    }
    public function cancel_payment($loan_id,Request $request)
    {
        $loan = DB::table('nso007_loan')->where("id",$loan_id)->first();
        $sale_id = $loan->sale_id;
        $date = !empty($request->date)||$request->date==null?date('Y-m-d',strtotime($request->date)):date('Y-m-d');

        //Update Item Status
        $sale_detail = DB::table('nso007_sale_detail_stock')->where("status",1)->where("sale_id",$sale_id)->get();
        foreach($sale_detail as $value){
            DB::table('nso007_item_stock')->where("id",$value->item_id)->update(['stock_status'=>1,'sale_stock'=>0]);
        }

        $loan_os_amount = $loan->amount_os;

        $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
        /*$journal=new JournalModel;
        $journal->branch_id=0;
        $journal->journal_parentid=0;
        $journal->journal_type=1;
        $journal->journal_acccode=11003;
        $journal->voucher_type=1;
        $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
        $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Payment ';
        $journal->journal_debit= 0;
        $journal->journal_credit=$loan_os_amount;
        $journal->journal_tran_id=$j->last_num+1;
        $journal->journal_transactiondate=date("Y-m-d H:i:s");
        $journal->journal_paydate= $date;
        $journal->journal_currency=1;
        $journal->transaction_type='Cancel Payment';
        $journal->journal_referenceid=$loan_id;
        $journal->journal_by_project=\Globals::return_project_id($sale_id);
        $journal->journal_by=auth()->user()->id;
        $journal->save();*/

        // $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

        $journal=new JournalModel;
        $journal->branch_id=0;
        $journal->journal_parentid=0;
        $journal->journal_type=40000;
        $journal->journal_acccode=41000;
        $journal->voucher_type=1;
        $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
        $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Cancel Payment ';
        $journal->journal_debit=$loan_os_amount;
        $journal->journal_credit=0;
        $journal->journal_tran_id=$j->last_num+1;
        $journal->journal_transactiondate=date("Y-m-d H:i:s");
        $journal->journal_paydate= $date;
        $journal->journal_currency=1;
        $journal->transaction_type='Cancel Payment';
        $journal->journal_referenceid=$loan_id;
        $journal->journal_by_project=\Globals::return_project_id($sale_id);
        $journal->journal_by=auth()->user()->id;
        $journal->save();

        //Delete loan_process
        DB::table("nso007_loan_process")->where("loan_id",$loan_id)->where("status",1)->whereNull("date_paid")->update(['status'=>0]);

        //Set Status Loan
        DB::table('nso007_loan')->where("id",$loan_id)->update(['status'=>0]);

        //Set Status Sale
        DB::table('nso007_sale_stock')->where("id",$sale_id)->update(['status'=>0]);

        return redirect()->route('client-payment.index')->with("success","Cancel payment successfully!");
    }
    public function delete_payment($loan_id){
        $loan = DB::table('nso007_loan')->where("id",$loan_id)->first();
        $sale_id = $loan->sale_id;

        //Set Status Delete Loan Paid
        $loan_process = DB::table("nso007_loan_process")->where("loan_id",$loan_id)->where("status",1)->get();
        foreach($loan_process as $value){
            //Set Status Delete Journal Payment
            $loan_paid =  DB::table('nso007_loan_paid')->where("loan_process_id",$value->id)->first();
            if(!empty($loan_paid)){
                JournalModel::where("journal_referenceid",$loan_paid->id)->where("transaction_type","Payment")->where("journal_status","!=",3)->update(['journal_status'=>3]);
                DB::table('nso007_loan_paid')->where("loan_process_id",$value->id)->where("status",1)->update(['status'=>2]);
            }

        }

        JournalModel::where("journal_referenceid",$sale_id)->where("transaction_type","Convert Income")->where("journal_status","!=",3)->update(['journal_status'=>3]);
        //Delete loan_process
        DB::table("nso007_loan_process")->where("status",1)->where("loan_id",$loan_id)->update(['status'=>2]);

        //Set Status Delete Loan
        DB::table('nso007_loan')->where("status",1)->where("id",$loan_id)->update(['status'=>2]);

        DB::table('nso007_sale_stock')->where("status",1)->where("id",$sale_id)->update(['type'=>1]);
        return redirect()->route('client-payment.index')->with("success","Delete payment successfully!");
    }
    public function add_remark_schedule(Request $request){
        if($request->isMethod("GET")){

        }
        else{
            $this->validate($request,['loan_id'=>'required']);
            DB::table("nso007_schedule_remark")->where("loan_id",$request->loan_id)->delete();
            DB::table('nso007_schedule_remark')->insert(["loan_id"=>$request->loan_id,'remark'=>$request->schedule_remark]);
            return \back()->with("success",'Add Successfully !');
        }
    }
    public function delete_payment_process(){
        if(isset($_GET['id'])){
            $loan_paid_id = $_GET['id'];
            $old_loan_paid = LoanPaidModel::find($loan_paid_id);
            //Update loan process
            $loan_process = LoanProcessModel::find($old_loan_paid->loan_process_id);
            $loan_process->interest_amount_pay = $loan_process->interest_amount_pay + $old_loan_paid->interest;
            $loan_process->principle_pay = $loan_process->principle_pay + $old_loan_paid->principle;
            $loan_process->owe_amount_pay = $loan_process->owe_amount_pay + $old_loan_paid->interest + $old_loan_paid->principle;
            $loan_process->date_paid = null;
            $loan_process->paid_type = 0;
            $loan_process->user_id = null;
            $loan_process->create_date = null;
            $loan_process->save();
            //Update loan
            $loan = LoanModel::find($loan_process->loan_id);
            $sale_price = $loan->sale_amount - $loan->discount_amount;
            $loan->amount_os = $loan->amount_os + $old_loan_paid->principle;
            $loan->percentage_paid =  $loan->percentage_paid - $old_loan_paid->principle*100/$sale_price;
            $loan->save();

            //Delete Journal
            JournalModel::where("journal_referenceid",$loan_paid_id)->where("journal_status","!=",3)->where("transaction_type","Payment")->update(['journal_status'=>3]);
            //Delete loan paid
            $old_loan_paid->status = 2;
            $old_loan_paid->save();
            //Update Commission generate
            \Globals::calculate_commission($loan_process->loan_id);
            return \back()->with("success","Delete successfuly!");
        }
        else{
            return \back()->with("warning","Delete is fail!");
        }
    }
}
