<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProvinceModel;
use Auth;
use DB;
use App\ClientModel;
use DataTables;
use Image;
use Crypt;
use App\User;
use Gate;

class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Client-List', ['only' => ['index','datatable_get_client']]);
         $this->middleware('permission:Client-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Client-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Client-Delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        return view('client.index');
    }
    public function datatable_get_client(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =ClientModel::join("users","users.id","nso007_client.user_id")
                        ->where("nso007_client.status",1)
                        ->where("nso007_client.type",1)
                        ->count();
        $count_filter =ClientModel::join("users","users.id","nso007_client.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_client.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.nick_name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_client.phone' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere("nso007_client.latin_name",'LIKE','%'.$search.'%');
                        })
                        ->where("nso007_client.status",1)
                        ->where("nso007_client.type",1)
                        ->count();

        $clients = ClientModel::with(['get_province','get_district','get_commune','get_village'])->join("users","users.id","nso007_client.user_id")
                            ->select("nso007_client.*")
                            ->orderBy('nso007_client.id','asc')
                            ->where("nso007_client.status",1)
                            ->where("nso007_client.type",1)
                            ->take(20);
        return Datatables::of($clients)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->addColumn('action',function($clients){
                $button="";
                if(Gate::check('Client-Show'))
                    $button.= ' <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#show-client" title="Show" onclick="show_info('.$clients->id.')"><i class="fas fa-eye"></i></button> ';
                if(Gate::check('Client-Edit'))
                    $button.= ' <a href="'.Route("client.edit", Crypt::encrypt($clients->id)).'"  class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';
                if(Gate::check("Client-Delete")){
                    if($clients->delete_status==0){
                        $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($clients->delete_status==1){
                        $button .= ' <button type="button" title="Delete" class="btn btn-sm btn-danger" data-target="#modal-danger'.$clients->id.'" data-toggle="modal"><i class="fa fa-trash"></i></button>
                        <div class="modal fade" id="modal-danger'.$clients->id.'">
                            <form action="'.route("client.delete",$clients->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                        ';
                    }else{

                    }
                }

                return $button;
            })
            ->editColumn('image', function ($clients) {
                if(!empty($clients->image))
                        $url = asset('assets/img/upload/' . $clients->image);
                else $url = asset('assets/img/defaultphoto.png');
                return $url;
            })
            ->editColumn("address",function($clients){
                $location="";
                if(!empty($clients->house_number)) $location.=$clients->house_number;
                if(!empty($clients->street_number)) $location.=" ,".$clients->street_number;
                if(!empty($clients->get_village['village_km'])) $location.="  ភូមិ ".$clients->get_village['village_km'];
                if(!empty($clients->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$clients->get_commune['commune_km'];
                if(!empty($clients->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$clients->get_district['district_km'];
                if(!empty($clients->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$clients->get_province['province_km'];
                return $location;
            })
             ->rawColumns([
                'action' => 'action',
            ])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        return view("client.create",compact('provinces'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'gender'=>'required',
            'date_of_birth'=>'required',
            'phone'=>'required|unique:nso007_client,phone',
            'nationality'=>'required',
            'id_card_number'=>'required|unique:nso007_client,id_card_number',
            'village'=>'required',
            'commune'=>'required',
            'district'=>'required',
            'province'=>'required'
        ]);

        $image = $request->file('photo');
        
        $imagename="";
        if($image){
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($image->getRealPath());
            $img->save($destinationPath.'/'.$input['imagename']);
            $imagename=$input['imagename'];
        }

        $client=new ClientModel;
        $client->name=$request->name;
        $client->gender=$request->gender;
        $client->date_of_birth=date("Y-m-d",strtotime($request->date_of_birth));
        $client->phone=$request->phone;
        $client->email=$request->email;
        $client->nationality=$request->nationality;
        $client->image=$imagename;
        $client->id_card_number=$request->id_card_number;
        if(!empty($request->id_card_date))
            $client->id_card_date=date("Y-m-d",strtotime($request->id_card_date));
        if(!empty($request->id_card_date_valid))
            $client->id_card_date_valid=date("Y-m-d",strtotime($request->id_card_date_valid));
        $client->user_id=Auth::user()->id;
        $client->description=$request->description;
        $client->house_number=$request->house_number;
        $client->street_number=$request->street_number;
        $client->village=$request->village;
        $client->commune=$request->commune;
        $client->district=$request->district;
        $client->province=$request->province;
        $client->delete_status=1;
        $client->status=1;
        $client->date=date("Y-m-d");
        $client->pos_status=0;
        $client->type=1;
        $client->job=$request->job;
        $client->work_place=$request->work_place;
        $client->nick_name=$request->nick_name;
        $client->latin_name = $request->latin_name;
        $client->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        if($request->ajax()){
            return json_encode($client);
        }

        return redirect()->route("client.index")->with("success","Create successfully !");
    }
    public function store_pos_client(Request $request)
    {
        $this->validate($request,[
            'name'=>'required',
            'gender'=>'required',
            'phone'=>'required|unique:nso007_client,phone',
        ]);

        $image = $request->file('photo');
        $imagename="";
        if($image){
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($image->getRealPath());
            $img->resize(150, 150, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['imagename']);
            $imagename=$input['imagename'];
        }

        $client=new ClientModel;
        $client->name=$request->name;
        $client->gender=$request->gender;
        if(!empty($client->date_of_birth))
            $client->date_of_birth=date("Y-m-d",strtotime($request->date_of_birth));
        $client->phone=$request->phone;
        $client->email=$request->email;
        $client->nationality=$request->nationality;
        $client->image=$imagename;
        $client->id_card_number=$request->id_card_number;
        if(!empty($request->id_card_date))
            $client->id_card_date=date("Y-m-d",strtotime($request->id_card_date));
        if(!empty($request->id_card_date_valid))
            $client->id_card_date_valid=date("Y-m-d",strtotime($request->id_card_date_valid));
        $client->user_id=Auth::user()->id;
        $client->description=$request->description;
        $client->house_number=$request->house_number;
        $client->street_number=$request->street_number;
        $client->village=$request->village;
        $client->commune=$request->commune;
        $client->district=$request->district;
        $client->province=$request->province;
        $client->delete_status=1;
        $client->status=1;
        $client->date=date("Y-m-d");
        $client->pos_status=0;
        $client->type=1;
        $client->job=$request->job;
        $client->work_place=$request->work_place;
        $client->nick_name=$request->nick_name;
        $client->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        if($request->ajax()){
            return json_encode($client);
        }

        return redirect()->route("client.index")->with("success","Create successfully !");
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $client=ClientModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return json_encode($client);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $client=ClientModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return view("client.edit",compact('client','provinces'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required',
            'gender'=>'required',
            'date_of_birth'=>'required',
            'phone'=>'required|unique:nso007_client,phone,'.$id,
            'nationality'=>'required',
            'id_card_number'=>'required|unique:nso007_client,id_card_number,'.$id,
            'village'=>'required',
            'commune'=>'required',
            'district'=>'required',
            'province'=>'required'
        ]);

        $client=ClientModel::find($id);

        $photo = $request->file('image');
        $imagename="";
        if($photo){
            $imagename = time().'.'.$photo->getClientOriginalExtension();
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($photo->getRealPath());
            $img->save($destinationPath.'/'.$imagename);
             $client->image=$imagename;
        }else{
            if(empty($request->cpImage))
                $client->image=$imagename;//empty or remove image
        }

        $client->name=$request->name;
        $client->gender=$request->gender;
        $client->date_of_birth=date("Y-m-d",strtotime($request->date_of_birth));
        $client->phone=$request->phone;
        $client->email=$request->email;
        $client->nationality=$request->nationality;
        $client->id_card_number=$request->id_card_number;
        if(!empty($request->id_card_date))
            $client->id_card_date=date("Y-m-d",strtotime($request->id_card_date));
        if(!empty($request->id_card_date_valid))
            $client->id_card_date_valid=date("Y-m-d",strtotime($request->id_card_date_valid));
        $client->description=$request->description;
        $client->house_number=$request->house_number;
        $client->street_number=$request->street_number;
        $client->village=$request->village;
        $client->commune=$request->commune;
        $client->district=$request->district;
        $client->province=$request->province;
        $client->type=1;
        $client->job=$request->job;
        $client->work_place=$request->work_place;
        $client->nick_name=$request->nick_name;
        $client->latin_name = $request->latin_name;
        $client->save();

        return redirect()->route("client.index")->with("success","Update successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        ClientModel::where("id",$id)->delete();
        return \back()->with("success","Delete successfully");
    }
}
