<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ProvinceModel;
use DB;
use App\AgencyModel;
use Auth;
use DataTables;
use Illuminate\Support\Facades\Crypt;
use Image;
use App\User;
use Gate;

class AgencyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Agency-List', ['only' => ['index','datatable_get_agency']]);
         $this->middleware('permission:Agency-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Agency-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Agency-Delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        return view("agencies.index");
    }
    public function get_index()
    {

        $data=AgencyModel::join("users","users.id","nso007_agency.user_id")->get();

    }
    public function datatable_get_agency(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =AgencyModel::join("users","users.id","nso007_agency.user_id")
                    ->where("nso007_agency.status",1)
                    ->count();
        $count_filter =AgencyModel::join("users","users.id","nso007_agency.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_agency.phone' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_agency.id_card_number' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_agency.status",1)
                        ->count();

        $agencies = AgencyModel::with(['get_province','get_district','get_commune','get_village'])->join("users","users.id","nso007_agency.user_id")
                            ->select("nso007_agency.*")
                            ->orderBy('nso007_agency.id','asc')
                            ->where("nso007_agency.status",1)
                            ->take(20);
        return Datatables::of($agencies)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            // ->editColumn('image', function ($agencies) {
            //     if(!empty($agencies->image))
            //             $url = asset('assets/img/upload/' . $agencies->image);
            //     else $url = asset('assets/img/defaultimage.png');
            //     return $url;
            // })
            ->addColumn('action',function($agencies){
                $button="";
                if(Gate::check('Agency-Edit'))
                    $button.= '<a href="'.Route("agency.edit", Crypt::encrypt($agencies->id)).'"  class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a> ';
                if(Gate::check('Agency-Show'))
                $button.= ' <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#show-agencies" title="Show" onclick="show_info('.$agencies->id.')"><i class="fas fa-eye"></i></button> ';
                // $button.= ' <button type="button" title="Press to inactive." class="btn btn-sm btn-primary" data-toggle="modal" data-target="#confirm-inactive" onclick="set_inactive('.$agencies->id.')"><i class="fas fa-user-times"></i></button>';
                if(Gate::check('Agency-Delete')){
                    if($agencies->delete_status==0){
                        $button .= ' <button type="button" disabled title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></button>';
                    }elseif($agencies->delete_status==1){
                        $button .= ' <a data-toggle="modal" href="#modal-danger'.$agencies->id.'" title="Delete" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i></a>
                       
                            <div class="modal fade" id="modal-danger'.$agencies->id.'">
                            <form action="'.route("agencies.delete",$agencies->id).'" method="GET" style="display:inline">
                              <div class="modal-dialog">
                                <div class="modal-content bg-danger">
                                  <div class="modal-header">
                                    <h4 class="modal-title">'.__("application.Delete")." ".__("application.Position").'</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <div class="modal-body">
                                    <p style="font-size: 120%;">'.__("application.Are you sure want to delete this").' ?</p>
                                  </div>
                                  <div class="modal-footer justify-content-between">
                                    <a>&nbsp;</a>
                                    <button type="submit" class="btn btn-default btn-sm fa fa-save"> '.__("application.OK").'</button>
                                  </div>
                                </div>
                                <!-- /.modal-content -->
                              </div>
                              <!-- /.modal-dialog -->
                              </form>
                            </div>
                            <!-- /.modal -->
                         
                        ';
                    }else{

                    }
                }
                return $button;
            })
            ->editColumn("address",function($agencies){
                $location="";
                if(!empty($agencies->house_number)) $location.=$agencies->house_number;
                if(!empty($agencies->street_number)) $location.=" ,".$agencies->street_number;
                if(!empty($agencies->get_village['village_km'])) $location.="  ភូមិ ".$agencies->get_village['village_km'];
                if(!empty($agencies->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$agencies->get_commune['commune_km'];
                if(!empty($agencies->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$agencies->get_district['district_km'];
                if(!empty($agencies->get_province['province_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$agencies->get_province['province_km'];
                return $location;
            })
             ->rawColumns([
                'action' => 'action',
            ])
            ->make(true); 
    }

    public function set_to_inactive(Request $request){
        AgencyModel::where("id",$request->id)->update(['status'=>0]);
        return json_encode("OK");
    }

    public function index_inactive_agency()
    {
        return view('agencies.index_inactive');
    }
    public function datatable_get_agency_inactive(Request $request)
    {
        $search = $request->input('search.value');
        $count_total =AgencyModel::join("users","users.id","nso007_agency.user_id")
                    ->where("nso007_agency.status",0)
                    ->count();
        $count_filter =AgencyModel::join("users","users.id","nso007_agency.user_id")
                        ->where(function($query) use ($search){
                            $query->orWhere('nso007_agency.name' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_agency.phone' , 'LIKE' , '%'.$search.'%');
                            $query->orWhere('nso007_agency.id_card_number' , 'LIKE' , '%'.$search.'%');
                        })
                        ->where("nso007_agency.status",0)
                        ->count();

        $agencies = AgencyModel::with(['get_province','get_district'])->join("users","users.id","nso007_agency.user_id")
                            ->select("nso007_agency.*")
                            ->orderBy('nso007_agency.id','asc')
                            ->where("nso007_agency.status",0)
                            ->take(20);
        return Datatables::of($agencies)
            ->addIndexColumn()
            ->with([
                "recordsTotal" => $count_total,
                 "recordsFiltered" => $count_filter,
              ])
            ->editColumn('image', function ($agencies) {
                if(!empty($agencies->image))
                        $url = asset('assets/img/upload/' . $agencies->image);
                else $url = asset('assets/img/defaultimage.png');
                return $url;
            })
            ->addColumn('action',function($agencies){

                $status= ' <button class="btn btn-info btn-sm" data-toggle="modal" data-target="#show-agencies" title="Show" onclick="show_info('.$agencies->id.')"><i class="fas fa-eye"></i></button> ';
                $status.= ' <button type="button" title="Press to active" class="btn btn-sm btn-success" data-toggle="modal" data-target="#confirm-active" onclick="set_active('.$agencies->id.')"><i class="fas fa-user-check"></i></button>';
                return $status;
            }
)            ->editColumn("address",function($agencies){
                $location="";
                if(!empty($agencies->house_number)) $location.=$agencies->house_number;
                if(!empty($agencies->street_number)) $location.=" ,".$agencies->street_number;
                if(!empty($agencies->get_village['village_km'])) $location.=" ភូមិ ".$agencies->get_village['village_km'];
                if(!empty($agencies->get_commune['commune_km'])) $location.=" ,ឃុំ/សង្កាត់ ".$agencies->get_commune['commune_km'];
                if(!empty($agencies->get_district['district_km'])) $location.=" ,ស្រុក/ខ័ណ្ឌ​ ".$agencies->get_district['district_km'];
                if(!empty($agencies->get_province['provinces_km'])) $location.=" ,ខេត្ត/រាជធានី​ ".$agencies->get_province['provinces_km'];
                return $location;
            })
             ->rawColumns([
                'action' => 'action',
            ])
            ->make(true); 
    }

    public function set_to_active(Request $request){
        AgencyModel::where("id",$request->id)->update(['status'=>1]);
        return json_encode("OK");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        return view("agencies.create",compact('provinces'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name'          => 'required',
            'phone'         => 'required|unique:nso007_agency,phone',
            'dob'           => 'required',
            'nationality'   => 'required',
            'id_card_number'=> 'required|unique:nso007_agency,id_card_number',
            'province'      => 'required',
            'district'      => 'required',
            'commune'       => 'required',
            'village'       => 'required',
        ]);

        $image = $request->file('photo');
        $imagename="";
        if($image){
            $input['imagename'] = time().'.'.$image->getClientOriginalExtension();
     
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($image->getRealPath());
            $img->resize(150, 150, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$input['imagename']);
            $imagename=$input['imagename'];
        }
        
        $agency = new AgencyModel;
        $agency->image = $imagename;
        $agency->name = $request->name;
        $agency->phone = $request->phone;
        $agency->nationality = $request->nationality;
        if(!empty($request->id_card_date))
            $agency->id_card_date = date("Y-m-d",strtotime($request->id_card_date));
        $agency->email = $request->email;
        $agency->street_number = $request->street_number;
        $agency->district = $request->district;
        $agency->village = $request->village;
        $agency->gender = $request->gender;
        if(!empty($request->dob))
            $agency->date_of_birth = date("Y-m-d",strtotime($request->dob));
        $agency->id_card_number = $request->id_card_number;
        if(!empty($request->id_card_date_valid))
            $agency->id_card_date_valid = date("Y-m-d",strtotime($request->id_card_date_valid));
        $agency->house_number = $request->house_number;
        $agency->province = $request->province;
        $agency->commune = $request->commune;
        $agency->description = $request->description;
        $agency->user_id = Auth::user()->id;
        $agency->date = date("Y-m-d");
        $agency->save();

        User::where("id",Auth::user()->id)->update(['status_delete'=>0]);//couldn't delete user

        return redirect()->route("agency.index")->with("success","Agency create sucessfully !");

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $agencies=AgencyModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();
        return json_encode($agencies);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $id=Crypt::decrypt($id);
        $provinces = ProvinceModel::select(
            DB::raw('CONCAT(province_id," ",province_en," ",province_km) AS province_mixed'),'province_id')
            ->pluck('province_mixed','province_id')
            ->prepend('Please Select', '');
        $agencies=AgencyModel::where("id",$id)->with(['get_province','get_district','get_commune','get_village'])->first();

        return view("agencies.edit",compact("provinces",'agencies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'          => 'required',
            'phone'         => 'required|unique:nso007_agency,phone,'.$id,
            'date_of_birth' => 'required',
            'nationality'   => 'required',
            'id_card_number'=> 'required|unique:nso007_agency,id_card_number,'.$id,
            'province'      => 'required',
            'district'      => 'required',
            'commune'       => 'required',
            'village'       => 'required',
        ]);

        $agency = AgencyModel::find($id);

        $photo = $request->file('image');
        $imagename="";
        if($photo){
            $imagename = time().'.'.$photo->getClientOriginalExtension();
            $destinationPath = public_path('/assets/img/upload');
            $img = Image::make($photo->getRealPath());
            $img->resize(150, 150, function ($constraint) {
                $constraint->aspectRatio();
            })->save($destinationPath.'/'.$imagename);
             $agency->image=$imagename;
        }else{
            if(empty($request->cpImage))
                $agency->image=$imagename;//empty or remove image
        }
        $agency->name = $request->name;
        $agency->phone = $request->phone;
        $agency->nationality = $request->nationality;
        if(!empty($request->id_card_date))
            $agency->id_card_date = date("Y-m-d",strtotime($request->id_card_date));
        $agency->email = $request->email;
        $agency->street_number = $request->street_number;
        $agency->district = $request->district;
        $agency->village = $request->village;
        $agency->gender = $request->gender;
        if(!empty($request->date_of_birth))
            $agency->date_of_birth = date("Y-m-d",strtotime($request->date_of_birth));
        $agency->id_card_number = $request->id_card_number;
        if(!empty($request->id_card_date_valid))
            $agency->id_card_date_valid = date("Y-m-d",strtotime($request->id_card_date_valid));
        $agency->house_number = $request->house_number;
        $agency->province = $request->province;
        $agency->commune = $request->commune;
        $agency->description = $request->description;
        $agency->save();

        return redirect()->route("agency.index")->with("success","Update Successfully !");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        AgencyModel::where('id',$id)->delete();
        return \back();
    }
}
