<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\JournalModel;
use App\AccountChartModel;
use App\SupplierModel;
use DB;
use DataTables;
use Auth;
use App\ProjectModel;
use Gate;

class AccountReceiveableController extends Controller
{
    function __construct(){
        $this->middleware('permission:Add-Account-Receiveable', ['only' => ['create','store']]);
        $this->middleware('permission:List-Account-Receiveable', ['only' => ['index']]);
        $this->middleware('permission:Edit-Account-Receiveable', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete-Account-Receiveable', ['only' => ['delete']]);
    }
    public function index(Request $request)
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",11003)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $projects = ProjectModel::select(
            DB::raw('CONCAT(" ",name) AS project'),
            'id'
        )
            ->pluck('project', 'id');
        if($request->ajax()){
            if($request->isMethod('get')){
                $project_id = $request->project_id;
                $start_date = $request->start_date;
                $end_date   = $request->end_date;
                $last_months = $request->last_months;
                $voucher_ref = $request->voucher_ref;
                $journal_acccode = $request->journal_acccode;
                $supplier = $request->supps_id;
                $description = $request->description;
                $count_total = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->join('construction_supplier as supplier','supplier.id','=', 'jn.journal_by_supplier')
                                ->select(
                                    'chart.acc_name',
                                    'supplier.supp_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status",0)

                                ->where("code",11003)

                                ->where("chart.code",11003)
                                ->where("jn.transaction_type","Acc-Receiveable")
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();
                $count_filter = DB::table('nso007_journal as jn')
                                ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                                ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                                ->join('construction_supplier as supplier','supplier.id','=', 'jn.journal_by_supplier')
                                ->select(
                                    'chart.acc_name',
                                    'supplier.supp_name',
                                    'chart.code as account_code',
                                    'jn.id',
                                    'jn.journal_des',
                                    'jn.journal_debit',
                                    'jn.journal_credit',
                                    'jn.journal_invoice',
                                    'jn.journal_paydate',
                                    'jn.voucher_type',
                                    'jn.voucher_ref',
                                    'jn.journal_status',
                                    'project.name as project_name',
                                    'jn.journal_tran_id as tran_id'
                                )
                                ->where("journal_status",0)

                                ->where("code",11003)

                                ->where("chart.code",11003)

                                ->where(function($query) use ($project_id){
                                    if(!empty($project_id)){
                                        $query->whereIn("jn.journal_by_project",$project_id);
                                    }
                                })
                                ->where(function($query) use ($start_date,$end_date){
                                    if(!empty($start_date)&&!empty($end_date)){
                                        $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                    }
                                })
                                ->where(function($query) use ($last_months){
                                    if(!empty($last_months)){
                                        $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                    }
                                })
                                ->where(function($query) use ($voucher_ref){
                                    if(!empty($voucher_ref)){
                                        $query->where("jn.voucher_ref",$voucher_ref);
                                    }
                                })
                                ->where(function($query) use ($journal_acccode){
                                    if(!empty($journal_acccode)){
                                        $query->whereIn("jn.journal_acccode",$journal_acccode);
                                    }
                                })
                                ->where(function($query) use($description){
                                    if(!empty($description))
                                        $query->where("jn.journal_des","LIKE","%".$description."%");
                                })
                                ->where(function($query) use ($supplier){
                                    if(!empty($supplier)){
                                        $query->whereIn('jn.journal_by_supplier',$supplier);
                                    }
                                })
                                ->where(function($query) use ($description){
                                    if(!empty($description)){
                                        $query->where("jn.journal_des","LIKE","%".$description."%");
                                    }
                                })
                                ->where("jn.transaction_type","Acc-Receiveable")
                                ->orderBy("jn.journal_paydate","DESC")
                                ->count();

                $data = DB::table('nso007_journal as jn')
                            ->join('nso007_account_chart as chart', 'chart.code', '=', 'jn.journal_acccode')
                            ->leftjoin('nso007_project_stock as project', 'project.id', '=', 'jn.journal_by_project')
                            ->join('construction_supplier as supplier','supplier.id','=', 'jn.journal_by_supplier')
                            ->select(
                                'chart.acc_name',
                                'supplier.supp_name',
                                'chart.code as account_code',
                                'jn.id',
                                'jn.journal_des',
                                'jn.journal_debit',
                                'jn.journal_credit',
                                'jn.journal_invoice',
                                'jn.journal_paydate',
                                'jn.voucher_type',
                                'jn.voucher_ref',
                                'jn.journal_status',
                                'project.name as project_name',
                                'jn.journal_tran_id as tran_id',
                                'jn.delete_status',
                                'jn.receiveable_paid'
                            )
                            ->where("journal_status",0)

                            ->where("code",11003)

                            ->where("chart.code",11003)

                            ->where(function($query) use ($project_id){
                                if(!empty($project_id))
                                    $query->whereIn("jn.journal_by_project",$project_id);
                            })
                            ->where(function($query) use ($start_date,$end_date){
                                if(!empty($start_date)&&!empty($end_date)){
                                    $query->whereBetween("jn.journal_paydate",[date("Y-m-d",strtotime($start_date)),date("Y-m-d",strtotime($end_date))]);
                                }
                            })
                            ->where(function($query) use ($last_months){
                                if(!empty($last_months)){
                                    $query->whereBetween("jn.journal_paydate",\Globals::the_last_month($last_months));
                                }
                            })
                            ->where(function($query) use ($voucher_ref){
                                if(!empty($voucher_ref)){
                                    $query->where("jn.voucher_ref",$voucher_ref);
                                }
                            })
                            ->where(function($query) use ($journal_acccode){
                                if(!empty($journal_acccode)){
                                    $query->whereIn("jn.journal_acccode",$journal_acccode);
                                }
                            })
                            ->where(function($query) use($description){
                                if(!empty($description))
                                    $query->where("jn.journal_des","LIKE","%".$description."%");
                            })
                            ->where(function($query) use ($supplier){
                                if(!empty($supplier)){
                                    $query->whereIn('jn.journal_by_supplier',$supplier);
                                }
                            })
                            ->where(function($query) use ($description){
                                if(!empty($description)){
                                    $query->where("jn.journal_des","LIKE","%".$description."%");
                                }
                            })
                            ->where("jn.transaction_type","Acc-Receiveable")
                            ->orderBy("jn.journal_paydate","DESC")
                            ->take(20);
                            
            return DataTables::of($data)
                ->addIndexColumn()
                ->with([
                    "recordsTotal" => $count_total,
                    "recordsFiltered" => $count_filter,
                ])
                ->editColumn('voucher', function ($data) {
                    $voucher = "";
                    if ($data->voucher_type == 1) {
                        $voucher = "Cash Receipt";
                    } else if ($data->voucher_type == 2) {
                        $voucher = "Cash Disbursement";
                    } else if ($data->voucher_type == 3) {
                        $voucher = "Cash Reimbursement";
                    } else if ($data->voucher_type == 4) {
                        $voucher = "Cash Advance";
                    } else if ($data->voucher_type == 5) {
                        $voucher = "Advance Settlement";
                    } else if ($data->voucher_type == 6) {
                        $voucher = "Journal Entry/Adjustment";
                    }
                    return $voucher;
                })
                ->editColumn('account_code', function ($data) {
                    return $data->account_code . " " . $data->acc_name;
                })
                ->editColumn('journal_paydate',function($data){
                    return date("d-m-Y",strtotime($data->journal_paydate));
                })
                ->editColumn('receiveable_paid',function($data){
                    return "$".number_format($data->receiveable_paid,2);
                })
                ->editColumn('journal_debit',function($data){
                    return "$".number_format($data->journal_debit,2);
                })
                ->addColumn('balance',function($data){
                    return "$".number_format(($data->journal_debit - $data->receiveable_paid),2);
                })
                ->addColumn('action',function($data){
                    $btn_edit = '';
                    $btn_delete = '';
                    $btn_doprocess = '';
                    $btn_doprocess_view = '';
                    if($data->journal_status==0){
                            $btn_doprocess = '<a href="'.route('account_receiveable.get_pay',$data->id).'" class="btn btn-sm btn-info"><i class="fa fa-dollar-sign"></i></a> ';
                        if($data->receiveable_paid>0){
                            $btn_doprocess_view = '<a href="javascript:void(0)" onclick = "view_get_paid('.$data->id.')" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a> ';
                        }
                        if(Gate::check('Edit-Account-Receiveable'))
                            $btn_edit.= '<a href="'.route('account_receiveable.edit',$data->id).'" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a> ';
                        if(Gate::check('Delete-Account-Receiveable'))
                            if($data->delete_status==1){
                                $btn_delete.= '<a href="javascript:void(0)" data-id="'.$data->id.'" onclick="delete_account_receiveable('.$data->id.')" class="btn btn-sm btn-danger "><i class="fa fa-trash"></i></a>';
                            }
                    }
                    return $btn_doprocess.$btn_doprocess_view.$btn_edit.$btn_delete;
                })
                ->rawColumns(['action' => 'action'])
                ->make(true);
            }
        }
        $supps = DB::table('construction_supplier')->select(
            DB::raw('CONCAT(supp_name," | ",supp_phone) AS supplier'),'id')
            ->pluck('supplier','id');
        return view('accounting.account-receiveable.index', ['acc_code' => $acc_code,'projects' => $projects,'supps'=> $supps]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",11003)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $supplier = SupplierModel::select('supp_name','id')->pluck('supp_name','id')->prepend("Please Select");
        return view('accounting.account-receiveable.create',compact('acc_code','supplier'));
    }
    public function get_pay($id){
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",11003)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
        $data = JournalModel::find($id);
    $supplier = SupplierModel::select('supp_name','id')->pluck('supp_name','id')->prepend("Please Select");
        return view('accounting.account-receiveable.form_pay',compact('acc_code','id','data','supplier'));
    }
    public function save_pay(Request $request){
        $this->validate($request,[
            'receiveable_id'=>'required',
            'cash_type'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required',
            'journal_acccode'=>'required',
        ]);
        $journal = JournalModel::find($request->receiveable_id);
        $journal->receiveable_paid = $journal->receiveable_paid + $request->amount;
        $journal->delete_status = 0;
        $journal->save();
        $max            = JournalModel::max('journal_tran_id');
        $max_invoice_num = JournalModel::max('receiveable_receipt_num');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        $income = new JournalModel;
        $income->journal_parentid = 0;
        $income->journal_type = 40000;
        $income->journal_acccode = $request->journal_acccode;
        $income->voucher_type = 1;
        $income->voucher_ref = $voucher_ref;
        $income->journal_des = $request->description;
        $income->journal_by_supplier = $request->journal_by_supplier;
        $income->journal_debit = 0;
        $income->journal_credit = $request->amount;
        $income->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $income->journal_by = Auth::user()->id;
        $income->journal_transactiondate = date('Y-m-d H:i:s');
        $income->journal_tran_id = $journal_tran_id;
        $income->journal_by_project = $journal->journal_by_project;
        $income->journal_status= 0;
        $income->person_name = $request->person_name;
        $income->journal_referenceid = $request->receiveable_id;
        $income->transaction_type = "Acc-Receiveable-Payment";
        $income->ref_account_chart = $request->journal_acccode;
        $income->receiveable_receipt_num = $max_invoice_num+1;
        $income->save();

        $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();
        $cash = new JournalModel;
        $cash->journal_parentid = $jj->last_id;
        $cash->journal_type = 10000;
        $cash->journal_acccode = $request->cash_type;
        $cash->voucher_type = 1;
        $cash->voucher_ref = $voucher_ref;
        $cash->journal_des = $request->description;
        $income->journal_by_supplier = $request->journal_by_supplier;
        $cash->journal_debit = $request->amount;
        $cash->journal_credit = 0;
        $cash->journal_paydate = date("Y-m-d",strtotime($request->journal_paydate));
        $cash->journal_by = Auth::user()->id;
        $cash->journal_transactiondate = date('Y-m-d H:i:s');
        $cash->journal_tran_id = $journal_tran_id;
        $cash->journal_by_project = $journal->journal_by_project;
        $cash->journal_status= 0;
        $cash->person_name = $request->person_name;
        $cash->transaction_type = "Acc-Receiveable-Payment";
        $cash->ref_account_chart = $request->journal_acccode;
        $cash->journal_referenceid = $request->receiveable_id;
        $cash->receiveable_receipt_num = $max_invoice_num+1;
        $cash->save();

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('account_receiveable.index')->with("success","Create Successfully!");
    }
    public function get_view_paid($receiveable_id){
        $data = JournalModel::leftJoin("nso007_account_chart","nso007_account_chart.code","nso007_journal.ref_account_chart")
            ->where("transaction_type","Acc-Receiveable-Payment")
            ->whereIn('journal_acccode',['11001','11002'])
            ->where("journal_referenceid",$receiveable_id)
            ->select("nso007_journal.*",DB::raw("DATE_FORMAT(nso007_journal.journal_paydate, '%d-%m-%Y') as paid_date"),"nso007_account_chart.acc_name")
            ->get();
        return json_encode($data);
    }
    public function print_invoice($id){
        $data = JournalModel::find($id);
        return view('accounting.account-receiveable.print_invoice',compact('data'));
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'amount'=>'required',
        ]);

        $max            = JournalModel::max('journal_tran_id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;

        $max_tran_journal   = JournalModel::max('journal_tran_id');
        if (!$max_tran_journal) {
            $max_tran_journal = 0;
        }
        $journal_tran_id = $max_tran_journal + 1;

        JournalModel::insert([
            'journal_parentid'          => 0,
            'journal_type'              => 10000,
            'journal_acccode'           => $request->journal_acccode,
            'voucher_type'              => 1,
            'voucher_ref'               => $voucher_ref,
            'journal_des'               => $request->description,
            'journal_debit'             => $request->amount,
            'journal_by_supplier'       => $request->supplier,
            'journal_credit'            => 0,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by'                => Auth::user()->id,
            'journal_invoice'           => "",
            'journal_transactiondate'   => date('Y-m-d H:i:s'),
            'journal_tran_id'           => $journal_tran_id,
            'journal_by_project'        => $request->journal_by_project,
            'journal_status'           => 0,
            'transaction_type'         => "Acc-Receiveable"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('account_receiveable.index')->with("success","Create Successfully!");
    }

    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        $data = JournalModel::find($id);
        $acc_code       = AccountChartModel::select('code',DB::raw('CONCAT(code," ",acc_name) AS account_mixed'))
            ->where("code",11003)
            ->pluck('account_mixed', 'code')
            ->prepend('Please Select', '');
            $supplier = SupplierModel::select('supp_name','id')->pluck('supp_name','id')->prepend("Please Select");
        return view('accounting.account-receiveable.edit',compact('data','acc_code','supplier'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'journal_acccode'=>'required',
            'journal_by_project'=>'required',
            'journal_paydate'=>'required',
            'journal_debit'=>'required',
        ]);

        JournalModel::where("id",$id)->update([
            'journal_acccode'           => $request->journal_acccode,
            'journal_des'               => $request->description,
            'journal_debit'            => $request->journal_debit,
            'journal_by_supplier'     => $request->journal_by_supplier,
            'journal_paydate'           => date("Y-m-d",strtotime($request->journal_paydate)),
            'journal_by_project'        => $request->journal_by_project,
            // 'transaction_type'         => "Acc-Receiveable"
        ]);

        \Globals::set_account_status($request->journal_acccode);

        return redirect()->route('account_receiveable.index')->with("success","Update Successfully!");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete()
    {
        $journal_id = $_GET['id'];
        JournalModel::find($journal_id)->delete();
        return redirect()->route('account_receiveable.index')->with("success","Delete Successfully!");
    }
    public function paid_delete(){
        $journal_id = $_GET['id'];
        $journal = JournalModel::find($journal_id);
        $parent_journal = JournalModel::find($journal->journal_referenceid);
        $parent_journal->receiveable_paid = $parent_journal->receiveable_paid - $journal->journal_debit;
        if($parent_journal->receiveable_paid<=0)
            $parent_journal->delete_status = 1;
        $parent_journal->save();
        JournalModel::where("journal_tran_id",$journal->journal_tran_id)->where("transaction_type","Acc-Receiveable-Payment")->delete();
        return redirect()->route('account_receiveable.index')->with("success","Delete Successfully!");
    }
    public function destroy($id)
    {
        //
    }
}
