<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountChartModel;
use App\AccountTypeModel;
use DataTables;
use DB;
use Gate;

class AccountChartController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
         $this->middleware('permission:Account-Chart-List', ['only' => ['index']]);
         $this->middleware('permission:Account-Chart-Create', ['only' => ['create','store']]);
         $this->middleware('permission:Account-Chart-Edit', ['only' => ['edit','update']]);
         $this->middleware('permission:Account-Chart-Delete', ['only' => ['confirm_delete']]);
    }


    public function index()
    {
        $account_chart = DB::select("SELECT nso007_account_chart.*,nso007_account_type.acctype_name FROM `nso007_account_chart`
        LEFT JOIN nso007_account_type
        ON nso007_account_type.id = nso007_account_chart.type_id ORDER BY nso007_account_chart.id");
        return view('accounting.account-chart.index',compact('account_chart'));
    }

    public function create()
    {
        $account_type = AccountTypeModel::select(
            DB::raw('CONCAT(id," ",acctype_name) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        return view('accounting.account-chart.create',compact('account_type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'acctype'      => 'required',
            'acc_type_name' => 'required',
            'acc_name'      => 'required',
            'acc_namekh'     => 'required',
        ]);
        $acc_type_name = $request->acc_type_name ? $request->acc_type_name : null;
        $accounttype = $request->accounttype ? $request->accounttype : null;
        $acc_num = $request->acc_num;
        $sub_acc = 0;
        if(!empty($accounttype))
        {
            $acc_type_name = $accounttype;
            $sub_acc = 1;
        }
        try
        {
            DB::beginTransaction();
            $data = array(
                'code' => $acc_num,
                'acc_name' => $request->acc_name,
                'type_id' =>  $request->acctype,
                'acctype' =>  $acc_type_name,
                'acc_namekh' => $request->acc_namekh,
                'acc_des' => $request->acc_des,
                'acc_delete' => 1,
                'acc_status' => 1,
                'sub_acc' => $sub_acc,
            );
            AccountChartModel::insert($data);
            DB::commit();
            return redirect()->route('account-chart.index')
                ->with('success','Account Chart created successfully');
        }
        catch (\Exception $e)
        {
            DB::rollback();
            return $e->getMessage();
        }
    }
    public function get_account_code(Request $request)
    {
        $account_code = $request->account_code;
        $acc_type = $request->acc_type;

        $account_chart = AccountChartModel::where('acctype',$account_code)->get();
        $acc_num = 0;
        if($acc_type != null)
        {
            if(substr($acc_type,0,1) =="3"||substr($acc_type,0,1)=="4"||substr($acc_type,0,1)=="5"||substr($acc_type,0,1)=="1"||substr($acc_type,0,1)=="2"){
                $sub_acc = substr($acc_type,0,1);
                $account_num = AccountChartModel::where(DB::raw('substr(acctype,1,1)'),'=',$sub_acc)->orderBy('id','desc')->first();
            }
            else{
                $sub_acc = substr($acc_type,0,2);
                $account_num = AccountChartModel::where(DB::raw('substr(acctype,1,2)'),'=',$sub_acc)->orderBy('id','desc')->first();
            }
            $acc_num = $account_num->id ? $account_num->id + 1 : '';
        }
        $data = array('acc_chart' => $account_chart ,'acc_num' => $acc_num);
        echo json_encode($data);
    }
    public function edit($id)
    {
        $result['data']     = AccountChartModel::findOrFail($id);
        $result['parent']   = AccountChartModel::where([['type_id',$result['data']->type_id],['id','!=',$id]])->select(DB::raw('concat(code,". ",acc_name," / ",acc_namekh) name,id'))->pluck('name','id');
        $level              = 1;
        $options            = '';
        $accounts           = AccountChartModel::where([['acctype',null],['type_id',$result['data']->type_id]])->get();
        foreach($accounts as $key => $account){
            $item['id']                 = $account->id;
            $item['text']               = $account->code." ".$account->acc_name." ".$account->acc_namekh;
            $item['level']              = 'l'.$level;
            $options .= '<option value="'.$item['id'].'" class="'.$item['level'].'">'.$item['text'].'</option>';
            if($account->children->count() > 0){
                $options .= $this->sub_option($account,$level);
            }
        }
        $result['parent'] = $options;
        $account_type = AccountTypeModel::select(
            DB::raw('CONCAT(id," ",acctype_name) AS account_mixed'),'id')
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
//        dd($result['data']);
        return view('accounting.account-chart.edit',compact('result','account_type'));
    }
    public function sub_option($account,$level){
        $accounts   = $account->children;
        $level++;
        $options    = '';
        foreach($accounts as $key => $account){
            $item['id']                 = $account->id;
            $item['text']               = $account->code." ".$account->acc_name." ".$account->acc_namekh;
            $item['level']              = 'l'.$level;
            $options .= '<option value="'.$item['id'].'" class="'.$item['level'].'">'.$item['text'].'</option>';
            if($account->children->count() > 0){
                $options .= $this->sub_option($account,$level);
            }
            if($key == count($accounts)-1){
                $level -=1;
            }
        }
        return $options;
    }
    public function confirm_delete(Request $request)
    {
        $delete_acc = AccountChartModel::findOrFail($request->delete_id);
        $delete_acc->delete();
        return response()->json(['success' => true,'message' => 'Account chart deleted']);
    }
    public function update(Request $request,$id)
    {
        $acc_type_name = $request->acc_type_name ? $request->acc_type_name : null;
        $accounttype = $request->accounttype ? $request->accounttype : null;
        $sub_acc = 0;
        if(!empty($accounttype))
        {
            $acc_type_name = $accounttype;
            $sub_acc = 1;
        }
       $account = AccountChartModel::findOrFail($id);
       $account->acc_name = $request->acc_name;
       $account->acc_namekh = $request->acc_namekh;
       $account->acc_des = $request->acc_des;
       $account->type_id = $request->acctype;
       $account->acctype = $acc_type_name;
       $account->code = $request->code;
       $account->save();
        return redirect()->route('account-chart.index')
            ->with('success','Account Chart updated successfully');
    }
}
