<?php


namespace App\Helpers;

use Request;
// use Phanna\Converter\KhmerDatetime;
use KhmerDateTime\KhmerDateTime;
use App\User;
use App\JournalModel;
use App\AccountChartModel;
use App\ProjectModel;
use App\AccountTypeModel;
use DB;
class Globals

{
    public static function this_week(){
        $firstday = date('d-m-Y', strtotime("this week"));
        $Last_date = date_create('this week +6 days')->format('Y-m-d');
        return [date("Y-m-d",strtotime($firstday)),$Last_date];
    }
    public static function filter_date(){
        $data = array(""=>'Please Select',"1"=>'Today','2'=>'This Week');
        return $data;
    }
    public static function last_month_count(){
        $data = array(
            '1'=>__("application.1 last months"),
            '2'=>__("application.2 last months"),
            '3'=>__("application.3 last months"),
            '4'=>__("application.4 last months"),
            '5'=>__("application.5 last months"),
            '6'=>__("application.6 last months"),
            '7'=>__("application.7 last months"),
            '8'=>__("application.8 last months"),
            '9'=>__("application.9 last months"),
            '10'=>__("application.10 last months"),
            '11'=>__("application.11 last months"),
            '12'=>__("application.12 last months"),
        );
        return $data;
    }
    public static function the_last_month($last_count){
        $first = date("Y-m-d", strtotime( date( "Y-m-d", strtotime( date("Y-m")."-01") ) . "-".($last_count-1)." month" ) );
        $last = date("Y-m-d");
        $data = [$first,$last];
        return $data;
    }
    public static function get_supplier(){
        $suppliers = DB::table("construction_supplier")->select("id",DB::raw("CONCAT(supp_name,' | ',supp_phone) as supplier_name"))->pluck("supplier_name","id");
        return $suppliers;
    }
    public static function cash_type(){
        $data = array(
            "11001"=>'Cash On Hand',
            '11002'=>'Cash In Bank'
        );
        return $data;
    }
    public static function get_account_type($acctype_group=""){
        $account_type = AccountTypeModel::select(
            DB::raw('CONCAT(id," ",acctype_name) AS account_mixed'),'id')
            ->where(function($query) use ($acctype_group){
                if(!empty($acctype_group)){
                    $query->where("acctype_group",$acctype_group);
                }
            })
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        return $account_type;
    }
    public static function set_account_status($account){
        AccountChartModel::where("id",$account)->update(['acc_status'=>0]);
    }
    public static function get_account_code($acctype_group="",$prepend_status = 1){

        if($prepend_status==0){
            $data =  AccountChartModel::select('code', DB::raw('CONCAT(code," ",acc_name) as acc_name'))
            ->where('type_id',"LIKE",$acctype_group."%")
            ->pluck('acc_name', 'code');
        }
        else{
            $data =  AccountChartModel::select('code', DB::raw('CONCAT(code," ",acc_name) as acc_name'))
            ->where('type_id',"LIKE",$acctype_group."%")
            ->pluck('acc_name', 'code')
            ->prepend('Please Select', '');
        }
        return $data;
    }
    public static function get_project(){
        $projects = ProjectModel::select('name', 'id')
                    ->pluck('name', 'id')
                    ->prepend('Please Select', '');
        return $projects;
    }
    public static function readnumber_stringtokhmer($string){
        $string = strval($string);
        $final_string = "";
        for($i=0;$i<strlen($string);$i++){
            $value = $string[$i];
            if($value=="1") $final_string .= "១";
            elseif($value=="2") $final_string .= "២";
            elseif($value=="3") $final_string .= "៣";
            elseif($value=="4") $final_string .= "៤";
            elseif($value=="5") $final_string .= "៥";
            elseif($value=="6") $final_string .= "៦";
            elseif($value=="7") $final_string .= "៧";
            elseif($value=="8") $final_string .= "៨";
            elseif($value=="9") $final_string .= "៩";
            elseif($value=="0") $final_string .= "០";
            else $final_string .= $value;
        }
        return $final_string;
    }
    public static function bank_name(){
        $data = DB::table('nso007_bank')->where("status",1)->select("id","name")->pluck("name","id");
        return $data;
    }
    public static function set_status_cannot_delete_bank($bank_id){
        return DB::table('nso007_bank')->where("id",$bank_id)->update(['delete_status'=>0]);
    }
    /*public  static function date_khmer_get_word($date){
        $khmer = new KhmerDatetime($date);
        $month = $khmer->getFullMonth();
        $year = $khmer->getFullYear();
        $day = $khmer->getFullDay();

        $dd = date("D",strtotime($date));
        $d="";
        if($dd=="Mon") $d = "ច័ន្ទ";
        else if($dd=="Tue") $d = "អង្គារ";
        else if($dd=="Wed") $d = "ពុធ";
        else if($dd=="Thu") $d = "ព្រ.ហ";
        else if($dd=="Fri") $d = "សុក្រ";
        else if($dd=="Sat") $d = "សៅរ៍";
        else if($dd=="Sun") $d = "អាទិត្យ";
        else $d = "";

        $new_date = 'ថ្ងៃ'.$d.' ទី'.$day." ខែ". $month ." ឆ្នាំ ".$year;

        return $new_date;
    }*/
    public  static function date_khmer_get_word($date){
        $khmer =  KhmerDateTime::parse($date);
        $month = $khmer->fullMonth();
        $year = $khmer->year();
        $day = $khmer->day();

        $dd = date("D",strtotime($date));
        $d="";
        if($dd=="Mon") $d = "ច័ន្ទ";
        else if($dd=="Tue") $d = "អង្គារ";
        else if($dd=="Wed") $d = "ពុធ";
        else if($dd=="Thu") $d = "ព្រ.ហ";
        else if($dd=="Fri") $d = "សុក្រ";
        else if($dd=="Sat") $d = "សៅរ៍";
        else if($dd=="Sun") $d = "អាទិត្យ";
        else $d = "";

        $new_date = 'ថ្ងៃ'.$d.' ទី'.$day." ខែ". $month ." ឆ្នាំ ".$year;

        return $new_date;
    }
    public static function convert_to_income($loan_id,$date,$project_id)
    {
        $data_loan = DB::table("nso007_loan")->where("id",$loan_id)->first();
        if(empty($data_loan)) return 0;
        else{
            // if($data_loan->loan_convert_to_income_status==0&&$data_loan->condition_convert_to_income<=$data_loan->percentage_paid){
            if($data_loan->loan_convert_to_income_status==0){
                $sale_id = $data_loan->sale_id;
                $j=JournalModel::select(DB::raw("Max(journal_tran_id) as last_num"))->first();
                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=0;
                $journal->journal_type=40000;
                $journal->journal_acccode=41000;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Sale Income';
                $journal->journal_debit=0;
                $journal->journal_credit=$data_loan->sale_amount;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate=date("Y-m-d",strtotime($date));
                $journal->journal_currency=1;
                $journal->transaction_type='Convert Income';
                $journal->journal_referenceid=$sale_id;
                $journal->journal_by_project=$project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                if($data_loan->discount_amount>0){
                    $jj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                    $journal=new JournalModel;
                    $journal->branch_id=0;
                    $journal->journal_parentid=$jj->last_id;
                    $journal->journal_type=40000;
                    $journal->journal_acccode=41002;
                    $journal->voucher_type=1;
                    $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                    $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Sale Discount';
                    $journal->journal_debit=$data_loan->discount_amount;
                    $journal->journal_credit=0;
                    $journal->journal_tran_id=$j->last_num+1;
                    $journal->journal_transactiondate=date("Y-m-d H:i:s");
                    $journal->journal_paydate = date("Y-m-d",strtotime($date));
                    $journal->journal_currency=1;
                    $journal->transaction_type='Convert Income';
                    $journal->journal_referenceid= $sale_id;
                    $journal->journal_by_project=$project_id;
                    $journal->journal_by=auth()->user()->id;
                    $journal->save();
                }

                $jjj=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$jjj->last_id;
                $journal->journal_type=20000;
                $journal->journal_acccode=21003;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Unearned Revenues';
                $journal->journal_debit=($data_loan->sale_amount - $data_loan->discount_amount - $data_loan->amount_os);
                $journal->journal_credit=0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate = date("Y-m-d",strtotime($date));
                $journal->journal_currency=1;
                $journal->transaction_type='Convert Income';
                $journal->journal_referenceid= $sale_id;
                $journal->journal_by_project=$project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();

                $aa=JournalModel::select(DB::raw("Max(id) as last_id"))->first();

                $journal=new JournalModel;
                $journal->branch_id=0;
                $journal->journal_parentid=$aa->last_id;
                $journal->journal_type=10000;
                $journal->journal_acccode=11003;
                $journal->voucher_type=1;
                $journal->voucher_ref="V-".\Globals::generate_voucher_number(($j->last_num+1),8);
                $journal->journal_des=\Globals::DescriptionBySaleID("", $sale_id).' Account Receivable';
                $journal->journal_debit= $data_loan->amount_os;
                $journal->journal_credit=0;
                $journal->journal_tran_id=$j->last_num+1;
                $journal->journal_transactiondate=date("Y-m-d H:i:s");
                $journal->journal_paydate = date("Y-m-d",strtotime($date));
                $journal->journal_currency=1;
                $journal->transaction_type='Convert Income';
                $journal->journal_referenceid= $sale_id;
                $journal->journal_by_project=$project_id;
                $journal->journal_by=auth()->user()->id;
                $journal->save();


                DB::table("nso007_loan")->where("id",$loan_id)->update(['loan_convert_to_income_status'=>1]);

                return 1;

            }
            else return 0;
        }
    }
    public static function calculate_commission($sale_id)
    {

        $sale_data = DB::table('nso007_sale_stock')->where("id",$sale_id)->first();
        if($sale_data->commission_status==0) return;

        // $paid_amount = $loan_data->sale_amount - $loan_data->discount_amount - $loan_data->amount_os;
        // $paid_percentage = $loan_data->percentage_paid;

        $commission_data = DB::table('nso007_commission')->where('sale_id',$sale_id)->first();

        $withdraw_amount = $commission_data->amount_withdraw;
        $amount_available = $commission_data->amount_available;
        $commission_amount = $commission_data->commission_amount;

        $commission_condition = DB::table('nso007_sale_commission_condition')->where('sale_id',$sale_id)->orderBy('commission_condition')->get();
        foreach ($commission_condition as $key => $value) {
            if($value->commission_type == 1 && $sale_data->type==1 ){
                if($sale_data->sale_receive_amount>=$value->commission_condition){
                    $amount_available = $value->can_withdraw_condion - $withdraw_amount;
                }
            }else if($value->commission_type == 2 && $sale_data->type==2 ){
                $amount_available = $amount_available + $value->can_withdraw_condion;
            }else{}
        }

        if($amount_available >= $commission_amount) $amount_available = $commission_amount - $withdraw_amount;

        DB::table('nso007_commission')->where('sale_id',$sale_id)->update(['amount_available'=>$amount_available]);
    }
    public static function LatinnumberTokhnumber($number)
    {
        $number = str_split($number);
        $map = array(
            '១' => 1,
            '២' => 2,
            '៣' => 3,
            '៤' => 4,
            '៥' => 5,
            '៦' => 6,
            '៧' => 7,
            '៨' => 8,
            '៩' => 9,
            '០' => 0
        );
        $returnValue = '';
        foreach ($number as $num => $numb) {
            foreach ($map as $key => $khnumber) {
                if ($numb == $khnumber) {
                    $returnValue .= $key;
                }
            }
        }

        return $returnValue;
    }
    /*public static function date_khmers($date)
    {
      $khmer = new KhmerDatetime($date);
      $month = $khmer->getFullMonth();
      $year = $khmer->getFullYear();
      $day = $khmer->getFullDay();
      $new_date = $day." ខែ ". $month ." ឆ្នាំ ".$year;
      return $new_date;
    }*/
    public static function date_khmers($date)
    {
      $khmer = $dateTime = KhmerDateTime::parse($date);
      $month = $khmer->fullMonth();
      $year = $khmer->year();
      $day = $khmer->day();
      $new_date = $day." ខែ ". $month ." ឆ្នាំ ".$year;
      return $new_date;
    }

    // public static function increase_employee()
    // {
    //    $increase = '';
    //     $last_id=User::select('user_year')->get()->last();
    //     $cur_year = date('Y');
    //     if($last_id){
    //         $count = User::where('user_year',date('Y'))->where('user_type',1)->count();
    //         $old_year = $last_id->user_year?$last_id->user_year:date('Y');
    //         if($old_year==$cur_year){
    //            return $increase = 'EM141019'.$cur_year.''.sprintf('%05d', ($count+1));
    //         }
    //         if($old_year!=$cur_year){
    //            return $increase = 'EM141019'.$cur_year.'0001';
    //         }
    //     }else{
    //         return $increase = 'EM141019'.$cur_year.'0001';
    //     }
    // }

	public static function increase_employee()
    {

       	$increase = '';
       	$count = User::where('user_type',1)->count();

        return $increase = 'EM'.sprintf('%04d', ($count+1));
    }
    public static function increase_agency()
    {
        $increase = '';
        $count = User::where('user_type',2)->count();
        return $increase = 'AG'.sprintf('%04d', ($count+1));
    }

    public static function increase_customer()
    {
       $increase = '';
        $last_id=User::select('user_year')->get()->last();
        $cur_year = date('Y');
        if($last_id){
            $count = User::where('user_year',date('Y'))->where('user_type',1)->count();
            $old_year = $last_id->user_year?$last_id->user_year:date('Y');
            if($old_year==$cur_year){
               return $increase = 'EM141019'.$cur_year.''.sprintf('%05d', ($count+1));
            }
            if($old_year!=$cur_year){
               return $increase = 'EM141019'.$cur_year.'0001';
            }
        }else{
            return $increase = 'EM141019'.$cur_year.'0001';
        }
    }

    public static function numnkhtext($complete_char,$enableThousand){
        if(floatval($complete_char)==0) return "សូន្យ";
        $cleanStr = ltrim($complete_char, '0');
        $num_arr = preg_split('/(?<!^)(?!$)/u', $cleanStr);
        $translated=''; $addThousand=false;
        $khNUMTxt = array('','មួយ','ពីរ','បី','បួន','ប្រាំ');
        $twoLetter = array('','ដប់','ម្ភៃ','សាមសិប','សែសិប','ហាសិប','ហុកសិប','ចិតសិប','ប៉ែតសិប','កៅសិប');
        $khNUMLev = array('','','','រយ','ពាន់','មុឺន','សែន','លាន');
        $khnum = array('០','១','២','៣','៤','៥','៦','៧','៨','៩');
        foreach($num_arr as $key=>$value){
            if(in_array($value,$khnum)){$value = array_search($value,$khnum);}
            if(!is_numeric($value)){return '';}
            $pos = count($num_arr) - ($key);
            if($pos>count($khNUMLev)-1){$pos=($pos % count($khNUMLev))+2;}
            if($enableThousand and ($pos == 5 or $pos == 6)){$pos = $pos-3;}
            if($pos==2){
                $translated .= $twoLetter[$value];
            }else{
                if($value>5){$translated .=  $khNUMTxt[5].$khNUMTxt[$value - 5];}else{$translated .= $khNUMTxt[$value];}
            }
            if($pos==2 or $pos == 3 or $pos == 4){
                if($value>0){$addThousand=true;}
            }
            if($value>0 or ($pos==4 and $addThousand and $enableThousand) or $pos==7){
                $translated .= $khNUMLev[$pos];
            }
            if($pos==4){$addThousand=false;}
        }
        return $translated;
    }

    public static function voucher_ref()
    {
        $max            = JournalModel::max('id');
        $voucher_ref    = $max + 1;
        (string) $voucher_ref;
        while (strlen($voucher_ref) < 8) {
            $voucher_ref = "0" . $voucher_ref;
        }
        $voucher_ref = "V-" . $voucher_ref;
        return $voucher_ref;
    }
    public static function DescriptionBySaleID($prefix,$id){
        $sale = DB::table('nso007_sale_stock as sale')
            ->join('nso007_sale_detail_stock as detail','detail.sale_id','sale.id')
            ->join('nso007_item_stock as stock','stock.id','detail.item_id')
            ->join('nso007_category_stock as cat','cat.id','stock.category_id')
            ->join('nso007_project_stock as project','project.id','stock.project_id')
            ->select('project.name as project_name','cat.name as category_name',DB::raw('group_concat(stock.name) as item_name'))
            ->where('sale.id',$id)->groupBy('sale.id')->first();
        return (strlen($prefix)>5?$prefix." ":"").$sale->project_name.",".$sale->category_name.",(".$sale->item_name.")";
    }
    public static function generate_voucher_number($number_ref,$digit)
    {
        return str_pad($number_ref,$digit, "0", STR_PAD_LEFT);
    }
    public static function return_project_id($sale_id){
        $sale = DB::table('nso007_sale_stock as sale')
            ->join('nso007_sale_detail_stock as detail','detail.sale_id','sale.id')
            ->join('nso007_item_stock as stock','stock.id','detail.item_id')
            ->join('nso007_project_stock as project','project.id','stock.project_id')
            ->select('project.id as project_id')
            ->where('sale.id',$sale_id)->first();
        return $sale->project_id;
    }
}
