<?php

namespace App\Helpers;

use App\Helpers\IDate;
use App\Models\EmpLeaveDetail;
use Carbon\Carbon;

class GetAttNoFp
{

    static function getGenSalaryAdvance($f_date, $t_date, $row)
    {// $row = $emp
        $createDateRange = IDate::createDateRange($f_date, $t_date);
        $resign_date = $row->getOriginal('resign_date');
        $status = $row->status;

        $joined_date = $row->getOriginal('joined_date');

        // $year_join = IDate::getYear($joined_date);

        $total_leave = 0;
        $total_leave_ma = 0;
        $total_unpaid_leave = 0;
        $num_day_of_month = IDate::getDayFullMonth($t_date);
        $num_day_work = $num_day_of_month;
        $num_allowance = 20;

        $last_day_of_mm = IDate::getLastDayMonth($t_date);
        $isResign = self::isResign($f_date, $last_day_of_mm, $resign_date);
        $isStartWork = self::isStartWork($f_date, $t_date, $joined_date);
        $monthly_rate = $row->monthly_rate;
        // $total_ot = 0;

        $isJDate = self::isJDate($f_date, $t_date, $joined_date, $resign_date);


        $rate_per_day = $monthly_rate / $num_day_of_month;

        //$total_ot = self::getOT($f_date, $t_date, $row);

        if ($isResign) {
            $num_day_work = IDate::dateDiff($f_date, $resign_date);
        } else if ($isStartWork) {
            $num_day_work = IDate::dateDiff($joined_date, $t_date);
        }

        $monthly_rate = $num_day_work * $rate_per_day;
        $first_ma = $f_date;
        $is_first_ma = 0;

        foreach ($createDateRange as $c_date) {
            $leave = self::getLeave($row->id, $c_date);
            if ($leave != null) {
                $leave_count = $leave->day_amt;
                if ($leave_count > 0) {
                    $num_allowance -= $leave_count;
                    if ($leave->leave_type == 'maternity_leave') {
                        if ($is_first_ma == 0) {
                            $first_ma = $c_date;
                        }
                        $total_leave_ma += $leave_count;
                        $is_first_ma++;
                    } else if ($leave->leave_type == 'unpaid_leave') {
                        $total_unpaid_leave += $leave_count;
                    } else {
                        $total_leave += $leave_count;
                    }
                }
            }

        }
        $advance_salary = 0;

        if ($isResign) {
            $nn = IDate::dateDiff($f_date, $resign_date);
            $advance_salary = ($rate_per_day / 2) * $nn;
        } else if ($isStartWork) {
            $nn = IDate::dateDiff($f_date, $joined_date);
            $advance_salary = ($rate_per_day / 2) * ($num_day_of_month - $nn);
        } else if ($total_leave_ma > 0) {
            $nn1 = IDate::dateDiff($f_date, $first_ma);
            $nn2 = $num_day_of_month - $nn1;
            $amt1 = $nn1 * ($rate_per_day / 2);
            $amt2 = $nn2 * ($rate_per_day / 4);
            $advance_salary = $amt1 + $amt2;
        } else {
            $advance_salary = $row->monthly_rate / 2;
        }
        if ($isJDate) {
            $rr = [
                'isResign' => $isResign,
                'joined_date' => $joined_date,
                'resign_date' => $resign_date,
                'monthly_rate' => $row->monthly_rate,
                'advance_salary' => $advance_salary,
                'day_of_month' => $num_day_of_month
            ];
        } else {
            $rr = [
                'isResign' => $isResign,
                'joined_date' => $joined_date,
                'resign_date' => $resign_date,
                'monthly_rate' => 0,
                'advance_salary' => 0,
                'day_of_month' => 0
            ];
        }

        //dd($rr);
        return $rr;


    }

    /**
     * @param $f_date
     * @param $t_date
     * @param $row
     * @param $total_advance_salary
     * @return array
     */
    static function getGenSalary($f_date, $t_date, $row, $total_advance_salary)
    {// $row = $emp
        $rate_exchange = App\Helpers\Helper::getTaxExRate();
        $rate_dependent_deduction = App\Helpers\Helper::getTaxDependentDeduction();
        $rate_fringe_tax_rate = App\Helpers\Helper::getTaxFringeTaxRate();
        $exchange_khmer = App\Helpers\Helper::getTaxExRate();

        $new_allowance_rate = $row->allowance_rate ?? 0;
        //dd($new_allowance_rate);

        $f_year = IDate::getYear($t_date);//$f_year,$f_month
        $f_month = IDate::getMonth($t_date);
        $createDateRange = IDate::createDateRange($f_date, $t_date);
        $resign_date = $row->getOriginal('resign_date');
        $status = $row->status;

        $joined_date = $row->getOriginal('joined_date');
        // $year_join = IDate::getYear($joined_date);

        $total_leave = 0;
        $total_leave_ma = 0;
        $total_unpaid_leave = 0;
        $num_day_of_month = IDate::getDayFullMonth($t_date);
        $num_day_work = $num_day_of_month;
        $num_allowance = 0;

        $isResign = self::isResign($f_date, $t_date, $resign_date);
        $isStartWork = self::isStartWork($f_date, $t_date, $joined_date);
        $monthly_rate = $row->monthly_rate;
        //$total_ot = 0;

        //==============
        //==============
        // dd($row);
        $position_allowance = $row->position_allowance;
        $meal_allowance = $row->meal_allowance;
        $other_allowance = $row->other_allowance;
        $previous_salary = $row->previous_salary;
        //==============
        //==============


        $rate_per_day = $monthly_rate / $num_day_of_month;
        $total_ot = self::getOT($f_date, $t_date, $row);
        if ($isResign) {
            $num_day_work = IDate::dateDiff($f_date, $resign_date);
        }
        if ($isStartWork) {
            $num_day_work = IDate::dateDiff($joined_date, $t_date);
        }

        $monthly_rate = $num_day_work * $rate_per_day;

        $first_ma = $f_date;
        $is_first_ma = 0;


        $total_ll = 20;  // total allowance
        foreach ($createDateRange as $c_date) {
            $leave = self::getLeave($row->id, $c_date);

            if ($leave != null) {
                $leave_count = $leave->day_amt;
                if ($leave_count > 0) {
                    //$num_allowance -= $leave_count;
                    if ($leave->leave_type == 'maternity_leave') {
                        $total_leave_ma += $leave_count;
                        $is_first_ma = 1;
                        if ($leave_count > 0 && $leave_count < 1) {
                            $num_allowance = $num_allowance + 0.5;
                        }
                        continue;
                    } else if ($leave->leave_type == 'unpaid_leave') {
                        $total_unpaid_leave += $leave_count;
                    } else {
                        $total_leave += $leave_count;
                    }

                    if ($leave_count > 0 && $leave_count < 1) {
                        $num_allowance = $num_allowance + 0.5;
                    }
                    //echo "<h1> == {$leave_count}</h1>";
                    $total_ll = $total_ll - $leave_count;
                    continue;
                }
            }

            if (IDate::dateComp($c_date, $joined_date)) {
                continue;
            }
            if ($resign_date != null) {
                if (IDate::dateComp($resign_date, $c_date)) {
                    continue;
                }
            }

            $h_d_rate = getOne("SELECT DISTINCT id  FROM   holiday_schedules
                                            WHERE DATE(start_date) <= DATE ('{$c_date}')
                                            AND DATE(end_date) >= DATE ('{$c_date}') LIMIT 1 ");
            if ($h_d_rate > 0) {
                continue;
            }

            $s_day = getOne("SELECT DAYNAME ('" . $c_date . "')");
            if ($s_day == 'Sunday' || $s_day == 'Saturday') {
                continue;
            }
            //   echo "<h1> {$leave}== {$num_allowance}</h1>";

            $num_allowance = $num_allowance + 1;
        }

        if ($isResign) {
            // $monthly_rate2 = ($num_day_work ) * $rate_per_day;
            //dd("$monthly_rate2 = ($num_day_work - 1) * $rate_per_day; ");
            $n_d_r = IDate::createDateRange($f_date, $resign_date);
            $n_n = 0;
            foreach ($n_d_r as $n_c_date) {
                $h_d_rate = getOne("SELECT DISTINCT id  FROM   holiday_schedules
                                            WHERE DATE(start_date) <= DATE ('{$n_c_date}')
                                            AND DATE(end_date) >= DATE ('{$n_c_date}') LIMIT 1 ");
                if ($h_d_rate > 0) {
                    continue;
                }

                $s_day = getOne("SELECT DAYNAME ('" . $n_c_date . "')");
                if ($s_day == 'Sunday' || $s_day == 'Saturday') {
                    continue;
                }
                $n_n++;
            }

            $num_allowance = $n_n - $total_leave_ma - $total_unpaid_leave - $total_leave;

        } else if ($isStartWork) {
            // $monthly_rate2 = ($num_day_work +1) * $rate_per_day;
            $n_d_r = IDate::createDateRange($joined_date, $t_date);
            $n_n = 0;
            foreach ($n_d_r as $n_c_date) {
                $h_d_rate = getOne("SELECT DISTINCT id  FROM   holiday_schedules
                                            WHERE DATE(start_date) <= DATE ('{$n_c_date}')
                                            AND DATE(end_date) >= DATE ('{$n_c_date}') LIMIT 1 ");
                if ($h_d_rate > 0) {
                    continue;
                }

                $s_day = getOne("SELECT DAYNAME ('" . $n_c_date . "')");
                if ($s_day == 'Sunday' || $s_day == 'Saturday') {
                    continue;
                }
                $n_n++;
            }

            $num_allowance = $n_n - $total_leave_ma - $total_unpaid_leave - $total_leave;

        } else {
            //  $num_allowance = 20 - $total_leave_ma - $total_unpaid_leave - $total_leave;
            if ($is_first_ma > 0) {
            } else {
                $num_allowance = $total_ll;
            }

        }


        /*echo "<h1> {$leave}== {$num_allowance}</h1>";*/

        $num_allowance = $num_allowance > 0 ? $num_allowance : 0;
        $num_allowance = $num_allowance >= 20 ? 20 : $num_allowance;
        //=====================
        //$allowance_rate = 0;
        $allowance_rate = $new_allowance_rate > 0 ? $new_allowance_rate : 0;
        /* if($joined_date != null) {
             $year_join = IDate::getYear($joined_date);
             if ($year_join < 2019) {
                 $allowance_rate = App\Helpers\Helper::getBeforeRate2019();
             } else {
                 $allowance_rate = App\Helpers\Helper::getAfterRate2019();
             }
         }*/
        //$day_for_meal = $num_allowance * ($allowance_rate/20);
        $day_for_meal = $num_allowance * ($allowance_rate);
        $day_for_meal = $day_for_meal > 0 ? $day_for_meal : 0;
        /*dd($day_for_meal, $num_allowance);*/
        //====================
        $total_leave_ma_amt = $total_leave_ma * ($rate_per_day / 2);
        $total_unpaid_leave_amt = $total_unpaid_leave * $rate_per_day;

        $monthly_rate2 = 0;
        if ($isResign) {
            $monthly_rate2 = ($num_day_work) * $rate_per_day;
            //dd("$monthly_rate2 = ($num_day_work - 1) * $rate_per_day; ");
        } else if ($isStartWork) {
            $monthly_rate2 = ($num_day_work + 1) * $rate_per_day;
        } else {
            if ($is_first_ma > 0) {
                $monthly_rate2 = ($num_day_of_month - $total_leave_ma) * $rate_per_day;
            } else {
                $monthly_rate2 = ($num_day_of_month - $total_leave_ma) * $rate_per_day;
            }

            $monthly_rate2 = $monthly_rate2 > 0 ? $monthly_rate2 : 0;
        }

        //dd(" $monthly_rate = $monthly_rate2 + $total_leave_ma_amt - $total_unpaid_leave_amt; ");
        $monthly_rate = $monthly_rate2 + $total_leave_ma_amt - $total_unpaid_leave_amt;
        //  dd(" $monthly_rate = $monthly_rate2 + $total_leave_ma_amt - $total_unpaid_leave_amt; ");
        //=====================
        $gPay = self::getGrossPay($row, $f_year, $f_month, $monthly_rate, $total_ot['total_ot']);//[$actual_salary,$gross_pay]
        $actual_salary = isset($gPay[0]) ? $gPay[0] : 0;
        $gross_pay = isset($gPay[1]) ? $gPay[1] : 0;
        //=====================
        $iTax = self::getIncomeTax($row, $gross_pay);// [$taxable_salary,$income_tax,$income_tax_rate];
        $taxable_salary = isset($iTax[0]) ? $iTax[0] : 0;
        $income_tax = isset($iTax[1]) ? $iTax[1] : 0;
        $income_tax_rate = isset($iTax[2]) ? $iTax[2] : 0;
        $exchange_khmer = isset($iTax[3]) ? $iTax[3] : 0;
        $income_tax_deduction = isset($iTax[4]) ? $iTax[4] : 0;
        $taxable_salary_khmer = isset($iTax[5]) ? $iTax[5] : 0;
        $salary_tax = isset($iTax[6]) ? $iTax[6] : 0;
        $fringe_tax = isset($iTax[7]) ? $iTax[7] : 0;
        $nssf = isset($iTax[8]) ? $iTax[8] : 0;
        $heath = isset($iTax[9]) ? $iTax[9] : 0;


        //=====================
        //=====================
        $net_pay = $taxable_salary - $income_tax;
        $net_pay = $net_pay > 0 ? $net_pay : 0;
        //dd($gross_pay ,$actual_salary ,$total_advance_salary,$day_for_meal );
        $actual_salary = round(($gross_pay + $actual_salary) - $total_advance_salary, 2);
        $actual_salary = $actual_salary > 0 ? $actual_salary : 0;

        // $gross_pay_total = $actual_salary + $day_for_meal ;
        $gross_pay_total = $monthly_rate + $day_for_meal - $total_advance_salary;
        $gross_pay_total = $gross_pay_total > 0 ? $gross_pay_total : 0;

        //============================
        $spouse = $row->getOriginal('spouse') > 0 ? $row->getOriginal('spouse') : 0;
        $children = $row->getOriginal('children') > 0 ? $row->getOriginal('children') : 0;
        $num_depandent = $spouse + $children > 0 ? $spouse + $children : 0;
        $total_depandent = $num_depandent * $rate_dependent_deduction;
        $total_depandent = $total_depandent > 0 ? $total_depandent : '-';

        $isJDate = self::isJDate($f_date, $t_date, $joined_date, $resign_date);
        $advance_sal = App\Models\GenAttend::getAdvanceSalary($row->id, $f_year, $f_month);
        $total_advance_salary = isset($advance_sal['advance_sal']) ? $advance_sal['advance_sal'] : 0;
        $n_add = $position_allowance + $meal_allowance + $other_allowance + $previous_salary;
        if ($isJDate) {
            //dd("$gross_pay_total + $n_add");
            $rr = [
                'n_add' => $n_add,
                'previous_salary' => $previous_salary,
                'other_allowance' => $other_allowance,
                'meal_allowance' => $meal_allowance,
                'position_allowance' => $position_allowance,
                'isResign' => $isResign,
                'joined_date' => $joined_date,
                'resign_date' => $resign_date,
                'ALREADY_PAID_AMOUNT' => $total_advance_salary,
                'PAYMENT_RATE' => 100,
                'DAYS_FOR_SALARY' => 31,// $num_day_of_month,
                'DAYS_FOR_MEALS' => $num_allowance,
                'TOTAL_DAYS' => 31,// $num_day_of_month,
                'BASIC_SALARY' => $row->monthly_rate,
                'monthly_rate' => $monthly_rate,
                'ACTUAL_SALARY' => $monthly_rate - $total_advance_salary,
                'gross_pay_total' => $gross_pay_total + $n_add,
                'MEAL' => $day_for_meal,
                'INCOME_TAX_RATE' => $income_tax_rate,
                'INCOME_TAX' => $income_tax,
                'exchange_khmer' => $exchange_khmer,
                'income_tax_deduction' => $income_tax_deduction,
                'num_depandent' => $num_depandent,
                'total_depandent' => $total_depandent,
                'taxable_salary_khmer' => $taxable_salary_khmer,
                'taxable_salary' => $taxable_salary,
                'salary_tax' => $salary_tax,
                'fringe_tax' => $fringe_tax,

                'total_ot' => $total_ot['total_ot'],
                'ot_before_month' => 0,
                'ot_fix_amt' => $total_ot['total_ot'],
                'ot_hol_200_amt' => $total_ot['ot_hol_200_amt'],
                'ot_hol_150_amt' => $total_ot['ot_hol_150_amt'],
                'ot_hol_100_amt' => $total_ot['ot_hol_100_amt'],
                'ot_sun_200_amt' => $total_ot['ot_sun_200_amt'],
                'ot_sun_150_amt' => $total_ot['ot_sun_150_amt'],
                'ot_sun_100_amt' => $total_ot['ot_sun_100_amt'],
                'ot_200_amt' => $total_ot['ot_200_amt'],
                'ot_150_amt' => $total_ot['ot_150_amt'],
                'ot_100_amt' => $total_ot['ot_100_amt'],
                'net_pay' => $net_pay,
                'nssfhealth' => $heath,
                'nssf' => $nssf,
                'spouse' => 0,
                'child' => 0


            ];
        } else {
            $rr = [
                'n_add' => $n_add,
                'previous_salary' => $previous_salary,
                'other_allowance' => $other_allowance,
                'meal_allowance' => $meal_allowance,
                'position_allowance' => $position_allowance,
                'isResign' => $isResign,
                'joined_date' => $joined_date,
                'resign_date' => $resign_date,
                'ALREADY_PAID_AMOUNT' => 0,
                'PAYMENT_RATE' => 0,
                'DAYS_FOR_SALARY' => 0,
                'DAYS_FOR_MEALS' => 0,
                'TOTAL_DAYS' => 0,
                'BASIC_SALARY' => 0,
                'monthly_rate' => 0,
                'ACTUAL_SALARY' => 0,
                'gross_pay_total' => 0,
                'MEAL' => 0,
                'INCOME_TAX_RATE' => 0,
                'INCOME_TAX' => 0,
                'exchange_khmer' => 0,
                'income_tax_deduction' => 0,
                'num_depandent' => 0,
                'total_depandent' => 0,
                'taxable_salary_khmer' => 0,
                'taxable_salary' => 0,
                'salary_tax' => 0,
                'fringe_tax' => 0,
                'total_ot' => 0,
                'ot_before_month' => 0,
                'ot_fix_amt' => 0,
                'ot_hol_200_amt' => 0,
                'ot_hol_150_amt' => 0,
                'ot_hol_100_amt' => 0,
                'ot_sun_200_amt' => 0,
                'ot_sun_150_amt' => 0,
                'ot_sun_100_amt' => 0,
                'ot_200_amt' => 0,
                'ot_150_amt' => 0,
                'ot_100_amt' => 0,
                'net_pay' => 0,
                'nssfhealth' => 0,
                'nssf' => 0,
                'spouse' => 0,
                'child' => 0
            ];
        }

        //dd($rr);
        return $rr;


    }

    static function isResign($f_date, $t_date, $resign_date)
    {
        if ($resign_date != null) {
            return (IDate::dateComp($f_date, $resign_date) && IDate::dateComp($resign_date, $t_date));
        } else {
            return false;
        }
    }

    static function isStartWork($f_date, $t_date, $joined_date)
    {
        if ($joined_date != null) {
            return (IDate::dateComp($f_date, $joined_date) && IDate::dateComp($joined_date, $t_date));
        }
        return false;
    }


    static function isJDate($f_date, $t_date, $joined_date, $resign_date)
    {

        return self::isJDate2($f_date, $t_date, $joined_date) && self::isRDate($f_date, $t_date, $resign_date);
    }

    static function isJDate2($f_date, $t_date, $joined_date)
    {

        if (self::isStartWork($f_date, $t_date, $joined_date)) {
            return true;
        }
        if (IDate::dateComp($t_date, $joined_date)) {
            return false;
        }

        if (IDate::dateComp($joined_date, $f_date) || IDate::dateComp($joined_date, $t_date)) {
            return true;
        }

        return true;
    }

    static function isRDate($f_date, $t_date, $resign_date)
    {

        if ($resign_date != null) {
            if (IDate::dateComp($resign_date, $f_date)) {
                return false;
            }
            if (self::isResign($f_date, $t_date, $resign_date)) {
                return true;
            }

        }

        return true;
    }


    static function getLeave($emp_id, $date)
    {
        return EmpLeaveDetail::where('emp_id', $emp_id)
            ->whereDate('leave_date', $date)
            ->where('approve', 1)
            ->select('day_amt', 'leave_type')->first();
    }

    static function getOT($f_date, $t_date, $row)
    {
        $ot_100 = 0;
        $ot_150 = 0;
        $ot_200 = 0;
        $ot_sun_100 = 0;
        $ot_sun_150 = 0;
        $ot_sun_200 = 0;
        $ot_hol_100 = 0;
        $ot_hol_150 = 0;
        $ot_hol_200 = 0;
        $fix_ot_amount = 0;
        $total_ot = 0;
        $monthly_rate = $row->getOriginal('monthly_rate');

        $ot = App\Models\GenAttend::getManualRequestOTFirst($row->id, $f_date, $t_date);
        if (is_array($ot)) {
            $ot_100 = $ot['ot_100'] > 0 ? $ot['ot_100'] : 0;
            $ot_150 = $ot['ot_150'] > 0 ? $ot['ot_150'] : 0;
            $ot_200 = $ot['ot_200'] > 0 ? $ot['ot_200'] : 0;
            $ot_sun_100 = $ot['ot_sun_100'] > 0 ? $ot['ot_sun_100'] : 0;
            $ot_sun_150 = $ot['ot_sun_150'] > 0 ? $ot['ot_sun_150'] : 0;
            $ot_sun_200 = $ot['ot_sun_200'] > 0 ? $ot['ot_sun_200'] : 0;

            $ot_hol_100 = $ot['ot_hol_100'] > 0 ? $ot['ot_hol_100'] : 0;
            $ot_hol_150 = $ot['ot_hol_150'] > 0 ? $ot['ot_hol_150'] : 0;
            $ot_hol_200 = $ot['ot_hol_200'] > 0 ? $ot['ot_hol_200'] : 0;

            $fix_ot_amount = $ot['fix_ot_amount'] > 0 ? $ot['fix_ot_amount'] : 0;
        }

        if ($monthly_rate > 0) {
            $monthly_rate_ot_100 = round((($monthly_rate / 26) / 8.50) * 1, 2);
            $monthly_rate_ot_150 = round((($monthly_rate / 26) / 8.50) * 1.5, 2);
            $monthly_rate_ot_200 = round((($monthly_rate / 26) / 8.50) * 2, 2);

            $ot_100 = round($ot_100 * $monthly_rate_ot_100, 2);
            $ot_150 = round($ot_150 * $monthly_rate_ot_150, 2);
            $ot_200 = round($ot_200 * $monthly_rate_ot_200, 2);
            $ot_100 = $ot_100 > 0 ? $ot_100 : 0;
            $ot_150 = $ot_150 > 0 ? $ot_150 : 0;
            $ot_200 = $ot_200 > 0 ? $ot_200 : 0;

            $ot_sun_100 = round($ot_sun_100 * $monthly_rate_ot_100, 2);
            $ot_sun_150 = round($ot_sun_150 * $monthly_rate_ot_150, 2);
            $ot_sun_200 = round($ot_sun_200 * $monthly_rate_ot_200, 2);
            $ot_sun_100 = $ot_sun_100 > 0 ? $ot_sun_100 : 0;
            $ot_sun_150 = $ot_sun_150 > 0 ? $ot_sun_150 : 0;
            $ot_sun_200 = $ot_sun_200 > 0 ? $ot_sun_200 : 0;

            $ot_hol_100 = round($ot_hol_100 * $monthly_rate_ot_100, 2);
            $ot_hol_150 = round($ot_hol_150 * $monthly_rate_ot_150, 2);
            $ot_hol_200 = round($ot_hol_200 * $monthly_rate_ot_200, 2);
            $ot_hol_100 = $ot_hol_100 > 0 ? $ot_hol_100 : 0;
            $ot_hol_150 = $ot_hol_150 > 0 ? $ot_hol_150 : 0;
            $ot_hol_200 = $ot_hol_200 > 0 ? $ot_hol_200 : 0;

            $fix_ot_amount = $fix_ot_amount > 0 ? $fix_ot_amount : 0;

            $total_ot = round($ot_100 + $ot_150 + $ot_200 +
                $ot_sun_100 + $ot_sun_150 + $ot_sun_200 +
                $ot_hol_100 + $ot_hol_150 + $ot_hol_200 + $fix_ot_amount, 2);
            $total_ot = $total_ot > 0 ? $total_ot : 0;
        }
        return [
            'total_ot' => $total_ot,
            'ot_before_month' => 0,
            'ot_fix_amt' => $fix_ot_amount,
            'ot_hol_200_amt' => $ot_hol_200,
            'ot_hol_150_amt' => $ot_hol_150,
            'ot_hol_100_amt' => $ot_hol_100,
            'ot_sun_200_amt' => $ot_sun_200,
            'ot_sun_150_amt' => $ot_sun_150,
            'ot_sun_100_amt' => $ot_sun_100,
            'ot_200_amt' => $ot_200,
            'ot_150_amt' => $ot_150,
            'ot_100_amt' => $ot_100
        ];

    }

    static function getGrossPay($row, $f_year, $f_month, $monthly_rate, $total_ot)
    {

        //==============
        //==============
        $position_allowance = $row->position_allowance ?? 0;
        $meal_allowance = $row->meal_allowance ?? 0;
        $other_allowance = $row->other_allowance ?? 0;
        $previous_salary = $row->previous_salary ?? 0;
        //==============
        //==============
        // benefit fix =====================
        $n_add = $position_allowance + $meal_allowance + $other_allowance + $previous_salary;
        //dd("$n_add = $position_allowance + $meal_allowance + $other_allowance + $previous_salary;");
        $increment = isset(optional($row->addition)['increment']) ? optional($row->addition)['increment'] : 0;
        $fixed_allowance = isset(optional($row->addition)['fixed_allowance']) ? optional($row->addition)['fixed_allowance'] : 0;
        $transportation_allowance = isset(optional($row->addition)['transportation_allowance']) ? optional($row->addition)['transportation_allowance'] : 0;
        $other_additional = isset(optional($row->addition)['other_additional']) ? optional($row->addition)['other_additional'] : 0;

        $increment = $increment > 0 ? $increment : 0;
        $fixed_allowance = $fixed_allowance > 0 ? $fixed_allowance : 0;
        $transportation_allowance = $transportation_allowance > 0 ? $transportation_allowance : 0;
        $other_additional = $other_additional > 0 ? $other_additional : 0;
        $fix_benefit_profile = $increment + $fixed_allowance + $transportation_allowance;
        $fix_benefit_profile = $fix_benefit_profile > 0 ? $fix_benefit_profile : 0;
        //dd($increment,$fixed_allowance,$transportation_allowance,$other_additional);
        $seniority_bonus = App\Models\GenAttend::getSeniorityBonus($row->id, $f_year, $f_month);
        $seniority_bonus = $seniority_bonus > 0 ? $seniority_bonus : 0;

        $incentive = App\Models\GenAttend::getImportIncentive($row->id, $f_year, $f_month);
        $incentive = $incentive > 0 ? $incentive : 0;

        $seniority = App\Models\GenAttend::getSeniorityS($row->id, $f_year, $f_month);
        $seniority = $seniority > 0 ? $seniority : 0;

        $manual_benefit = $seniority_bonus;
        $manual_benefit = $manual_benefit > 0 ? $manual_benefit : 0;
        //dd($seniority_bonus , $long_sick ,$mccliam , $phonecard);
        // =========================================================
        // ======================== Deduction=======================
        $manual_deduction = App\Models\GenAttend::getManualDeduction($row->id, $f_year, $f_month);
        $manual_deduction = $manual_deduction > 0 ? $manual_deduction : 0;

        // deduction fix =====================
        $uniform_deduction = isset(optional($row->deduction)['uniform']) ? optional($row->deduction)['uniform'] : 0;
        $other_deduction = isset(optional($row->deduction)['other']) ? optional($row->deduction)['other'] : 0;
        $hour_deduct_miss = isset($row->hour_deduct_missed) ? $row->hour_deduct_missed : 0;

        $uniform_deduction = $uniform_deduction > 0 ? $uniform_deduction : 0;
        $other_deduction = $other_deduction > 0 ? $other_deduction : 0;
        $hour_deduct_miss = $hour_deduct_miss > 0 ? $hour_deduct_miss : 0;

        $fix_deduction_profile = $uniform_deduction + $other_deduction + $hour_deduct_miss;
        $fix_deduction_profile = $fix_deduction_profile > 0 ? $fix_deduction_profile : 0;
        //dd($uniform_deduction,$other_deduction,$hour_deduct_miss);

        $actual_salary = $seniority + $other_additional;
        $actual_salary = $actual_salary > 0 ? $actual_salary : 0;

        $gross_pay = $n_add + ($monthly_rate + $total_ot + $manual_benefit + $fix_benefit_profile) -
            ($fix_deduction_profile + $manual_deduction);
        $gross_pay = $gross_pay > 0 ? $gross_pay : 0;

        return [$actual_salary, $gross_pay];
    }

    static function getIncomeTax($row, $gross_pay)
    {
        $fringe_tax = 0;
        $exchange_khmer = App\Helpers\Helper::getTaxExRate();
        $spouse_child = \App\Models\GenAttend::getSpouseChild($row->id);
        $taxable_salary_khmer = round(($gross_pay - $spouse_child) * $exchange_khmer, 2);

        $taxable_salary = $gross_pay - $spouse_child;
        $taxable_salary = $taxable_salary > 0 ? $taxable_salary : 0;

        $income_tax_rate = getIncomeTaxRate($taxable_salary);
        $income_tax_rate = $income_tax_rate > 0 ? $income_tax_rate : 0;

        $income_tax_deduction = getIncomeTaxDeduction($taxable_salary);
        $income_tax_deduction = $income_tax_deduction > 0 ? $income_tax_deduction : 0;

        $nssf_ = nssf($taxable_salary);

        $nssf = isset($nssf_[0]) ? $nssf_[0] : 0;

        $heath = isset($nssf_[1]) ? $nssf_[1] : 0;

        $salary_tax = calculateTax($taxable_salary);
        $salary_tax = $salary_tax > 0 ? $salary_tax : 0;
        //dd($taxable_salary,$income_tax_deduction,$salary_tax);

        /*  if($row->national == 'Foreign')
          {
               $fringe_tax_rate = App\Helpers\Helper::getTaxFringeTaxRate();
               $fringe_tax = round($taxable_salary  - ($taxable_salary* ($fringe_tax_rate / 100)),2);
               $fringe_tax = $fringe_tax>0?$fringe_tax:0;

          }else{
          $fringe_tax = 0;
          }*/

        $income_tax = $salary_tax + $fringe_tax;
        $income_tax = $income_tax > 0 ? $income_tax : 0;
        return [
            $taxable_salary,
            $income_tax,
            $income_tax_rate,
            $exchange_khmer,
            $income_tax_deduction,
            $taxable_salary_khmer,
            $salary_tax,
            $fringe_tax,
            $nssf,
            $heath
        ];
    }
}

