<?php

namespace App\Helpers;

use App\Models\Hr\TimeAttendanceGenModel;
use App\Models\Hr\TimePolicyModel;
use App\Models\Hr\TimeAttendanceModel;
use App\User;
use Illuminate\Support\Facades\DB;

class GenAtt
{
    public static function get_TimePolicy()
    {
        $time_policy = TimePolicyModel::where('status', 1)->first();

        return $time_policy?$time_policy:'';
    }

    public static function getDateRange($from_date = null, $to_date = null)
    {
        $number = 0;
        $from_date  = strtotime('2020-08-01');
        $to_date    = strtotime('2020-08-31');
        $datediff   = $to_date - $from_date;
        $number     = round($datediff / (60 * 60 * 24));

        return $number;
    }

    public static function generateTimeAttend($emp_id = NULL, $from_date = NULL, $to_date = NULL, $policy_id = null, $fingerprint_no = null)
    {

        /**SET  @date1 = '2010-10-11 00:00:00',
        @date2 = '2010-10-10 00:00:00';

        SELECT
        TIMEDIFF(@date1, @date2) AS 'TIMEDIFF',
        TIMESTAMPDIFF(DAY, @date1, @date2) AS 'Days',
        TIMESTAMPDIFF(WEEK, @date1, @date2) AS 'Weeks',
        TIMESTAMPDIFF(MONTH, @date1, @date2) AS 'Months',
        TIMESTAMPDIFF(HOUR, @date1, @date2) AS 'Hours',
        TIMESTAMPDIFF(MINUTE, @date1, @date2) AS 'Minutes',
        TIMESTAMPDIFF(SECOND, @date1, @date2) AS 'Seconds';

         */
        $dates = IDate::createDateRange($from_date, $to_date);

        if($emp_id > 0 && $policy_id > 0) {
            foreach ($dates as $date) {

                TimeAttendanceGenModel::where('emp_id', $emp_id)
                    ->whereDate('att_date', $date)
                    ->delete();
                $s_day = getOne("SELECT DAYNAME ('".$date."')");

                if($policy_id){
                    $attend = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minDate, MAX(check_in_out) AS maxDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->whereDate('check_in_out', $date)->first();
                    if ($attend != null)
                    {
                        //policy work in , work out , OT time in, OT Time out
                        $policy     = TimePolicyModel::where('id', $policy_id)->first();
                        /*
                            // convert 24-hour time to 12-hour time 
                            $time_in_12_hour_format  = date("g:i a", strtotime("13:30"));

                            // convert 12-hour time to 24-hour time 
                            $time_in_24_hour_format  = date("H:i", strtotime("1:30 PM"));

                        */
                        $time_in        = date("H:i:s", strtotime($policy->time_in));
                        $time_out       = date("H:i:s", strtotime($policy->time_out));
                        $ot_time_in     = date("H:i:s", strtotime($policy->ot_time_in));
                        $ot_time_out    = date("H:i:s", strtotime($policy->ot_time_out));

                        $win        = $date . ' ' . $time_in ;
                        $wout       = $date . ' ' . $time_out;
                        $ot_in      = $date . ' ' . $ot_time_in;
                        $ot_out     = $date . ' ' . $ot_time_out;

                        //find first checkin and last check out
                        $in         = $attend->minDate;
                        $out        = $attend->maxDate;

                        $total      = 0;
                        $in_ot      = $win;
                        $out_ot     = $wout;

                        $h_d_rate   = getOne("SELECT DISTINCT id  FROM   nso007_hr_holiday
                                                WHERE DATE(from_date) <= DATE ('{$date}')
                                                AND DATE(to_date) >= DATE ('{$date}') LIMIT 1 ");

                        // if scan in Sunday or Saturday or it's holiday
                        if($s_day == 'Sunday' || $s_day == 'Saturday' || $h_d_rate > 0){
                            $total_ot   = IDate::dateTimeDiff($in, $out) - 120;

                            $in         = $in;
                            $out        = $out;
                            $total      = 0;
                            $late       = 0;
                            $ot         = 0;
                            $before     = 0;
                            $bot        = 0;
                            $ot_type    = $s_day == 'Sunday' ||  $s_day == 'Saturday' ? 'otsunsat':'othol';
                            $ot_sun     = $s_day == 'Sunday' ||  $s_day == 'Saturday' ? $total_ot:0;
                            $ot_hol     = $s_day != 'Sunday' &&  $s_day != 'Saturday' ? $total_ot:0;

                        }else{
                            // if scan in Monday to Friday it isn't holiday
                            if ($in != NULL || $out != NULL) {
                                $rin        = $in;
                                $rout       = $out;
                                $bot        = 0;
                                $ot         = 0;
                                $ot_hol     = 0;
                                $ot_sun     = 0;
                                $late       = 0;
                                $before     = 0;

                                //find time around work in 8:00am
                                $diffIn     = IDate::dateTimeDiff($in, $win);
                                //find time around work out 5:30pm
                                $diffOut    = IDate::dateTimeDiff($wout,$out);
                                //find time around work overtime 7:00pm
                                $diffOt_in  = IDate::dateTimeDiff($ot_in, $out);
                                //find time around work overtime 10:00pm
                                $diffOt_out = IDate::dateTimeDiff($out, $ot_out);
                                //come first time policy
                                if ($diffIn >= 0) {
                                    $rin    = $win;
                                }else{
                                    $late   = (-1) * $diffIn;
                                }
                                //go out last time policy
                                if ($diffOut >= 0) {
                                    $rout   = $wout;
                                }else{
                                    $before =  (-1) * $diffOut;
                                }
                                //find overtime
                                if($diffOt_in >= 0 && $diffOt_out >= 0){
                                    $ot = $diffOt_in;
                                }

                                //ot type
                                $ot_type    = ($bot + $ot)>=60?'ot':'';
                                $total      = IDate::dateTimeDiff($rin, $rout) - 60;

                            }

                        }
                        // full time if they came to work
                        if( $in_ot >= $in ||  $out_ot <= $out){
                            $diffInOut =  IDate::dateTimeDiff($in, $out);
                            if($diffInOut != null){
                                $in     = $in;
                                $out    = $out;

                            }
                            $total = IDate::dateTimeDiff($in, $out) - 60;
                        }
                        //delete emp_id and date same
                        TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereDate('att_date',$date)
                            ->delete();
                        //save to database
                        $m = TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereRaw(" (date(cin) = '{$date}' OR  date(cout) = '{$date}')")
                            ->first();
                        if ($m == null) {
                            $m = new TimeAttendanceGenModel();
                        }
                        $m->emp_id          = $emp_id;
                        $m->att_date        = $date;

                        if ($in) {
                            $m->cin         = $in;
                        }
                        if ($out) {
                            $m->cout        = $out;
                        }
                        if ($in && $out) {

                            $m->total       = $total;
                            $m->late        = $late;
                            $m->before      = $before;
                            $m->bot         = $bot;
                            $m->ot          = $ot;
                            $m->ot_type     = $ot_type;
                            $m->total_ot    = (($bot + $ot)>=60?($bot + $ot):0) ;
                            $m->total_sun   = $ot_sun>=60?$ot_sun:0;
                            $m->total_hol   = $ot_hol>=60?$ot_hol:0;
                        }
                        if ($in == NULL || $out == NULL) {
                            $m->missing = 1;
                        }
                        $m->save();
                    }
                }
            }
        }


    }
    public static function generateTimeAttends($emp_id = NULL, $from_date = NULL, $to_date = NULL, $policy_id = null, $fingerprint_no = null)
    {

        /**SET  @date1 = '2010-10-11 00:00:00',
        @date2 = '2010-10-10 00:00:00';
        SELECT
        TIMEDIFF(@date1, @date2) AS 'TIMEDIFF',
        TIMESTAMPDIFF(DAY, @date1, @date2) AS 'Days',
        TIMESTAMPDIFF(WEEK, @date1, @date2) AS 'Weeks',
        TIMESTAMPDIFF(MONTH, @date1, @date2) AS 'Months',
        TIMESTAMPDIFF(HOUR, @date1, @date2) AS 'Hours',
        TIMESTAMPDIFF(MINUTE, @date1, @date2) AS 'Minutes',
        TIMESTAMPDIFF(SECOND, @date1, @date2) AS 'Seconds';
         */
        $dates = IDate::createDateRange($from_date, $to_date);

        if($emp_id > 0 && $policy_id > 0) {
            foreach ($dates as $date) {

                TimeAttendanceGenModel::where('emp_id', $emp_id)
                    ->whereDate('att_date', $date)
                    ->delete();
                $s_day = getOne("SELECT DAYNAME ('".$date."')");

                if($policy_id){
                    $attend = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minDate, MAX(check_in_out) AS maxDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->whereDate('check_in_out', $date)->first();
                    if ($attend != null)
                    {
                        //policy work in , work out , OT time in, OT Time out
                        $policy     = TimePolicyModel::where('id', $policy_id)->first();

                        /*
                            // convert 24-hour time to 12-hour time 
                            $time_in_12_hour_format  = date("g:i a", strtotime("13:30"));

                            // convert 12-hour time to 24-hour time 
                            $time_in_24_hour_format  = date("H:i", strtotime("1:30 PM"));

                        */
                        $time_in    = date("H:i:s", strtotime($policy->time_in));
                        $time_out   = date("H:i:s", strtotime($policy->time_out));

                        $win        = $date . ' ' . $time_in ;
                        $wout       = $date . ' ' . $time_out;

                        $in         = $attend->minDate;
                        $out        = $attend->maxDate;

                        $total      = 0;
                        $in_ot      = $win;
                        $out_ot     = $wout;

                        $h_d_rate   = getOne("SELECT DISTINCT id  FROM   nso007_hr_holiday
                                                WHERE DATE(from_date) <= DATE ('{$date}')
                                                AND DATE(to_date) >= DATE ('{$date}') LIMIT 1 ");

                        // if scan in Sunday or Saturday or it's holiday
                        if($s_day == 'Sunday' || $s_day == 'Saturday' || $h_d_rate > 0){
                            $total_ot   = IDate::dateTimeDiff($in, $out) - 120;

                            $in         = $in;
                            $out        = $out;
                            $total      = 0;
                            $late       = 0;
                            $ot         = 0;
                            $before     = 0;
                            $bot        = 0;
                            $ot_type    = $s_day == 'Sunday' ||  $s_day == 'Saturday' ? 'otsunsat':'othol';
                            $ot_sun     = $s_day == 'Sunday' ||  $s_day == 'Saturday' ? $total_ot:0;
                            $ot_hol     = $s_day != 'Sunday' &&  $s_day != 'Saturday' ? $total_ot:0;

                        }else{
                            // if scan in Monday to Friday it isn't holiday
                            if ($in != NULL || $out != NULL) {
                                $rin        = $in;
                                $rout       = $out;
                                $bot        = 0;
                                $ot         = 0;
                                $ot_hol     = 0;
                                $ot_sun     = 0;
                                $late       = 0;
                                $before     = 0;

                                //find time around work in 8:00am
                                $diffIn     = IDate::dateTimeDiff($in, $win);
                                //find time around work out 5:30pm
                                $diffOut    = IDate::dateTimeDiff($wout,$out);

                                //come first time policy
                                if ($diffIn >= 0) {
                                    $rin    = $win;
                                    $bot    = $diffIn;
                                }else{
                                    $late   = (-1) * $diffIn;
                                }
                                //go out last time policy
                                if ($diffOut >= 0) {
                                    $rout   = $wout;
                                    $ot     = $diffOut;
                                }else{
                                    $before =  (-1) * $diffOut;
                                }
                                //ot type
                                $ot_type    = ($bot + $ot)>=60?'ot':'';
                                $total      = IDate::dateTimeDiff($rin, $rout) - 60;

                            }

                        }
                        // full time if they came to work
                        if( $in_ot >= $in ||  $out_ot <= $out){
                            $diffInOut =  IDate::dateTimeDiff($in, $out);
                            if($diffInOut != null){
                                $in     = $in;
                                $out    = $out;

                            }
                            $total = IDate::dateTimeDiff($in, $out) - 60;
                        }
                        //delete emp_id and date same
                        TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereDate('att_date',$date)
                            ->delete();
                        //save to database
                        $m = TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereRaw(" (date(cin) = '{$date}' OR  date(cout) = '{$date}')")
                            ->first();
                        if ($m == null) {
                            $m = new TimeAttendanceGenModel();
                        }
                        $m->emp_id          = $emp_id;
                        $m->att_date        = $date;

                        if ($in) {
                            $m->cin         = $in;
                        }
                        if ($out) {
                            $m->cout        = $out;
                        }
                        if ($in && $out) {

                            $m->total       = $total;
                            $m->late        = $late;
                            $m->before      = $before;
                            $m->bot         = $bot;
                            $m->ot          = $ot;
                            $m->ot_type     = $ot_type;
                            $m->total_ot    = (($bot + $ot)>=60?($bot + $ot):0) ;
                            $m->total_sun   = $ot_sun>=60?$ot_sun:0;
                            $m->total_hol   = $ot_hol>=60?$ot_hol:0;
                        }
                        if ($in == NULL || $out == NULL) {
                            $m->missing = 1;
                        }
                        $m->save();
                    }
                }
            }
        }
    }

    public static function getGenerateAttend($emp_id = null, $from_date = null, $to_date = null, $policy_id = null, $fingerprint_no = null, $month_year = null)
    {
        $dates = IDate::createDateRange($from_date, $to_date);
        $m_y    = explode('-', $month_year);
        $month  = isset($m_y[0]) ? $m_y[0] : 0;
        $year   = isset($m_y[1]) ? $m_y[1] : 0;

        if($emp_id > 0 && $policy_id > 0)

        {
            foreach ($dates as $date)
            {
                if ($policy_id)
                {
                    TimeAttendanceGenModel::where('emp_id', $emp_id)->whereDate('att_date', $date)->delete();
                    $s_day = getOne("SELECT DAYNAME ('".$date."')");
                    $attend_check_in    = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minCheckInDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->where('check_type', 'C/In')
                        ->whereDate('check_in_out', $date)->first();
                    $attend_check_out   = TimeAttendanceModel::select(DB::raw('MAX(check_in_out) AS maxCheckOutDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->where('check_type', 'C/Out')
                        ->whereDate('check_in_out', $date)->first();
                    $attend_ot_in       = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minOvertimeInDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->where('check_type', 'OverTime In')
                        ->whereDate('check_in_out', $date)->first();
                    $attend_ot_out      = TimeAttendanceModel::select(DB::raw('MAX(check_in_out) AS maxOvertimeOutDate'))
                        ->where('finger_print_no', $fingerprint_no)
                        ->where('check_type', 'OverTime Out')
                        ->whereDate('check_in_out', $date)->first();

                    if ($attend_check_in != null || $attend_check_out != null || $attend_ot_in != null || $attend_ot_out !=null)
                    {
                        $policy             = TimePolicyModel::where('id', $policy_id)->first();

                        $time_in        = date("H:i:s", strtotime($policy->time_in));
                        $time_out       = date("H:i:s", strtotime($policy->time_out));
                        $ot_time_in     = date("H:i:s", strtotime($policy->ot_time_in));
                        $ot_time_out    = date("H:i:s", strtotime($policy->ot_time_out));


                        //setting from system
                        $win            = $date . ' ' . $time_in ;
                        $wout           = $date . ' ' . $time_out;
                        $ot_in          = $date . ' ' . $ot_time_in;
                        $ot_out         = $date . ' ' . $ot_time_out;



                        $h_d_rate       = getOne("SELECT DISTINCT id  FROM   nso007_hr_holiday
                                                    WHERE DATE(from_date) <= DATE ('{$date}')
                                                    AND DATE(to_date) >= DATE ('{$date}') LIMIT 1 ");

                        //check from fingerprint datebase
                        $cin            =   $attend_check_in->minCheckInDate;
                        $cout           =   $attend_check_out->maxCheckOutDate;
                        $otin           =   $attend_ot_in->minOvertimeInDate;
                        $otout          =   $attend_ot_out->maxOvertimeOutDate;

                        if ($h_d_rate > 0) {
                            //echo "Holiday";
                            $total_ot   = IDate::dateTimeDiff($cin, $cout) - 120;
                            $total      = 0;
                            $ot         = 0;
                            $late       = 0;
                            $before     = 0;
                            $ot_type    = 'othol';
                            $ot_hol     = $total_ot ? $total_ot : 0;
                            $ot_sun     = 0;

                        } else {
                            if ($s_day == 'Sunday') {

                                //echo "Sunday";
                                $total_ot   = IDate::dateTimeDiff($cin, $cout) - 120;
                                $total      = 0;
                                $ot         = 0;
                                $late       = 0;
                                $before     = 0;
                                $ot_type    = 'otsun';
                                $ot_sun     = $total_ot ? $total_ot : 0;
                                $ot_hol     = 0;

                            } else {

                                //echo "Monday - Saturday";
                                $diffIn     = IDate::dateTimeDiff($cin, $win);
                                $diffOut    = IDate::dateTimeDiff($wout, $cout);
                                $late       = 0;
                                $before     = 0;

                                if ($diffIn >= 0) {
                                    $rin    = $win;
                                }else{
                                    $late   = (-1) * $diffIn;
                                }
                                if ($diffOut >= 0) {
                                    $rout   = $wout;
                                }else{
                                    $before =  (-1) * $diffOut;
                                }

                                $total_ot   = 0;
                                $total      = IDate::dateTimeDiff($cin, $cout) - 60;
                                $ot_type    = 'otnor';
                                $ot         = IDate::dateTimeDiff($otin, $otout);
                                $ot_sun     = 0;
                                $ot_hol     = 0;
                            }
                        }
                        //delete emp_id and same date
                        TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereDate('att_date', $date)
                            ->delete();
                        //save to database
                        $m = TimeAttendanceGenModel::where('emp_id', $emp_id)
                            ->whereRaw(" (date(cin) = '{$date}' OR  date(cout) = '{$date}')")
                            ->first();
                        if ($m == null) {
                            $m = new TimeAttendanceGenModel();
                        }

                        $m->emp_id          = $emp_id;
                        $m->att_date        = $date;
                        $m->f_month         = $month;
                        $m->f_year          = $year;

                        if ($cin) {
                            $m->cin         = $cin;
                        }
                        if ($cout) {
                            $m->cout        = $cout;
                        }
                        if($otin){
                            $m->otin        = $otin;
                        }
                        if($otout){
                            $m->otout       = $otout;
                        }
                        if ($cin && $cout) {

                            $m->total       = $total;
                            $m->late        = $late;
                            $m->before      = $before;
                            $m->ot          = $ot;
                            $m->ot_type     = $ot_type;
                            $m->total_ot    = $ot ? $ot : 0;
                            $m->total_sun   = $ot_sun>=60?$ot_sun:0;
                            $m->total_hol   = $ot_hol>=60?$ot_hol:0;

                        }
                        if ($cin  == null || $cout == null) {
                            $m->missing = 1;
                        }

                        $m->save();
                    }
                }
            }
        }
    }

    public static function gAttend($month_year = null, $from_date = null, $to_date = null)
    {
        $m_y    = explode('-', $month_year);
        $month  = isset($m_y[0]) ? $m_y[0] : 0;
        $year   = isset($m_y[1]) ? $m_y[1] : 0;

        $attend_check_in    = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minCheckInDate'),'finger_print_no', DB::Raw('DATE_FORMAT(check_in_out,"%Y-%m-%d") AS date'))
            ->where('check_type', 'C/In')
            ->groupBy(['finger_print_no','date'])
            ->get();

        $attend_check_out   = TimeAttendanceModel::select(DB::raw('MAX(check_in_out) AS maxCheckOutDate'),'finger_print_no', DB::Raw('DATE_FORMAT(check_in_out,"%Y-%m-%d") AS date'))
            ->where('check_type', 'C/Out')
            ->groupBy(['finger_print_no','date'])
            ->get();
        $attend_ot_in       = TimeAttendanceModel::select(DB::raw('MIN(check_in_out) AS minOvertimeInDate'),'finger_print_no', DB::Raw('DATE_FORMAT(check_in_out,"%Y-%m-%d") AS date'))
            ->where('check_type', 'OverTime In')
            ->groupBy(['finger_print_no','date'])
            ->get();

        $attend_ot_out      = TimeAttendanceModel::select(DB::raw('MAX(check_in_out) AS maxOvertimeOutDate'),'finger_print_no', DB::Raw('DATE_FORMAT(check_in_out,"%Y-%m-%d") AS date'))
            ->where('check_type', 'OverTime Out')
            ->groupBy(['finger_print_no','date'])
            ->get();

        if ($attend_check_in != null || $attend_check_out != null || $attend_ot_in != null || $attend_ot_out !=null)
        {
            foreach ($attend_check_in as $data)
            {
                $emp_id             = User::where('fingerprint_no', $data->finger_print_no)->first();
                $m                  = new TimeAttendanceGenModel();
                $m->cin             = $data->minCheckInDate;
                $m->f_month         = $month;
                $m->f_year          = $year;
                $m->att_date        = $data->date;
                $m->emp_id          = $emp_id->id;
                $m->save();
            }
            foreach ($attend_check_out as $data)
            {
                TimeAttendanceGenModel::where('att_date', $data->date)->update([
                    'cout'     => $data->maxCheckOutDate,
                ]);
            }
            foreach ($attend_ot_in as $data)
            {
                TimeAttendanceGenModel::where('att_date', $data->date)->update([
                    'otin'     => $data->minOvertimeInDate,
                ]);
            }
            foreach ($attend_ot_out as $data)
            {
                TimeAttendanceGenModel::where('att_date', $data->date)->update([
                    'otout'     => $data->maxOvertimeOutDate,
                ]);
            }
        }
    }
}
